/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointFactory;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.Wire;
import org.apache.tuscany.sca.assembly.builder.DefaultEndpointBuilder;
import org.apache.tuscany.sca.assembly.builder.EndpointBuilder;
import org.apache.tuscany.sca.assembly.builder.impl.PolicyConfigurationUtil;
import org.apache.tuscany.sca.assembly.builder.impl.ReferenceConfigurationUtil;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.util.PolicyComputationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseWireBuilderImpl {
    private Monitor monitor;
    private AssemblyFactory assemblyFactory;
    private EndpointFactory endpointFactory;
    private InterfaceContractMapper interfaceContractMapper;
    private Map<Binding, Binding> bindingMap;
    private EndpointBuilder endpointBuilder;

    protected BaseWireBuilderImpl(AssemblyFactory assemblyFactory, EndpointFactory endpointFactory, InterfaceContractMapper interfaceContractMapper, Monitor monitor, Map<Binding, Binding> bindingMap) {
        this.assemblyFactory = assemblyFactory;
        this.endpointFactory = endpointFactory;
        this.interfaceContractMapper = interfaceContractMapper;
        this.monitor = monitor;
        this.bindingMap = bindingMap;
        this.endpointBuilder = new DefaultEndpointBuilder(monitor, bindingMap);
    }

    protected void wireComponentReferences(Composite composite) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.wireComponentReferences((Composite)implementation);
        }
        HashMap<String, Component> components = new HashMap<String, Component>();
        HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
        HashMap<String, ComponentReference> componentReferences = new HashMap<String, ComponentReference>();
        this.indexComponentsServicesAndReferences(composite, components, componentServices, componentReferences);
        this.connectWires(composite, componentServices, componentReferences);
        this.connectComponentReferences(composite, components, componentServices, componentReferences);
        for (ComponentReference componentReference : componentReferences.values()) {
            if (ReferenceConfigurationUtil.validateMultiplicityAndTargets(componentReference.getMultiplicity(), componentReference.getTargets(), componentReference.getBindings())) continue;
            if (componentReference.getTargets().isEmpty()) {
                boolean promoted = false;
                for (Reference reference : composite.getReferences()) {
                    CompositeReference compositeReference = (CompositeReference)reference;
                    if (!compositeReference.getPromotedReferences().contains(componentReference)) continue;
                    promoted = true;
                    break;
                }
                if (promoted || componentReference.isCallback()) continue;
                this.warning("ReferenceWithoutTargets", composite, composite.getName().toString(), componentReference.getName());
                continue;
            }
            this.warning("TooManyReferenceTargets", composite, componentReference.getName());
        }
        for (ComponentReference componentReference : componentReferences.values()) {
            componentReference.getTargets().clear();
        }
    }

    private void indexComponentsServicesAndReferences(Composite composite, Map<String, Component> components, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences) {
        for (Component component : composite.getComponents()) {
            String uri;
            components.put(component.getName(), component);
            ComponentService nonCallbackService = null;
            int nonCallbackServices = 0;
            for (ComponentService componentService : component.getServices()) {
                uri = component.getName() + '/' + componentService.getName();
                componentServices.put(uri, componentService);
                boolean promotedService = false;
                if (componentService.getName() != null && componentService.getName().indexOf("$promoted$") > -1) {
                    promotedService = true;
                }
                if (componentService.isCallback() || promotedService) continue;
                if (nonCallbackServices == 0) {
                    nonCallbackService = componentService;
                }
                ++nonCallbackServices;
            }
            if (nonCallbackServices == 1) {
                componentServices.put(component.getName(), nonCallbackService);
            }
            for (ComponentReference componentReference : component.getReferences()) {
                uri = component.getName() + '/' + componentReference.getName();
                componentReferences.put(uri, componentReference);
            }
        }
    }

    private void warning(String message, Object model, String ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.WARNING, model, message, (Object[])messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = null;
            problem = new ProblemImpl(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    protected void connectCompositeReferencesAndServices(Composite composite) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.connectCompositeReferencesAndServices((Composite)implementation);
        }
        HashMap<String, Component> components = new HashMap<String, Component>();
        HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
        HashMap<String, ComponentReference> componentReferences = new HashMap<String, ComponentReference>();
        this.indexComponentsServicesAndReferences(composite, components, componentServices, componentReferences);
        this.connectCompositeServices(composite, components, componentServices);
        this.connectCompositeReferences(composite, componentReferences);
    }

    private void connectCompositeServices(Composite composite, Map<String, Component> components, Map<String, ComponentService> componentServices) {
        for (Component component : composite.getComponents()) {
            if (!(component.getImplementation() instanceof Composite)) continue;
            for (ComponentService componentService : component.getServices()) {
                Service service = componentService.getService();
                if (service == null || componentService.getInterfaceContract() != null) continue;
                componentService.setInterfaceContract(service.getInterfaceContract());
            }
        }
        for (Service service : composite.getServices()) {
            ComponentService componentService;
            CompositeService compositeService = (CompositeService)service;
            componentService = compositeService.getPromotedService();
            if (componentService == null || !componentService.isUnresolved()) continue;
            String promotedComponentName = compositeService.getPromotedComponent().getName();
            String promotedServiceName = componentService.getName() != null ? promotedComponentName + '/' + componentService.getName() : promotedComponentName;
            ComponentService promotedService = componentServices.get(promotedServiceName);
            if (promotedService != null) {
                boolean isCompatible;
                Component promotedComponent = components.get(promotedComponentName);
                compositeService.setPromotedComponent(promotedComponent);
                compositeService.setPromotedService(promotedService);
                InterfaceContract compositeServiceInterfaceContract = compositeService.getInterfaceContract();
                InterfaceContract promotedServiceInterfaceContract = promotedService.getInterfaceContract();
                if (compositeServiceInterfaceContract == null) {
                    compositeService.setInterfaceContract(promotedServiceInterfaceContract);
                    continue;
                }
                if (promotedServiceInterfaceContract == null || (isCompatible = this.interfaceContractMapper.isCompatible(compositeServiceInterfaceContract, promotedServiceInterfaceContract))) continue;
                this.warning("ServiceInterfaceNotSubSet", compositeService, promotedServiceName);
                continue;
            }
            this.warning("PromotedServiceNotFound", composite, composite.getName().toString(), promotedServiceName);
        }
    }

    private void connectCompositeReferences(Composite composite, Map<String, ComponentReference> componentReferences) {
        for (Component component : composite.getComponents()) {
            if (!(component.getImplementation() instanceof Composite)) continue;
            for (ComponentReference componentReference : component.getReferences()) {
                Reference reference = componentReference.getReference();
                if (reference == null || componentReference.getInterfaceContract() != null) continue;
                componentReference.setInterfaceContract(reference.getInterfaceContract());
            }
        }
        for (Reference reference : composite.getReferences()) {
            CompositeReference compositeReference = (CompositeReference)reference;
            List<ComponentReference> promotedReferences = compositeReference.getPromotedReferences();
            int n = promotedReferences.size();
            for (int i = 0; i < n; ++i) {
                ComponentReference componentReference = promotedReferences.get(i);
                if (!componentReference.isUnresolved()) continue;
                String componentReferenceName = componentReference.getName();
                if ((componentReference = componentReferences.get(componentReferenceName)) != null) {
                    boolean isCompatible;
                    promotedReferences.set(i, componentReference);
                    InterfaceContract compositeReferenceInterfaceContract = compositeReference.getInterfaceContract();
                    InterfaceContract componentReferenceInterfaceContract = componentReference.getInterfaceContract();
                    if (compositeReferenceInterfaceContract == null) {
                        compositeReference.setInterfaceContract(componentReferenceInterfaceContract);
                        continue;
                    }
                    if (componentReferenceInterfaceContract == null || (isCompatible = this.interfaceContractMapper.isCompatible(compositeReferenceInterfaceContract, componentReferenceInterfaceContract))) continue;
                    this.warning("ReferenceInterfaceNotSubSet", compositeReference, componentReferenceName);
                    continue;
                }
                this.warning("PromotedReferenceNotFound", composite, composite.getName().toString(), componentReferenceName);
            }
        }
    }

    private List<Endpoint> createComponentReferenceTargets(Composite composite, Map<String, Component> components, Map<String, ComponentService> componentServices, ComponentReference componentReference) {
        Endpoint endpoint;
        Component targetComponent;
        String name;
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (!componentReference.getTargets().isEmpty()) {
            for (Binding binding : componentReference.getBindings()) {
                if (binding.getURI() == null) continue;
                this.warning("ReferenceEndPointMixWithTarget", composite, componentReference.getName());
            }
            for (ComponentService componentService : componentReference.getTargets()) {
                name = componentService.getName();
                ComponentService targetComponentService = componentServices.get(name);
                int s = name.indexOf(47);
                targetComponent = s == -1 ? components.get(name) : components.get(name.substring(0, s));
                if (targetComponentService != null) {
                    if (componentReference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatible(componentReference.getInterfaceContract(), targetComponentService.getInterfaceContract())) {
                        endpoint = this.endpointFactory.createEndpoint();
                        endpoint.setTargetName(targetComponent.getName());
                        endpoint.setSourceComponent(null);
                        endpoint.setSourceComponentReference(componentReference);
                        endpoint.setInterfaceContract(componentReference.getInterfaceContract());
                        endpoint.setTargetComponent(targetComponent);
                        endpoint.setTargetComponentService(targetComponentService);
                        endpoint.getCandidateBindings().addAll(componentReference.getBindings());
                        endpoints.add(endpoint);
                        componentService.setUnresolved(false);
                        continue;
                    }
                    this.warning("ReferenceIncompatibleInterface", composite, composite.getName().toString(), componentReference.getName(), componentService.getName());
                    continue;
                }
                componentService.getBindings().addAll(componentReference.getBindings());
                endpoint = this.endpointFactory.createEndpoint();
                endpoint.setTargetName(name);
                endpoint.setSourceComponent(null);
                endpoint.setSourceComponentReference(componentReference);
                endpoint.setInterfaceContract(componentReference.getInterfaceContract());
                endpoint.getCandidateBindings().addAll(componentReference.getBindings());
                endpoints.add(endpoint);
                this.warning("ComponentReferenceTargetNotFound", composite, composite.getName().toString(), componentService.getName());
            }
        } else if (componentReference.getReference() != null && !componentReference.getReference().getTargets().isEmpty()) {
            for (ComponentService componentService : componentReference.getReference().getTargets()) {
                name = componentService.getName();
                ComponentService targetComponentService = componentServices.get(name);
                int s = name.indexOf(47);
                targetComponent = s == -1 ? components.get(name) : components.get(name.substring(0, s));
                if (targetComponentService != null) {
                    if (componentReference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatible(componentReference.getInterfaceContract(), targetComponentService.getInterfaceContract())) {
                        endpoint = this.endpointFactory.createEndpoint();
                        endpoint.setTargetName(targetComponent.getName());
                        endpoint.setSourceComponent(null);
                        endpoint.setSourceComponentReference(componentReference);
                        endpoint.setInterfaceContract(componentReference.getInterfaceContract());
                        endpoint.setTargetComponent(targetComponent);
                        endpoint.setTargetComponentService(targetComponentService);
                        endpoint.getCandidateBindings().addAll(componentReference.getBindings());
                        endpoints.add(endpoint);
                        componentService.setUnresolved(false);
                        continue;
                    }
                    this.warning("ComponentIncompatibleInterface", composite, componentReference.getName(), componentService.getName());
                    continue;
                }
                componentService.getBindings().addAll(componentReference.getBindings());
                endpoint = this.endpointFactory.createEndpoint();
                endpoint.setTargetName(name);
                endpoint.setSourceComponent(null);
                endpoint.setSourceComponentReference(componentReference);
                endpoint.setInterfaceContract(componentReference.getInterfaceContract());
                endpoint.getCandidateBindings().addAll(componentReference.getBindings());
                endpoints.add(endpoint);
                this.warning("ComponentReferenceTargetNotFound", composite, composite.getName().toString(), componentService.getName());
            }
        } else if (componentReference.getAutowire() == Boolean.TRUE) {
            Multiplicity multiplicity = componentReference.getMultiplicity();
            block5: for (Component targetComponent2 : composite.getComponents()) {
                boolean skipSelf = false;
                for (ComponentReference targetComponentReference : targetComponent2.getReferences()) {
                    if (componentReference != targetComponentReference) continue;
                    skipSelf = true;
                }
                if (skipSelf) continue;
                for (ComponentService targetComponentService : targetComponent2.getServices()) {
                    if (componentReference.getInterfaceContract() != null && !this.interfaceContractMapper.isCompatible(componentReference.getInterfaceContract(), targetComponentService.getInterfaceContract())) continue;
                    endpoint = this.endpointFactory.createEndpoint();
                    endpoint.setTargetName(targetComponent2.getName());
                    endpoint.setSourceComponent(null);
                    endpoint.setSourceComponentReference(componentReference);
                    endpoint.setInterfaceContract(componentReference.getInterfaceContract());
                    endpoint.setTargetComponent(targetComponent2);
                    endpoint.setTargetComponentService(targetComponentService);
                    endpoint.getCandidateBindings().addAll(componentReference.getBindings());
                    endpoints.add(endpoint);
                    if (multiplicity != Multiplicity.ZERO_ONE && multiplicity != Multiplicity.ONE_ONE) continue;
                    continue block5;
                }
            }
            if ((multiplicity == Multiplicity.ONE_N || multiplicity == Multiplicity.ONE_ONE) && endpoints.size() == 0) {
                this.warning("NoComponentReferenceTarget", componentReference, componentReference.getName());
            }
        }
        if (endpoints.isEmpty()) {
            for (Binding binding : componentReference.getBindings()) {
                String uri = binding.getURI();
                if (uri == null) continue;
                Component targetComponent3 = null;
                ComponentService targetComponentService = null;
                String path = null;
                try {
                    path = URI.create(uri).getPath();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (path != null) {
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    targetComponentService = componentServices.get(path);
                    int s = path.indexOf(47);
                    targetComponent3 = s == -1 ? components.get(path) : components.get(path.substring(0, s));
                }
                if (targetComponentService != null) {
                    if (componentReference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatible(componentReference.getInterfaceContract(), targetComponentService.getInterfaceContract())) {
                        Endpoint endpoint2 = this.endpointFactory.createEndpoint();
                        endpoint2.setTargetName(targetComponent3.getName());
                        endpoint2.setSourceComponent(null);
                        endpoint2.setSourceComponentReference(componentReference);
                        endpoint2.setInterfaceContract(componentReference.getInterfaceContract());
                        endpoint2.setTargetComponent(targetComponent3);
                        endpoint2.setTargetComponentService(targetComponentService);
                        endpoint2.getCandidateBindings().add(binding);
                        endpoints.add(endpoint2);
                        continue;
                    }
                    this.warning("ReferenceIncompatibleInterface", composite, composite.getName().toString(), componentReference.getName(), uri);
                    continue;
                }
                Endpoint endpoint3 = this.endpointFactory.createEndpoint();
                endpoint3.setTargetName(uri);
                endpoint3.setSourceComponent(null);
                endpoint3.setSourceComponentReference(componentReference);
                endpoint3.setInterfaceContract(componentReference.getInterfaceContract());
                endpoint3.setSourceBinding(binding);
                endpoints.add(endpoint3);
            }
        }
        return endpoints;
    }

    private void connectComponentReferences(Composite composite, Map<String, Component> components, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences) {
        for (ComponentReference componentReference : componentReferences.values()) {
            List<Endpoint> endpoints = this.createComponentReferenceTargets(composite, components, componentServices, componentReference);
            componentReference.getEndpoints().addAll(endpoints);
            boolean endpointsRequireAutomaticResolution = false;
            for (Endpoint endpoint : endpoints) {
                endpointsRequireAutomaticResolution = endpoint.isUnresolved();
            }
            if (!endpointsRequireAutomaticResolution) continue;
            for (Endpoint endpoint : endpoints) {
                this.endpointBuilder.build(endpoint);
            }
            componentReference.getBindings().clear();
            if (componentReference.getCallback() != null) {
                componentReference.getCallback().getBindings().clear();
            }
            for (Endpoint endpoint : endpoints) {
                if (endpoint.isUnresolved()) continue;
                componentReference.getBindings().add(endpoint.getSourceBinding());
                if (componentReference.getCallback() == null) continue;
                componentReference.getCallback().getBindings().add(endpoint.getSourceCallbackBinding());
            }
        }
    }

    private void connectWires(Composite composite, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences) {
        List<Wire> wires = composite.getWires();
        int n = wires.size();
        for (int i = 0; i < n; ++i) {
            ComponentService resolvedService;
            ComponentReference resolvedReference;
            Wire wire = wires.get(i);
            ComponentReference source = wire.getSource();
            if (source != null && source.isUnresolved()) {
                resolvedReference = componentReferences.get(source.getName());
                if (resolvedReference != null) {
                    wire.setSource(resolvedReference);
                } else {
                    this.warning("WireSourceNotFound", composite, source.getName());
                }
            } else {
                resolvedReference = wire.getSource();
            }
            ComponentService target = wire.getTarget();
            if (target != null && target.isUnresolved()) {
                resolvedService = componentServices.get(target.getName());
                if (resolvedService != null) {
                    wire.setTarget(target);
                } else {
                    this.warning("WireTargetNotFound", composite, source.getName());
                }
            } else {
                resolvedService = wire.getTarget();
            }
            if (resolvedReference == null || resolvedService == null) continue;
            if (resolvedReference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatible(resolvedReference.getInterfaceContract(), resolvedService.getInterfaceContract())) {
                resolvedReference.getTargets().add(wire.getTarget());
                continue;
            }
            this.warning("WireIncompatibleInterface", composite, source.getName(), target.getName());
        }
        composite.getWires().clear();
    }

    private void addPoliciesFromPromotedService(CompositeService compositeService) {
        PolicyComputationUtils.addInheritedIntents((List)compositeService.getPromotedService().getRequiredIntents(), (List)compositeService.getRequiredIntents());
        PolicyComputationUtils.addInheritedPolicySets((List)compositeService.getPromotedService().getPolicySets(), (List)compositeService.getPolicySets(), (boolean)true);
        this.addInheritedOperationConfigurations(compositeService.getPromotedService(), compositeService);
    }

    private void addPoliciesFromPromotedReference(CompositeReference compositeReference) {
        for (ComponentReference promotedReference : compositeReference.getPromotedReferences()) {
            PolicyComputationUtils.addInheritedIntents((List)promotedReference.getRequiredIntents(), (List)compositeReference.getRequiredIntents());
            PolicyComputationUtils.addInheritedPolicySets((List)promotedReference.getPolicySets(), (List)compositeReference.getPolicySets(), (boolean)true);
            this.addInheritedOperationConfigurations(promotedReference, compositeReference);
        }
    }

    protected void computePolicies(Composite composite) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.computePolicies((Composite)implementation);
        }
        for (Component component : composite.getComponents()) {
            PolicyConfigurationUtil.inheritDefaultPolicies(component, component.getServices());
            PolicyConfigurationUtil.inheritDefaultPolicies(component, component.getReferences());
            Implementation implemenation = component.getImplementation();
            try {
                PolicyConfigurationUtil.computeImplementationIntentsAndPolicySets(implemenation, component);
            }
            catch (Exception e) {
                this.error("PolicyRelatedException", implemenation, e);
            }
            for (ComponentService componentService : component.getServices()) {
                Service service = componentService.getService();
                if (service != null) {
                    PolicyComputationUtils.addInheritedIntents((List)service.getRequiredIntents(), (List)componentService.getRequiredIntents());
                    PolicyComputationUtils.addInheritedPolicySets((List)service.getPolicySets(), (List)componentService.getPolicySets(), (boolean)true);
                    ArrayList<ConfiguredOperation> opsFromComponentType = new ArrayList<ConfiguredOperation>();
                    for (ConfiguredOperation ctsConfOp : service.getConfiguredOperations()) {
                        boolean notFound = true;
                        for (ConfiguredOperation csConfOp : componentService.getConfiguredOperations()) {
                            if (!csConfOp.getName().equals(ctsConfOp.getName())) continue;
                            PolicyComputationUtils.addInheritedIntents((List)ctsConfOp.getRequiredIntents(), (List)csConfOp.getRequiredIntents());
                            PolicyComputationUtils.addInheritedPolicySets((List)ctsConfOp.getPolicySets(), (List)csConfOp.getPolicySets(), (boolean)true);
                            notFound = false;
                        }
                        if (!notFound) continue;
                        opsFromComponentType.add(ctsConfOp);
                    }
                    componentService.getConfiguredOperations().addAll(opsFromComponentType);
                }
                try {
                    PolicyConfigurationUtil.computeIntentsForOperations(componentService);
                    PolicyConfigurationUtil.computeBindingIntentsAndPolicySets(componentService);
                    PolicyConfigurationUtil.determineApplicableBindingPolicySets(componentService, null);
                }
                catch (Exception e) {
                    this.error("PolicyRelatedException", componentService, e);
                }
            }
            for (ComponentReference componentReference : component.getReferences()) {
                Reference reference = componentReference.getReference();
                if (reference != null) {
                    PolicyComputationUtils.addInheritedIntents((List)reference.getRequiredIntents(), (List)componentReference.getRequiredIntents());
                    PolicyComputationUtils.addInheritedPolicySets((List)reference.getPolicySets(), (List)componentReference.getPolicySets(), (boolean)true);
                }
                try {
                    PolicyConfigurationUtil.computeIntentsForOperations(componentReference);
                    PolicyConfigurationUtil.computeBindingIntentsAndPolicySets(componentReference);
                    PolicyConfigurationUtil.determineApplicableBindingPolicySets(componentReference, null);
                    if (componentReference.getCallback() == null) continue;
                    PolicyComputationUtils.addInheritedIntents((List)componentReference.getRequiredIntents(), (List)componentReference.getCallback().getRequiredIntents());
                    PolicyComputationUtils.addInheritedPolicySets((List)componentReference.getPolicySets(), (List)componentReference.getCallback().getPolicySets(), (boolean)false);
                }
                catch (Exception e) {
                    this.error("PolicyRelatedException", componentReference, e);
                }
            }
        }
        PolicyConfigurationUtil.inheritDefaultPolicies(composite, composite.getServices());
        PolicyConfigurationUtil.inheritDefaultPolicies(composite, composite.getReferences());
        for (Service service : composite.getServices()) {
            this.addPoliciesFromPromotedService((CompositeService)service);
            try {
                PolicyConfigurationUtil.computeIntentsForOperations(service);
                PolicyConfigurationUtil.computeBindingIntentsAndPolicySets(service);
                PolicyConfigurationUtil.determineApplicableBindingPolicySets(service, null);
            }
            catch (Exception e) {
                this.error("PolicyRelatedException", service, e);
            }
        }
        for (Reference reference : composite.getReferences()) {
            CompositeReference compReference = (CompositeReference)reference;
            this.addPoliciesFromPromotedReference(compReference);
            try {
                PolicyConfigurationUtil.computeIntentsForOperations(reference);
                if (compReference.getCallback() != null) {
                    PolicyComputationUtils.addInheritedIntents((List)compReference.getRequiredIntents(), (List)compReference.getCallback().getRequiredIntents());
                    PolicyComputationUtils.addInheritedPolicySets((List)compReference.getPolicySets(), (List)compReference.getCallback().getPolicySets(), (boolean)false);
                }
                PolicyConfigurationUtil.computeBindingIntentsAndPolicySets(reference);
                PolicyConfigurationUtil.determineApplicableBindingPolicySets(reference, null);
            }
            catch (Exception e) {
                this.error("PolicyRelatedException", reference, e);
            }
        }
    }

    private void addInheritedOperationConfigurations(OperationsConfigurator source, OperationsConfigurator target) {
        boolean found = false;
        ArrayList<ConfiguredOperation> additionalOperations = new ArrayList<ConfiguredOperation>();
        for (ConfiguredOperation sourceConfOp : source.getConfiguredOperations()) {
            for (ConfiguredOperation targetConfOp : target.getConfiguredOperations()) {
                if (!sourceConfOp.getName().equals(targetConfOp.getName())) continue;
                PolicyComputationUtils.addInheritedIntents((List)sourceConfOp.getRequiredIntents(), (List)targetConfOp.getRequiredIntents());
                PolicyComputationUtils.addInheritedPolicySets((List)sourceConfOp.getPolicySets(), (List)targetConfOp.getPolicySets(), (boolean)true);
                found = true;
                break;
            }
            if (found) continue;
            additionalOperations.add(sourceConfOp);
        }
        if (!additionalOperations.isEmpty()) {
            target.getConfiguredOperations().addAll(additionalOperations);
        }
    }
}

