/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;
import org.apache.tomcat.util.net.jsse.openssl.OpenSSLCipherConfigurationParser;
import org.apache.tomcat.util.res.StringManager;

public class JSSESocketFactory
implements ServerSocketFactory,
SSLUtil {
    private static final Log log = LogFactory.getLog(JSSESocketFactory.class);
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.jsse.res");
    private static final String defaultProtocol = "TLS";
    private static final String defaultKeystoreType = "JKS";
    private static final String defaultKeystoreFile = System.getProperty("user.home") + "/.keystore";
    private static final int defaultSessionCacheSize = 0;
    private static final int defaultSessionTimeout = 86400;
    private static final String ALLOW_ALL_SUPPORTED_CIPHERS = "ALL";
    public static final String DEFAULT_KEY_PASS = "changeit";
    private AbstractEndpoint<?> endpoint;
    private final boolean rfc5746Supported;
    private final String[] defaultServerProtocols;
    private final String[] defaultServerCipherSuites;
    protected SSLServerSocketFactory sslProxy = null;
    protected String[] enabledCiphers;
    protected String[] enabledProtocols;
    protected boolean allowUnsafeLegacyRenegotiation = false;
    protected boolean requireClientAuth = false;
    protected boolean wantClientAuth = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSSESocketFactory(AbstractEndpoint<?> endpoint) {
        SSLServerSocket socket;
        SSLContext context;
        this.endpoint = endpoint;
        String sslProtocol = endpoint.getSslProtocol();
        if (sslProtocol == null) {
            sslProtocol = defaultProtocol;
        }
        try {
            context = SSLContext.getInstance(sslProtocol);
            context.init(null, null, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        SSLServerSocketFactory ssf = context.getServerSocketFactory();
        String[] supportedCiphers = ssf.getSupportedCipherSuites();
        boolean found = false;
        for (String cipher : supportedCiphers) {
            if (!"TLS_EMPTY_RENEGOTIATION_INFO_SCSV".equals(cipher)) continue;
            found = true;
            break;
        }
        this.rfc5746Supported = found;
        try {
            socket = (SSLServerSocket)ssf.createServerSocket();
        }
        catch (IOException e) {
            this.defaultServerCipherSuites = new String[0];
            this.defaultServerProtocols = new String[0];
            log.warn((Object)sm.getString("jsse.noDefaultCiphers", endpoint.getName()));
            log.warn((Object)sm.getString("jsse.noDefaultProtocols", endpoint.getName()));
            return;
        }
        try {
            this.defaultServerCipherSuites = socket.getEnabledCipherSuites();
            if (this.defaultServerCipherSuites.length == 0) {
                log.warn((Object)sm.getString("jsse.noDefaultCiphers", endpoint.getName()));
            }
            ArrayList<String> filteredProtocols = new ArrayList<String>();
            for (String protocol : socket.getEnabledProtocols()) {
                if (protocol.toUpperCase(Locale.ENGLISH).contains("SSL")) {
                    log.debug((Object)sm.getString("jsse.excludeDefaultProtocol", protocol));
                    continue;
                }
                filteredProtocols.add(protocol);
            }
            this.defaultServerProtocols = filteredProtocols.toArray(new String[filteredProtocols.size()]);
            if (this.defaultServerProtocols.length == 0) {
                log.warn((Object)sm.getString("jsse.noDefaultProtocols", endpoint.getName()));
            }
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.warn((Object)sm.getString("jsse.exceptionOnClose"), (Throwable)e);
            }
        }
    }

    @Override
    public ServerSocket createSocket(int port) throws IOException {
        this.init();
        ServerSocket socket = this.sslProxy.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public ServerSocket createSocket(int port, int backlog) throws IOException {
        this.init();
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        this.init();
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public Socket acceptSocket(ServerSocket socket) throws IOException {
        SSLSocket asock = null;
        try {
            asock = (SSLSocket)socket.accept();
        }
        catch (SSLException e) {
            throw new SocketException("SSL handshake error" + e.toString());
        }
        return asock;
    }

    @Override
    public void handshake(Socket sock) throws IOException {
        SSLSession session = ((SSLSocket)sock).getSession();
        if (session.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
            throw new IOException("SSL handshake failed. Ciper suite in SSL Session is SSL_NULL_WITH_NULL_NULL");
        }
        if (!this.allowUnsafeLegacyRenegotiation && !this.rfc5746Supported) {
            ((SSLSocket)sock).setEnabledCipherSuites(new String[0]);
        }
    }

    @Override
    public String[] getEnableableCiphers(SSLContext context) {
        String requestedCiphersStr = this.endpoint.getCiphers();
        if (ALLOW_ALL_SUPPORTED_CIPHERS.equals(requestedCiphersStr)) {
            return context.getSupportedSSLParameters().getCipherSuites();
        }
        if (requestedCiphersStr == null || requestedCiphersStr.trim().length() == 0) {
            return this.defaultServerCipherSuites;
        }
        List<Object> requestedCiphers = new ArrayList();
        if (requestedCiphersStr.indexOf(58) != -1) {
            requestedCiphers = OpenSSLCipherConfigurationParser.parseExpression(requestedCiphersStr);
        } else {
            for (String rc : requestedCiphersStr.split(",")) {
                String cipher = rc.trim();
                if (cipher.length() <= 0) continue;
                requestedCiphers.add(cipher);
            }
        }
        if (requestedCiphers.isEmpty()) {
            return this.defaultServerCipherSuites;
        }
        ArrayList<Object> ciphers = new ArrayList<Object>(requestedCiphers);
        ciphers.retainAll(Arrays.asList(context.getSupportedSSLParameters().getCipherSuites()));
        if (ciphers.isEmpty()) {
            log.warn((Object)sm.getString("jsse.requested_ciphers_not_supported", requestedCiphersStr));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("jsse.enableable_ciphers", ciphers));
            if (ciphers.size() != requestedCiphers.size()) {
                ArrayList<Object> skipped = new ArrayList<Object>(requestedCiphers);
                skipped.removeAll(ciphers);
                log.debug((Object)sm.getString("jsse.unsupported_ciphers", skipped));
            }
        }
        return ciphers.toArray(new String[ciphers.size()]);
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    protected String getKeystorePassword() {
        String keystorePass = this.endpoint.getKeystorePass();
        if (keystorePass == null) {
            keystorePass = this.endpoint.getKeyPass();
        }
        if (keystorePass == null) {
            keystorePass = DEFAULT_KEY_PASS;
        }
        return keystorePass;
    }

    protected KeyStore getKeystore(String type, String provider, String pass) throws IOException {
        String keystoreFile = this.endpoint.getKeystoreFile();
        if (keystoreFile == null) {
            keystoreFile = defaultKeystoreFile;
        }
        return this.getStore(type, provider, keystoreFile, pass);
    }

    protected KeyStore getTrustStore(String keystoreType, String keystoreProvider) throws IOException {
        String truststoreProvider;
        String truststoreType;
        String truststorePassword;
        KeyStore trustStore = null;
        String truststoreFile = this.endpoint.getTruststoreFile();
        if (truststoreFile == null) {
            truststoreFile = System.getProperty("javax.net.ssl.trustStore");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Truststore = " + truststoreFile));
        }
        if ((truststorePassword = this.endpoint.getTruststorePass()) == null) {
            truststorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("TrustPass = " + truststorePassword));
        }
        if ((truststoreType = this.endpoint.getTruststoreType()) == null) {
            truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
        }
        if (truststoreType == null) {
            truststoreType = keystoreType;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trustType = " + truststoreType));
        }
        if ((truststoreProvider = this.endpoint.getTruststoreProvider()) == null) {
            truststoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
        }
        if (truststoreProvider == null) {
            truststoreProvider = keystoreProvider;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trustProvider = " + truststoreProvider));
        }
        if (truststoreFile != null) {
            try {
                trustStore = this.getStore(truststoreType, truststoreProvider, truststoreFile, truststorePassword);
            }
            catch (IOException ioe) {
                Throwable cause = ioe.getCause();
                if (cause instanceof UnrecoverableKeyException) {
                    log.warn((Object)sm.getString("jsse.invalid_truststore_password"), cause);
                    trustStore = this.getStore(truststoreType, truststoreProvider, truststoreFile, null);
                }
                throw ioe;
            }
        }
        return trustStore;
    }

    private KeyStore getStore(String type, String provider, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            if (!"PKCS11".equalsIgnoreCase(type) && !"".equalsIgnoreCase(path)) {
                File keyStoreFile = new File(path);
                if (!keyStoreFile.isAbsolute()) {
                    keyStoreFile = new File(System.getProperty("catalina.base"), path);
                }
                istream = new FileInputStream(keyStoreFile);
            }
            char[] storePass = null;
            if (pass != null && !"".equals(pass)) {
                storePass = pass.toCharArray();
            }
            ks.load(istream, storePass);
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)sm.getString("jsse.keystore_load_failed", type, path, fnfe.getMessage()), (Throwable)fnfe);
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            String msg = sm.getString("jsse.keystore_load_failed", type, path, ex.getMessage());
            log.error((Object)msg, (Throwable)ex);
            throw new IOException(msg);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    void init() throws IOException {
        try {
            String clientAuthStr = this.endpoint.getClientAuth();
            if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr)) {
                this.requireClientAuth = true;
            } else if ("want".equalsIgnoreCase(clientAuthStr)) {
                this.wantClientAuth = true;
            }
            SSLContext context = this.createSSLContext();
            context.init(this.getKeyManagers(), this.getTrustManagers(), null);
            SSLSessionContext sessionContext = context.getServerSessionContext();
            if (sessionContext != null) {
                this.configureSessionContext(sessionContext);
            }
            this.sslProxy = context.getServerSocketFactory();
            this.enabledCiphers = this.getEnableableCiphers(context);
            this.enabledProtocols = this.getEnableableProtocols(context);
            this.allowUnsafeLegacyRenegotiation = "true".equals(this.endpoint.getAllowUnsafeLegacyRenegotiation());
            this.checkConfig();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public SSLContext createSSLContext() throws Exception {
        String protocol = this.endpoint.getSslProtocol();
        if (protocol == null) {
            protocol = defaultProtocol;
        }
        SSLContext context = SSLContext.getInstance(protocol);
        return context;
    }

    @Override
    public KeyManager[] getKeyManagers() throws Exception {
        String algorithm;
        String keystoreType = this.endpoint.getKeystoreType();
        if (keystoreType == null) {
            keystoreType = defaultKeystoreType;
        }
        if ((algorithm = this.endpoint.getAlgorithm()) == null) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        return this.getKeyManagers(keystoreType, this.endpoint.getKeystoreProvider(), algorithm, this.endpoint.getKeyAlias());
    }

    @Override
    public TrustManager[] getTrustManagers() throws Exception {
        String algorithm;
        String truststoreType = this.endpoint.getTruststoreType();
        if (truststoreType == null) {
            truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
        }
        if (truststoreType == null) {
            truststoreType = this.endpoint.getKeystoreType();
        }
        if (truststoreType == null) {
            truststoreType = defaultKeystoreType;
        }
        if ((algorithm = this.endpoint.getTruststoreAlgorithm()) == null) {
            algorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        return this.getTrustManagers(truststoreType, this.endpoint.getKeystoreProvider(), algorithm);
    }

    @Override
    public void configureSessionContext(SSLSessionContext sslSessionContext) {
        int sessionCacheSize = this.endpoint.getSessionCacheSize() != null ? Integer.parseInt(this.endpoint.getSessionCacheSize()) : 0;
        int sessionTimeout = this.endpoint.getSessionTimeout() != null ? Integer.parseInt(this.endpoint.getSessionTimeout()) : 86400;
        sslSessionContext.setSessionCacheSize(sessionCacheSize);
        sslSessionContext.setSessionTimeout(sessionTimeout);
    }

    protected KeyManager[] getKeyManagers(String keystoreType, String keystoreProvider, String algorithm, String keyAlias) throws Exception {
        KeyManager[] kms = null;
        String keystorePass = this.getKeystorePassword();
        KeyStore ks = this.getKeystore(keystoreType, keystoreProvider, keystorePass);
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException(sm.getString("jsse.alias_no_key_entry", keyAlias));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        String keyPass = this.endpoint.getKeyPass();
        if (keyPass == null) {
            keyPass = keystorePass;
        }
        kmf.init(ks, keyPass.toCharArray());
        kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            String alias = keyAlias;
            if (defaultKeystoreType.equals(keystoreType)) {
                alias = alias.toLowerCase(Locale.ENGLISH);
            }
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], alias);
            }
        }
        return kms;
    }

    protected TrustManager[] getTrustManagers(String keystoreType, String keystoreProvider, String algorithm) throws Exception {
        String crlf = this.endpoint.getCrlFile();
        String className = this.endpoint.getTrustManagerClassName();
        if (className != null && className.length() > 0) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clazz = classLoader.loadClass(className);
            if (!TrustManager.class.isAssignableFrom(clazz)) {
                throw new InstantiationException(sm.getString("jsse.invalidTrustManagerClassName", className));
            }
            Object trustManagerObject = clazz.newInstance();
            TrustManager trustManager = (TrustManager)trustManagerObject;
            return new TrustManager[]{trustManager};
        }
        TrustManager[] tms = null;
        KeyStore trustStore = this.getTrustStore(keystoreType, keystoreProvider);
        if (trustStore != null || this.endpoint.getTrustManagerClassName() != null) {
            if (crlf == null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                CertPathParameters params = this.getParameters(algorithm, crlf, trustStore);
                CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
                tmf.init(mfp);
                tms = tmf.getTrustManagers();
            }
        }
        return tms;
    }

    protected CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        PKIXBuilderParameters xparams;
        PKIXBuilderParameters params = null;
        if ("PKIX".equalsIgnoreCase(algorithm)) {
            xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            Collection<? extends CRL> crls = this.getCRLs(crlf);
            CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
            CertStore store = CertStore.getInstance("Collection", csp);
            xparams.addCertStore(store);
            xparams.setRevocationEnabled(true);
            String trustLength = this.endpoint.getTrustMaxCertLength();
            if (trustLength != null) {
                try {
                    xparams.setMaxPathLength(Integer.parseInt(trustLength));
                }
                catch (Exception ex) {
                    log.warn((Object)("Bad maxCertLength: " + trustLength));
                }
            }
        } else {
            throw new CRLException("CRLs not supported for type: " + algorithm);
        }
        params = xparams;
        return params;
    }

    protected Collection<? extends CRL> getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        File crlFile = new File(crlf);
        if (!crlFile.isAbsolute()) {
            crlFile = new File(System.getProperty("catalina.base"), crlf);
        }
        Collection<? extends CRL> crls = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try (FileInputStream is = new FileInputStream(crlFile);){
                crls = cf.generateCRLs(is);
            }
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (CRLException crle) {
            throw crle;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        return crls;
    }

    @Override
    public String[] getEnableableProtocols(SSLContext context) {
        String[] requestedProtocols = this.endpoint.getSslEnabledProtocolsArray();
        if (requestedProtocols == null || requestedProtocols.length == 0) {
            return this.defaultServerProtocols;
        }
        ArrayList<String> protocols = new ArrayList<String>(Arrays.asList(requestedProtocols));
        protocols.retainAll(Arrays.asList(context.getSupportedSSLParameters().getProtocols()));
        if (protocols.isEmpty()) {
            log.warn((Object)sm.getString("jsse.requested_protocols_not_supported", Arrays.asList(requestedProtocols)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("jsse.enableable_protocols", protocols));
            if (protocols.size() != requestedProtocols.length) {
                ArrayList<String> skipped = new ArrayList<String>(Arrays.asList(requestedProtocols));
                skipped.removeAll(protocols);
                log.debug((Object)sm.getString("jsse.unsupported_protocols", skipped));
            }
        }
        return protocols.toArray(new String[protocols.size()]);
    }

    protected void configureClientAuth(SSLServerSocket socket) {
        if (this.wantClientAuth) {
            socket.setWantClientAuth(this.wantClientAuth);
        } else {
            socket.setNeedClientAuth(this.requireClientAuth);
        }
    }

    protected void configureUseServerCipherSuitesOrder(SSLServerSocket socket) {
        String useServerCipherSuitesOrderStr = this.endpoint.getUseServerCipherSuitesOrder().trim();
        if (!"".equals(useServerCipherSuitesOrderStr)) {
            SSLParameters sslParameters = socket.getSSLParameters();
            boolean useServerCipherSuitesOrder = "true".equalsIgnoreCase(useServerCipherSuitesOrderStr) || "yes".equalsIgnoreCase(useServerCipherSuitesOrderStr);
            try {
                Method m = SSLParameters.class.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
                m.invoke((Object)sslParameters, useServerCipherSuitesOrder);
            }
            catch (NoSuchMethodException nsme) {
                throw new UnsupportedOperationException(sm.getString("endpoint.jsse.cannotHonorServerCipherOrder"), nsme);
            }
            catch (InvocationTargetException ite) {
                throw new UnsupportedOperationException(sm.getString("endpoint.jsse.cannotHonorServerCipherOrder"), ite);
            }
            catch (IllegalArgumentException iae) {
                throw new UnsupportedOperationException(sm.getString("endpoint.jsse.cannotHonorServerCipherOrder"), iae);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(sm.getString("endpoint.jsse.cannotHonorServerCipherOrder"), e);
            }
            socket.setSSLParameters(sslParameters);
        }
    }

    private void initServerSocket(ServerSocket ssocket) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        socket.setEnabledCipherSuites(this.enabledCiphers);
        socket.setEnabledProtocols(this.enabledProtocols);
        this.configureClientAuth(socket);
        this.configureUseServerCipherSuitesOrder(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfig() throws IOException {
        ServerSocket socket = this.sslProxy.createServerSocket();
        this.initServerSocket(socket);
        try {
            socket.setSoTimeout(1);
            socket.accept();
        }
        catch (SSLException ssle) {
            IOException ioe = new IOException(sm.getString("jsse.invalid_ssl_conf", ssle.getMessage()));
            ioe.initCause(ssle);
            throw ioe;
        }
        catch (Exception exception) {
        }
        finally {
            if (!socket.isClosed()) {
                socket.close();
            }
        }
    }
}

