/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.apache.coyote.http11.upgrade.servlet31.WriteListener;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractServletOutputStream
extends ServletOutputStream {
    protected static final StringManager sm = StringManager.getManager("org.apache.coyote.http11.upgrade");
    private final Object fireListenerLock = new Object();
    private final Object writeLock = new Object();
    private volatile boolean closeRequired = false;
    private volatile WriteListener listener = null;
    private volatile boolean fireListener = false;
    private volatile byte[] buffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReady() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sos.canWrite.is"));
        }
        Object object = this.fireListenerLock;
        synchronized (object) {
            boolean result = this.buffer == null;
            this.fireListener = !result;
            return result;
        }
    }

    public final void setWriteListener(WriteListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sos.writeListener.null"));
        }
        this.listener = listener;
    }

    protected final boolean isCloseRequired() {
        return this.closeRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.preWriteChecks();
            this.writeInternal(new byte[]{(byte)b}, 0, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.preWriteChecks();
            this.writeInternal(b, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        this.closeRequired = true;
        this.doClose();
    }

    private void preWriteChecks() {
        if (this.buffer != null) {
            throw new IllegalStateException(sm.getString("upgrade.sis.write.ise"));
        }
    }

    private void writeInternal(byte[] b, int off, int len) throws IOException {
        if (this.listener == null) {
            this.doWrite(true, b, off, len);
        } else {
            int written = this.doWrite(false, b, off, len);
            if (written < len) {
                this.buffer = new byte[len - written];
                System.arraycopy(b, off + written, this.buffer, 0, len - written);
            } else {
                this.buffer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onWritePossible() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            try {
                this.writeInternal(this.buffer, 0, this.buffer.length);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                this.listener.onError(t);
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException(t);
            }
            boolean fire = false;
            Object object2 = this.fireListenerLock;
            synchronized (object2) {
                if (this.buffer == null && this.fireListener) {
                    this.fireListener = false;
                    fire = true;
                }
            }
            if (fire) {
                this.listener.onWritePossible();
            }
        }
    }

    protected abstract int doWrite(boolean var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void doFlush() throws IOException;

    protected abstract void doClose() throws IOException;
}

