/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.security;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.security.ExcludedPatternsChecker;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExcludedPatternsChecker
implements ExcludedPatternsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExcludedPatternsChecker.class);
    public static final String[] EXCLUDED_PATTERNS = new String[]{"(^|\\%\\{)((#?)(top(\\.|\\['|\\[\")|\\[\\d\\]\\.)?)(dojo|struts|session|request|response|application|servlet(Request|Response|Context)|parameters|context|_memberAccess)(\\.|\\[).*", ".*(^|\\.|\\[|\\'|\"|get)class(\\(\\.|\\[|\\'|\").*", "^(action|method):.*"};
    private Set<Pattern> excludedPatterns;

    public DefaultExcludedPatternsChecker() {
        this.setExcludedPatterns(EXCLUDED_PATTERNS);
    }

    @Inject(value="overrideExcludedPatterns", required=false)
    public void setOverrideExcludePatterns(String excludePatterns) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Overriding excluded patterns [#0] with [#1], be aware that this affects all instances and safety of your application!", "overrideExcludedPatterns", excludePatterns);
        }
        this.excludedPatterns = new HashSet<Pattern>();
        for (String pattern : TextParseUtil.commaDelimitedStringToSet(excludePatterns)) {
            this.excludedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Inject(value="additionalExcludedPatterns", required=false)
    public void setAdditionalExcludePatterns(String excludePatterns) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding additional global patterns [#0] to excluded patterns!", excludePatterns);
        }
        for (String pattern : TextParseUtil.commaDelimitedStringToSet(excludePatterns)) {
            this.excludedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Override
    public void setExcludedPatterns(String commaDelimitedPatterns) {
        this.setExcludedPatterns(TextParseUtil.commaDelimitedStringToSet(commaDelimitedPatterns));
    }

    @Override
    public void setExcludedPatterns(String[] patterns) {
        this.setExcludedPatterns(new HashSet<String>(Arrays.asList(patterns)));
    }

    @Override
    public void setExcludedPatterns(Set<String> patterns) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sets excluded patterns [#0]", patterns);
        }
        this.excludedPatterns = new HashSet<Pattern>(patterns.size());
        for (String pattern : patterns) {
            this.excludedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Override
    public ExcludedPatternsChecker.IsExcluded isExcluded(String value) {
        for (Pattern excludedPattern : this.excludedPatterns) {
            if (!excludedPattern.matcher(value).matches()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("[#0] matches excluded pattern [#1]", value, excludedPattern);
            }
            return ExcludedPatternsChecker.IsExcluded.yes(excludedPattern);
        }
        return ExcludedPatternsChecker.IsExcluded.no(this.excludedPatterns);
    }

    @Override
    public Set<Pattern> getExcludedPatterns() {
        return this.excludedPatterns;
    }
}

