/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ognl.DefaultMemberAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityMemberAccess
extends DefaultMemberAccess {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityMemberAccess.class);
    private final boolean allowStaticMethodAccess;
    private Set<Pattern> excludeProperties = Collections.emptySet();
    private Set<Pattern> acceptProperties = Collections.emptySet();
    private Set<Class<?>> excludedClasses = Collections.emptySet();
    private Set<Pattern> excludedPackageNamePatterns = Collections.emptySet();

    public SecurityMemberAccess(boolean method) {
        super(false);
        this.allowStaticMethodAccess = method;
    }

    public boolean getAllowStaticMethodAccess() {
        return this.allowStaticMethodAccess;
    }

    public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
        if (this.checkEnumAccess(target, member)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Allowing access to enum #0", target);
            }
            return true;
        }
        Class<?> targetClass = target.getClass();
        Class<?> memberClass = member.getDeclaringClass();
        if (Modifier.isStatic(member.getModifiers()) && this.allowStaticMethodAccess) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Support for accessing static methods [target: #0, member: #1, property: #2] is deprecated!", target, member, propertyName);
            }
            if (!this.isClassExcluded(member.getDeclaringClass())) {
                targetClass = member.getDeclaringClass();
            }
        }
        if (this.isPackageExcluded(targetClass.getPackage(), memberClass.getPackage())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Package of target [#0] or package of member [#1] are excluded!", target, member);
            }
            return false;
        }
        if (this.isClassExcluded(targetClass)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Target class [#0] is excluded!", target);
            }
            return false;
        }
        if (this.isClassExcluded(memberClass)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Declaring class of member type [#0] is excluded!", member);
            }
            return false;
        }
        boolean allow = true;
        if (!this.checkStaticMethodAccess(member)) {
            if (LOG.isTraceEnabled()) {
                LOG.warn("Access to static [#0] is blocked!", member);
            }
            allow = false;
        }
        if (!allow) {
            return false;
        }
        return super.isAccessible(context, target, member, propertyName) && this.isAcceptableProperty(propertyName);
    }

    protected boolean checkStaticMethodAccess(Member member) {
        int modifiers = member.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return this.allowStaticMethodAccess;
        }
        return true;
    }

    protected boolean checkEnumAccess(Object target, Member member) {
        Class clazz;
        return target instanceof Class && Enum.class.isAssignableFrom(clazz = (Class)target) && member.getName().equals("values");
    }

    protected boolean isPackageExcluded(Package targetPackage, Package memberPackage) {
        if (LOG.isWarnEnabled() && (targetPackage == null || memberPackage == null)) {
            LOG.warn("The use of the default (unnamed) package is discouraged!", new String[0]);
        }
        String targetPackageName = targetPackage == null ? "" : targetPackage.getName();
        String memberPackageName = memberPackage == null ? "" : memberPackage.getName();
        for (Pattern pattern : this.excludedPackageNamePatterns) {
            if (!pattern.matcher(targetPackageName).matches() && !pattern.matcher(memberPackageName).matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassExcluded(Class<?> clazz) {
        if (clazz == Object.class) {
            return true;
        }
        for (Class<?> excludedClass : this.excludedClasses) {
            if (!clazz.isAssignableFrom(excludedClass)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAcceptableProperty(String name) {
        return name == null || !this.isExcluded(name) && this.isAccepted(name);
    }

    protected boolean isAccepted(String paramName) {
        if (!this.acceptProperties.isEmpty()) {
            for (Pattern pattern : this.acceptProperties) {
                Matcher matcher = pattern.matcher(paramName);
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isExcluded(String paramName) {
        if (!this.excludeProperties.isEmpty()) {
            for (Pattern pattern : this.excludeProperties) {
                Matcher matcher = pattern.matcher(paramName);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void setExcludeProperties(Set<Pattern> excludeProperties) {
        this.excludeProperties = excludeProperties;
    }

    public void setAcceptProperties(Set<Pattern> acceptedProperties) {
        this.acceptProperties = acceptedProperties;
    }

    public void setExcludedClasses(Set<Class<?>> excludedClasses) {
        this.excludedClasses = excludedClasses;
    }

    public void setExcludedPackageNamePatterns(Set<Pattern> excludedPackageNamePatterns) {
        this.excludedPackageNamePatterns = excludedPackageNamePatterns;
    }
}

