/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.protocol.ChunkFetchFailure;
import org.apache.spark.network.protocol.ChunkFetchRequest;
import org.apache.spark.network.protocol.ChunkFetchSuccess;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.protocol.OneWayMessage;
import org.apache.spark.network.protocol.RequestMessage;
import org.apache.spark.network.protocol.RpcFailure;
import org.apache.spark.network.protocol.RpcRequest;
import org.apache.spark.network.protocol.RpcResponse;
import org.apache.spark.network.protocol.StreamFailure;
import org.apache.spark.network.protocol.StreamRequest;
import org.apache.spark.network.protocol.StreamResponse;
import org.apache.spark.network.server.MessageHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.util.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Throwables;

public class TransportRequestHandler
extends MessageHandler<RequestMessage> {
    private static final Logger logger = LoggerFactory.getLogger(TransportRequestHandler.class);
    private final Channel channel;
    private final TransportClient reverseClient;
    private final RpcHandler rpcHandler;
    private final StreamManager streamManager;

    public TransportRequestHandler(Channel channel, TransportClient reverseClient, RpcHandler rpcHandler) {
        this.channel = channel;
        this.reverseClient = reverseClient;
        this.rpcHandler = rpcHandler;
        this.streamManager = rpcHandler.getStreamManager();
    }

    @Override
    public void exceptionCaught(Throwable cause) {
        this.rpcHandler.exceptionCaught(cause, this.reverseClient);
    }

    @Override
    public void channelActive() {
        this.rpcHandler.channelActive(this.reverseClient);
    }

    @Override
    public void channelInactive() {
        if (this.streamManager != null) {
            try {
                this.streamManager.connectionTerminated(this.channel);
            }
            catch (RuntimeException e) {
                logger.error("StreamManager connectionTerminated() callback failed.", (Throwable)e);
            }
        }
        this.rpcHandler.channelInactive(this.reverseClient);
    }

    @Override
    public void handle(RequestMessage request) {
        if (request instanceof ChunkFetchRequest) {
            this.processFetchRequest((ChunkFetchRequest)request);
        } else if (request instanceof RpcRequest) {
            this.processRpcRequest((RpcRequest)request);
        } else if (request instanceof OneWayMessage) {
            this.processOneWayMessage((OneWayMessage)request);
        } else if (request instanceof StreamRequest) {
            this.processStreamRequest((StreamRequest)request);
        } else {
            throw new IllegalArgumentException("Unknown request type: " + request);
        }
    }

    private void processFetchRequest(ChunkFetchRequest req) {
        ManagedBuffer buf;
        if (logger.isTraceEnabled()) {
            logger.trace("Received req from {} to fetch block {}", (Object)NettyUtils.getRemoteAddress(this.channel), (Object)req.streamChunkId);
        }
        try {
            this.streamManager.checkAuthorization(this.reverseClient, req.streamChunkId.streamId);
            this.streamManager.registerChannel(this.channel, req.streamChunkId.streamId);
            buf = this.streamManager.getChunk(req.streamChunkId.streamId, req.streamChunkId.chunkIndex);
        }
        catch (Exception e) {
            logger.error(String.format("Error opening block %s for request from %s", req.streamChunkId, NettyUtils.getRemoteAddress(this.channel)), (Throwable)e);
            this.respond(new ChunkFetchFailure(req.streamChunkId, Throwables.getStackTraceAsString(e)));
            return;
        }
        this.respond(new ChunkFetchSuccess(req.streamChunkId, buf));
    }

    private void processStreamRequest(StreamRequest req) {
        ManagedBuffer buf;
        try {
            buf = this.streamManager.openStream(req.streamId);
        }
        catch (Exception e) {
            logger.error(String.format("Error opening stream %s for request from %s", req.streamId, NettyUtils.getRemoteAddress(this.channel)), (Throwable)e);
            this.respond(new StreamFailure(req.streamId, Throwables.getStackTraceAsString(e)));
            return;
        }
        if (buf != null) {
            this.respond(new StreamResponse(req.streamId, buf.size(), buf));
        } else {
            this.respond(new StreamFailure(req.streamId, String.format("Stream '%s' was not found.", req.streamId)));
        }
    }

    private void processRpcRequest(final RpcRequest req) {
        try {
            this.rpcHandler.receive(this.reverseClient, req.body().nioByteBuffer(), new RpcResponseCallback(){

                @Override
                public void onSuccess(ByteBuffer response) {
                    TransportRequestHandler.this.respond(new RpcResponse(req.requestId, new NioManagedBuffer(response)));
                }

                @Override
                public void onFailure(Throwable e) {
                    TransportRequestHandler.this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
                }
            });
        }
        catch (Exception e) {
            logger.error("Error while invoking RpcHandler#receive() on RPC id " + req.requestId, (Throwable)e);
            this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
        }
        finally {
            req.body().release();
        }
    }

    private void processOneWayMessage(OneWayMessage req) {
        try {
            this.rpcHandler.receive(this.reverseClient, req.body().nioByteBuffer());
        }
        catch (Exception e) {
            logger.error("Error while invoking RpcHandler#receive() for one-way message.", (Throwable)e);
        }
        finally {
            req.body().release();
        }
    }

    private void respond(Encodable result) {
        SocketAddress remoteAddress = this.channel.remoteAddress();
        this.channel.writeAndFlush((Object)result).addListener(future -> {
            if (future.isSuccess()) {
                logger.trace("Sent result {} to client {}", (Object)result, (Object)remoteAddress);
            } else {
                logger.error(String.format("Error sending result %s to %s; closing connection", result, remoteAddress), future.cause());
                this.channel.close();
            }
        });
    }
}

