/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice.web;

import com.google.common.collect.HashBasedTable;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletModule;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.env.Environment;
import org.apache.shiro.guice.ShiroModule;
import org.apache.shiro.guice.web.FilterChainResolverProvider;
import org.apache.shiro.guice.web.GuiceShiroFilter;
import org.apache.shiro.guice.web.PathMatchingFilterProvider;
import org.apache.shiro.guice.web.WebGuiceEnvironment;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.web.env.WebEnvironment;
import org.apache.shiro.web.filter.PathMatchingFilter;
import org.apache.shiro.web.filter.authc.AnonymousFilter;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.filter.authc.LogoutFilter;
import org.apache.shiro.web.filter.authc.UserFilter;
import org.apache.shiro.web.filter.authz.HttpMethodPermissionFilter;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;
import org.apache.shiro.web.filter.authz.PortFilter;
import org.apache.shiro.web.filter.authz.RolesAuthorizationFilter;
import org.apache.shiro.web.filter.authz.SslFilter;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.filter.session.NoSessionCreationFilter;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.session.mgt.ServletContainerSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShiroWebModule
extends ShiroModule {
    public static final Key<AnonymousFilter> ANON = Key.get(AnonymousFilter.class);
    public static final Key<FormAuthenticationFilter> AUTHC = Key.get(FormAuthenticationFilter.class);
    public static final Key<BasicHttpAuthenticationFilter> AUTHC_BASIC = Key.get(BasicHttpAuthenticationFilter.class);
    public static final Key<NoSessionCreationFilter> NO_SESSION_CREATION = Key.get(NoSessionCreationFilter.class);
    public static final Key<LogoutFilter> LOGOUT = Key.get(LogoutFilter.class);
    public static final Key<PermissionsAuthorizationFilter> PERMS = Key.get(PermissionsAuthorizationFilter.class);
    public static final Key<PortFilter> PORT = Key.get(PortFilter.class);
    public static final Key<HttpMethodPermissionFilter> REST = Key.get(HttpMethodPermissionFilter.class);
    public static final Key<RolesAuthorizationFilter> ROLES = Key.get(RolesAuthorizationFilter.class);
    public static final Key<SslFilter> SSL = Key.get(SslFilter.class);
    public static final Key<UserFilter> USER = Key.get(UserFilter.class);
    static final String NAME = "SHIRO";
    private final Map<String, Key<? extends Filter>[]> filterChains = new LinkedHashMap<String, Key<? extends Filter>[]>();
    private final ServletContext servletContext;

    public ShiroWebModule(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public static void bindGuiceFilter(Binder binder) {
        binder.install((Module)ShiroWebModule.guiceFilterModule());
    }

    public static void bindGuiceFilter(String pattern, Binder binder) {
        binder.install((Module)ShiroWebModule.guiceFilterModule(pattern));
    }

    public static ServletModule guiceFilterModule() {
        return ShiroWebModule.guiceFilterModule("/*");
    }

    public static ServletModule guiceFilterModule(final String pattern) {
        return new ServletModule(){

            protected void configureServlets() {
                this.filter(pattern, new String[0]).through(GuiceShiroFilter.class);
            }
        };
    }

    @Override
    protected final void configureShiro() {
        this.bindBeanType(TypeLiteral.get(ServletContext.class), Key.get(ServletContext.class, (Annotation)Names.named((String)NAME)));
        this.bind(Key.get(ServletContext.class, (Annotation)Names.named((String)NAME))).toInstance((Object)this.servletContext);
        this.bindWebSecurityManager((AnnotatedBindingBuilder<? super WebSecurityManager>)this.bind(WebSecurityManager.class));
        this.bindWebEnvironment((AnnotatedBindingBuilder<? super WebEnvironment>)this.bind(WebEnvironment.class));
        this.bind(GuiceShiroFilter.class).asEagerSingleton();
        this.expose(GuiceShiroFilter.class);
        this.configureShiroWeb();
        this.setupFilterChainConfigs();
        this.bind(FilterChainResolver.class).toProvider((Provider)new FilterChainResolverProvider(this.filterChains));
    }

    private void setupFilterChainConfigs() {
        HashBasedTable configs = HashBasedTable.create();
        for (Map.Entry<String, Key<? extends Filter>[]> filterChain : this.filterChains.entrySet()) {
            for (int i = 0; i < filterChain.getValue().length; ++i) {
                Object key = filterChain.getValue()[i];
                if (key instanceof FilterConfigKey) {
                    FilterConfigKey configKey = (FilterConfigKey)((Object)key);
                    filterChain.getValue()[i] = key = configKey.getKey();
                    if (!PathMatchingFilter.class.isAssignableFrom(key.getTypeLiteral().getRawType())) {
                        throw new ConfigurationException("Config information requires a PathMatchingFilter - can't apply to " + key.getTypeLiteral().getRawType());
                    }
                    configs.put(this.castToPathMatching((Key<? extends Filter>)key), (Object)filterChain.getKey(), (Object)configKey.getConfigValue());
                    continue;
                }
                if (!PathMatchingFilter.class.isAssignableFrom(key.getTypeLiteral().getRawType())) continue;
                configs.put(this.castToPathMatching((Key<? extends Filter>)key), (Object)filterChain.getKey(), (Object)"");
            }
        }
        for (Key filterKey : configs.rowKeySet()) {
            this.bindPathMatchingFilter(filterKey, configs.row((Object)filterKey));
        }
    }

    private <T extends PathMatchingFilter> void bindPathMatchingFilter(Key<T> filterKey, Map<String, String> configs) {
        this.bind(filterKey).toProvider(new PathMatchingFilterProvider<T>(filterKey, configs)).asEagerSingleton();
    }

    private Key<? extends PathMatchingFilter> castToPathMatching(Key<? extends Filter> key) {
        return key;
    }

    protected abstract void configureShiroWeb();

    @Override
    protected final void bindSecurityManager(AnnotatedBindingBuilder<? super SecurityManager> bind) {
        this.bindWebSecurityManager(bind);
    }

    protected void bindWebSecurityManager(AnnotatedBindingBuilder<? super WebSecurityManager> bind) {
        try {
            bind.toConstructor(DefaultWebSecurityManager.class.getConstructor(Collection.class)).asEagerSingleton();
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("This really shouldn't happen.  Either something has changed in Shiro, or there's a bug in ShiroModule.", (Throwable)e);
        }
    }

    @Override
    protected void bindSessionManager(AnnotatedBindingBuilder<SessionManager> bind) {
        bind.to(ServletContainerSessionManager.class).asEagerSingleton();
    }

    @Override
    protected final void bindEnvironment(AnnotatedBindingBuilder<Environment> bind) {
        this.bindWebEnvironment(bind);
    }

    protected void bindWebEnvironment(AnnotatedBindingBuilder<? super WebEnvironment> bind) {
        bind.to(WebGuiceEnvironment.class).asEagerSingleton();
    }

    protected final void addFilterChain(String pattern, Key<? extends Filter> ... keys) {
        this.filterChains.put(pattern, keys);
    }

    protected static <T extends PathMatchingFilter> Key<T> config(Key<T> baseKey, String configValue) {
        return new FilterConfigKey(baseKey, configValue);
    }

    protected static <T extends PathMatchingFilter> Key<T> config(TypeLiteral<T> typeLiteral, String configValue) {
        return ShiroWebModule.config(Key.get(typeLiteral), configValue);
    }

    protected static <T extends PathMatchingFilter> Key<T> config(Class<T> type, String configValue) {
        return ShiroWebModule.config(Key.get(type), configValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterConfigKey<T extends PathMatchingFilter>
    extends Key<T> {
        private Key<T> key;
        private String configValue;

        private FilterConfigKey(Key<T> key, String configValue) {
            this.key = key;
            this.configValue = configValue;
        }

        public Key<T> getKey() {
            return this.key;
        }

        public String getConfigValue() {
            return this.configValue;
        }
    }
}

