/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public class PropertySetFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertySet create(DirectoryEntry dir, String name) throws FileNotFoundException, NoPropertySetStreamException, IOException, UnsupportedEncodingException {
        InputStream inp = null;
        try {
            DocumentEntry entry = (DocumentEntry)dir.getEntry(name);
            inp = new DocumentInputStream(entry);
            try {
                PropertySet propertySet = PropertySetFactory.create(inp);
                return propertySet;
            }
            catch (MarkUnsupportedException e) {
                PropertySet propertySet;
                block7: {
                    propertySet = null;
                    if (inp == null) break block7;
                    inp.close();
                }
                return propertySet;
            }
        }
        finally {
            if (inp != null) {
                inp.close();
            }
        }
    }

    public static PropertySet create(InputStream stream) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        PropertySet ps = new PropertySet(stream);
        try {
            if (ps.isSummaryInformation()) {
                return new SummaryInformation(ps);
            }
            if (ps.isDocumentSummaryInformation()) {
                return new DocumentSummaryInformation(ps);
            }
            return ps;
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static SummaryInformation newSummaryInformation() {
        return new SummaryInformation();
    }

    public static DocumentSummaryInformation newDocumentSummaryInformation() {
        return new DocumentSummaryInformation();
    }
}

