/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.rs.validator;

import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.AbstractValidator;
import org.apache.oltu.oauth2.rs.ResourceServer;

public class BearerQueryOAuthValidator
extends AbstractValidator {
    @Override
    public void validateContentType(HttpServletRequest request) throws OAuthProblemException {
    }

    @Override
    public void validateMethod(HttpServletRequest request) throws OAuthProblemException {
    }

    @Override
    public void validateRequiredParameters(HttpServletRequest request) throws OAuthProblemException {
        String[] tokens = ResourceServer.getQueryParameterValues(request, "access_token");
        if (OAuthUtils.hasEmptyValues(tokens) && OAuthUtils.hasEmptyValues(tokens = ResourceServer.getQueryParameterValues(request, "oauth_token"))) {
            throw OAuthProblemException.error(null, "Missing OAuth token.");
        }
        if (tokens != null && tokens.length > 1) {
            throw OAuthProblemException.error("invalid_request", "Multiple tokens attached.");
        }
        String oauthVersionDiff = ResourceServer.getQueryParameterValue(request, "oauth_signature_method");
        if (!OAuthUtils.isEmpty(oauthVersionDiff)) {
            throw OAuthProblemException.error("invalid_request", "Incorrect OAuth version. Found OAuth V1.0.");
        }
    }
}

