/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.as.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.OAuthValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OAuthRequest {
    private Logger log = LoggerFactory.getLogger(OAuthRequest.class);
    protected HttpServletRequest request;
    protected OAuthValidator<HttpServletRequest> validator;
    protected Map<String, Class<? extends OAuthValidator<HttpServletRequest>>> validators = new HashMap<String, Class<? extends OAuthValidator<HttpServletRequest>>>();

    public OAuthRequest(HttpServletRequest request) throws OAuthSystemException, OAuthProblemException {
        this.request = request;
        this.validate();
    }

    public OAuthRequest() {
    }

    protected void validate() throws OAuthSystemException, OAuthProblemException {
        try {
            this.validator = this.initValidator();
            this.validator.validateMethod(this.request);
            this.validator.validateContentType(this.request);
            this.validator.validateRequiredParameters(this.request);
            this.validator.validateClientAuthenticationCredentials(this.request);
        }
        catch (OAuthProblemException e) {
            block5: {
                try {
                    String redirectUri = this.request.getParameter("redirect_uri");
                    if (!OAuthUtils.isEmpty((String)redirectUri)) {
                        e.setRedirectUri(redirectUri);
                    }
                }
                catch (Exception ex) {
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.debug("Cannot read redirect_url from the request: {}", (Object[])new String[]{ex.getMessage()});
                }
            }
            throw e;
        }
    }

    protected abstract OAuthValidator<HttpServletRequest> initValidator() throws OAuthProblemException, OAuthSystemException;

    public String getParam(String name) {
        return this.request.getParameter(name);
    }

    public String getClientId() {
        String[] creds = OAuthUtils.decodeClientAuthenticationHeader((String)this.request.getHeader("Authorization"));
        if (creds != null) {
            return creds[0];
        }
        return this.getParam("client_id");
    }

    public String getRedirectURI() {
        return this.getParam("redirect_uri");
    }

    public String getClientSecret() {
        String[] creds = OAuthUtils.decodeClientAuthenticationHeader((String)this.request.getHeader("Authorization"));
        if (creds != null) {
            return creds[1];
        }
        return this.getParam("client_secret");
    }

    public boolean isClientAuthHeaderUsed() {
        return OAuthUtils.decodeClientAuthenticationHeader((String)this.request.getHeader("Authorization")) != null;
    }

    public Set<String> getScopes() {
        String scopes = this.getParam("scope");
        return OAuthUtils.decodeScopes((String)scopes);
    }
}

