/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactoryJDBC;
import org.apache.ode.dao.jpa.BPELDAOConnectionImpl;
import org.apache.ode.dao.jpa.JpaTxMgrProvider;

public class BPELDAOConnectionFactoryImpl
implements BpelDAOConnectionFactoryJDBC {
    static final Log __log = LogFactory.getLog(BPELDAOConnectionFactoryImpl.class);
    protected EntityManagerFactory _emf;
    private TransactionManager _tm;
    private DataSource _ds;
    private Object _dbdictionary;
    static ThreadLocal<BPELDAOConnectionImpl> _connections = new ThreadLocal();

    public BpelDAOConnection getConnection() {
        try {
            this._tm.getTransaction().registerSynchronization(new Synchronization(){

                public void afterCompletion(int n) {
                    if (_connections.get() != null) {
                        _connections.get().getEntityManager().close();
                    }
                    _connections.set(null);
                }

                public void beforeCompletion() {
                }
            });
        }
        catch (RollbackException rollbackException) {
            throw new RuntimeException("Coulnd't register synchronizer!");
        }
        catch (SystemException systemException) {
            throw new RuntimeException("Coulnd't register synchronizer!");
        }
        if (_connections.get() != null) {
            return _connections.get();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("openjpa.TransactionMode", "managed");
        EntityManager entityManager = this._emf.createEntityManager(hashMap);
        BPELDAOConnectionImpl bPELDAOConnectionImpl = this.createBPELDAOConnection(entityManager);
        _connections.set(bPELDAOConnectionImpl);
        return bPELDAOConnectionImpl;
    }

    protected BPELDAOConnectionImpl createBPELDAOConnection(EntityManager entityManager) {
        return new BPELDAOConnectionImpl(entityManager);
    }

    public void init(Properties properties) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("openjpa.Log", "log4j");
        hashMap.put("openjpa.ManagedRuntime", new JpaTxMgrProvider(this._tm));
        hashMap.put("openjpa.ConnectionFactory", this._ds);
        hashMap.put("openjpa.ConnectionFactoryMode", "managed");
        hashMap.put("openjpa.FlushBeforeQueries", "false");
        hashMap.put("openjpa.FetchBatchSize", 1000);
        hashMap.put("openjpa.jdbc.TransactionIsolation", "read-committed");
        if (this._dbdictionary != null) {
            hashMap.put("openjpa.jdbc.DBDictionary", this._dbdictionary);
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        this._emf = Persistence.createEntityManagerFactory((String)"ode-dao", hashMap);
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this._tm = transactionManager;
    }

    public void setDataSource(DataSource dataSource) {
        this._ds = dataSource;
    }

    public void setDBDictionary(String string) {
        this._dbdictionary = string;
    }

    public void setTransactionManager(Object object) {
        this._tm = (TransactionManager)object;
    }

    public void setUnmanagedDataSource(DataSource dataSource) {
    }

    public void shutdown() {
        this._emf.close();
    }

    public DataSource getDataSource() {
        return this._ds;
    }
}

