/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store.jpa;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.jpa.JpaTxMgrProvider;
import org.apache.ode.store.ConfStoreConnection;
import org.apache.ode.store.ConfStoreConnectionFactory;
import org.apache.ode.store.jpa.ConfStoreConnectionJpa;

public class DbConfStoreConnectionFactory
implements ConfStoreConnectionFactory {
    private static final Log __log = LogFactory.getLog(DbConfStoreConnectionFactory.class);
    private DataSource _ds;
    private EntityManagerFactory _emf;
    private TransactionManager _txMgr;

    public DbConfStoreConnectionFactory(DataSource dataSource, boolean bl, String string) {
        this._ds = dataSource;
        this.initTxMgr(string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("openjpa.Log", "log4j");
        hashMap.put("openjpa.ManagedRuntime", new JpaTxMgrProvider(this._txMgr));
        hashMap.put("openjpa.ConnectionFactory", this._ds);
        hashMap.put("openjpa.ConnectionFactoryMode", "managed");
        hashMap.put("openjpa.FlushBeforeQueries", "false");
        hashMap.put("openjpa.FetchBatchSize", 1000);
        hashMap.put("openjpa.jdbc.TransactionIsolation", "read-committed");
        if (bl) {
            hashMap.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=false)");
        }
        this._emf = Persistence.createEntityManagerFactory((String)"ode-store", hashMap);
    }

    public ConfStoreConnection getConnection() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("openjpa.TransactionMode", "managed");
        return new ConfStoreConnectionJpa(this._emf.createEntityManager(hashMap));
    }

    public void beginTransaction() {
        try {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("begin transaction on " + this._txMgr));
            }
            this._txMgr.begin();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void commitTransaction() {
        try {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("commit transaction on " + this._txMgr));
            }
            this._txMgr.commit();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void rollbackTransaction() {
        try {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("rollback transaction on " + this._txMgr));
            }
            this._txMgr.rollback();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void initTxMgr(String string) {
        __log.info((Object)("ProcessStore initializing transaction manager using " + string));
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            Object obj = clazz.newInstance();
            this._txMgr = (TransactionManager)clazz.getMethod("getTransactionManager", null).invoke(obj, new Object[0]);
        }
        catch (Exception exception) {
            __log.fatal((Object)("Couldn't initialize a transaction manager with factory: " + string), (Throwable)exception);
            throw new RuntimeException("Couldn't initialize a transaction manager with factory: " + string, exception);
        }
    }
}

