/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.dd.TInvoke;
import org.apache.ode.bpel.dd.TMexInterceptor;
import org.apache.ode.bpel.dd.TProcessEvents;
import org.apache.ode.bpel.dd.TScopeEvents;
import org.apache.ode.bpel.dd.TService;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.store.DeploymentUnitDir;
import org.apache.ode.store.ProcessCleanupConfImpl;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.HierarchicalProperties;
import org.apache.ode.utils.WatchDog;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessConfImpl
implements ProcessConf {
    private static final Log __log = LogFactory.getLog(ProcessConfImpl.class);
    private final Date _deployDate;
    private File _configDir;
    private final Map<QName, Node> _props;
    private final HashMap<String, Endpoint> _partnerRoleInitialValues = new HashMap();
    private final HashMap<String, Endpoint> _myRoleEndpoints = new HashMap();
    private final ArrayList<QName> _sharedServices = new ArrayList();
    private final Map<String, Set<BpelEvent.TYPE>> _events = new HashMap<String, Set<BpelEvent.TYPE>>();
    private final ArrayList<String> _mexi = new ArrayList();
    ProcessState _state;
    final TDeployment.Process _pinfo;
    final DeploymentUnitDir _du;
    private long _version = 0L;
    private QName _pid;
    private QName _type;
    private volatile boolean _inMemory = false;
    private WatchDog<Map<File, Long>, PropertiesObserver> propertiesWatchDog;
    private EndpointReferenceContext eprContext;
    private final ProcessCleanupConfImpl processCleanupConfImpl;

    ProcessConfImpl(QName qName, QName qName2, long l, DeploymentUnitDir deploymentUnitDir, TDeployment.Process process, Date date, Map<QName, Node> map, ProcessState processState, EndpointReferenceContext endpointReferenceContext, File file) {
        this._pid = qName;
        this._version = l;
        this._du = deploymentUnitDir;
        this._pinfo = process;
        this._deployDate = date;
        this._configDir = file;
        this._props = Collections.unmodifiableMap(map);
        this._state = processState;
        this._type = qName2;
        this._inMemory = this._pinfo.isSetInMemory() && this._pinfo.getInMemory();
        this.eprContext = endpointReferenceContext;
        this.propertiesWatchDog = new WatchDog((WatchDog.Mutable)new PropertiesMutable(), (WatchDog.Observer)new PropertiesObserver());
        this.initLinks();
        this.initMexInterceptors();
        this.initEventList();
        this.processCleanupConfImpl = new ProcessCleanupConfImpl(process);
    }

    private List<File> collectEndpointConfigFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.addAll(this._du.getEndpointConfigFiles());
        if (this._configDir == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"No config directory set up.");
            }
        } else if (this._configDir.isDirectory()) {
            Object[] objectArray = this._configDir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith(".endpoint") && file.isFile();
                }
            });
            if (objectArray != null) {
                Arrays.sort(objectArray);
                arrayList.addAll(Arrays.asList(objectArray));
            } else if (__log.isErrorEnabled()) {
                __log.error((Object)(this._configDir + " does not exist or is not a directory"));
            }
        } else if (__log.isErrorEnabled()) {
            __log.error((Object)(this._configDir + " does not exist or is not a directory"));
        }
        return arrayList;
    }

    private void initMexInterceptors() {
        if (this._pinfo.getMexInterceptors() != null) {
            for (TMexInterceptor tMexInterceptor : this._pinfo.getMexInterceptors().getMexInterceptorList()) {
                this._mexi.add(tMexInterceptor.getClassName());
            }
        }
    }

    private void initLinks() {
        TService tService;
        String string;
        if (this._pinfo.getInvokeList() != null) {
            for (TInvoke tInvoke : this._pinfo.getInvokeList()) {
                string = tInvoke.getPartnerLink();
                tService = tInvoke.getService();
                if (tService == null) continue;
                __log.debug((Object)("Processing <invoke> element for process " + this._pinfo.getName() + ": partnerlink " + string + " --> " + tService));
                this._partnerRoleInitialValues.put(string, new Endpoint(tService.getName(), tService.getPort()));
            }
        }
        if (this._pinfo.getProvideList() != null) {
            for (TInvoke tInvoke : this._pinfo.getProvideList()) {
                string = tInvoke.getPartnerLink();
                tService = tInvoke.getService();
                if (tService == null) {
                    String string2 = "Error in <provide> element for process " + this._pinfo.getName() + "; partnerlink " + string + "did not identify an endpoint";
                    __log.error((Object)string2);
                    throw new ContextException(string2);
                }
                __log.debug((Object)("Processing <provide> element for process " + this._pinfo.getName() + ": partnerlink " + string + " --> " + tService.getName() + " : " + tService.getPort()));
                this._myRoleEndpoints.put(string, new Endpoint(tService.getName(), tService.getPort()));
                if (!tInvoke.isSetEnableSharing()) continue;
                this._sharedServices.add(tService.getName());
            }
        }
    }

    public Date getDeployDate() {
        return this._deployDate;
    }

    public String getDeployer() {
        return "";
    }

    public List<File> getFiles() {
        return this._du.allFiles();
    }

    public QName getProcessId() {
        return this._pid;
    }

    public QName getType() {
        return this._pinfo.getType() == null ? this._type : this._pinfo.getType();
    }

    public String getPackage() {
        return this._du.getName();
    }

    public Map<QName, Node> getProcessProperties() {
        return this._props;
    }

    public long getVersion() {
        return this._version;
    }

    public InputStream getCBPInputStream() {
        DeploymentUnitDir.CBPInfo cBPInfo = this._du.getCBPInfo(this.getType());
        if (cBPInfo == null) {
            throw new ContextException("CBP record not found for type " + this.getType());
        }
        try {
            return new FileInputStream(cBPInfo.cbp);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ContextException("File Not Found: " + cBPInfo.cbp, (Throwable)fileNotFoundException);
        }
    }

    public long getCBPFileSize() {
        DeploymentUnitDir.CBPInfo cBPInfo = this._du.getCBPInfo(this.getType());
        if (cBPInfo == null) {
            throw new ContextException("CBP record not found for type " + this.getType());
        }
        return cBPInfo.cbp.length();
    }

    public String getBpelDocument() {
        DeploymentUnitDir.CBPInfo cBPInfo = this._du.getCBPInfo(this.getType());
        if (cBPInfo == null) {
            throw new ContextException("CBP record not found for type " + this.getType());
        }
        try {
            String string = this.getRelativePath(this._du.getDeployDir(), cBPInfo.cbp).replaceAll("\\\\", "/");
            if (!string.endsWith(".cbp")) {
                throw new ContextException("CBP file must end with .cbp suffix: " + cBPInfo.cbp);
            }
            string = string.replace(".cbp", ".bpel");
            File file = new File(this._du.getDeployDir(), string);
            if (!file.exists()) {
                __log.warn((Object)("BPEL file does not exist: " + file));
            }
            return string;
        }
        catch (IOException iOException) {
            throw new ContextException("IOException in getBpelRelativePath: " + cBPInfo.cbp, (Throwable)iOException);
        }
    }

    public URI getBaseURI() {
        return this._du.getDeployDir().toURI();
    }

    public ProcessState getState() {
        return this._state;
    }

    void setState(ProcessState processState) {
        this._state = processState;
    }

    public List<String> getMexInterceptors(QName qName) {
        return Collections.unmodifiableList(this._mexi);
    }

    public Definition getDefinitionForService(QName qName) {
        return this._du.getDefinitionForService(qName);
    }

    public Definition getDefinitionForPortType(QName qName) {
        return this._du.getDefinitionForPortType(qName);
    }

    public Map<String, Endpoint> getInvokeEndpoints() {
        return Collections.unmodifiableMap(this._partnerRoleInitialValues);
    }

    public Map<String, Endpoint> getProvideEndpoints() {
        return Collections.unmodifiableMap(this._myRoleEndpoints);
    }

    public boolean isSharedService(QName qName) {
        return this._sharedServices.contains(qName);
    }

    private void handleEndpoints() {
    }

    DeploymentUnitDir getDeploymentUnit() {
        return this._du;
    }

    public boolean isTransient() {
        return this._inMemory;
    }

    public void setTransient(boolean bl) {
        this._pinfo.setInMemory(bl);
        this._inMemory = bl;
    }

    public boolean isEventEnabled(List<String> list, BpelEvent.TYPE tYPE) {
        Object object;
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Set<BpelEvent.TYPE> set = this._events.get(string);
                if (set == null || !set.contains(tYPE)) continue;
                return true;
            }
        }
        return (object = this._events.get(null)) != null && object.contains(tYPE);
    }

    private void initEventList() {
        Object object;
        TProcessEvents tProcessEvents = this._pinfo.getProcessEvents();
        if (tProcessEvents == null) {
            HashSet<BpelEvent.TYPE> hashSet = new HashSet<BpelEvent.TYPE>();
            for (BpelEvent.TYPE tYPE : BpelEvent.TYPE.values()) {
                if (tYPE.equals((Object)BpelEvent.TYPE.scopeHandling)) continue;
                hashSet.add(tYPE);
            }
            this._events.put(null, hashSet);
            return;
        }
        if (tProcessEvents.getGenerate() != null && tProcessEvents.getGenerate().equals(TProcessEvents.Generate.ALL)) {
            HashSet<BpelEvent.TYPE> hashSet = new HashSet<BpelEvent.TYPE>();
            for (BpelEvent.TYPE tYPE : BpelEvent.TYPE.values()) {
                hashSet.add(tYPE);
            }
            this._events.put(null, hashSet);
            return;
        }
        if (tProcessEvents.getEnableEventList() != null) {
            List list = tProcessEvents.getEnableEventList();
            TScopeEvents tScopeEvents = new HashSet();
            object = list.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                tScopeEvents.add(BpelEvent.TYPE.valueOf((String)string));
            }
            this._events.put(null, (Set<BpelEvent.TYPE>)tScopeEvents);
        }
        if (tProcessEvents.getScopeEventsList() != null) {
            for (TScopeEvents tScopeEvents : tProcessEvents.getScopeEventsList()) {
                object = new HashSet();
                for (String string : tScopeEvents.getEnableEventList()) {
                    ((HashSet)object).add(BpelEvent.TYPE.valueOf((String)string));
                }
                this._events.put(tScopeEvents.getName(), (Set<BpelEvent.TYPE>)object);
            }
        }
    }

    private String getRelativePath(File file, File file2) throws IOException {
        String string = file.getCanonicalPath();
        String string2 = file2.getCanonicalPath();
        if (!string2.startsWith(string)) {
            throw new IOException("Invalid relative path: base=" + file + " path=" + file2);
        }
        String string3 = string2.substring(string.length());
        if (string3.startsWith(File.separator)) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    public List<Element> getExtensionElement(QName qName) {
        try {
            return DOMUtils.findChildrenByName((Element)DOMUtils.stringToDOM((String)this._pinfo.toString()), (QName)qName);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public Map<String, String> getEndpointProperties(EndpointReference endpointReference) {
        Map map = this.eprContext.getConfigLookup(endpointReference);
        QName qName = (QName)map.get("service");
        String string = (String)map.get("port");
        this.propertiesWatchDog.check();
        Map map2 = ((HierarchicalProperties)((PropertiesObserver)this.propertiesWatchDog.getObserver()).get()).getProperties(qName, string);
        if (!map.isEmpty() && __log.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Properties for ");
            if (qName != null) {
                stringBuilder.append("service ").append(qName);
            }
            if (string != null) {
                stringBuilder.append(", port ").append(string);
            }
            stringBuilder.append(": {");
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringBuilder.append(entry.getKey()).append("=>").append(entry.getValue());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
            __log.debug((Object)stringBuilder);
        }
        return map2;
    }

    public boolean isCleanupCategoryEnabled(boolean bl, ProcessConf.CLEANUP_CATEGORY cLEANUP_CATEGORY) {
        return this.processCleanupConfImpl.isCleanupCategoryEnabled(bl, cLEANUP_CATEGORY);
    }

    public Set<ProcessConf.CLEANUP_CATEGORY> getCleanupCategories(boolean bl) {
        return this.processCleanupConfImpl.getCleanupCategories(bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesObserver
    extends WatchDog.DefaultObserver<HierarchicalProperties> {
        private PropertiesObserver() {
        }

        public void init() {
            try {
                this.object = new HierarchicalProperties(ProcessConfImpl.this.collectEndpointConfigFiles());
            }
            catch (IOException iOException) {
                throw new ContextException("Integration-Layer Properties cannot be loaded!", (Throwable)iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesMutable
    implements WatchDog.Mutable<Map<File, Long>> {
        private PropertiesMutable() {
        }

        public boolean exists() {
            return true;
        }

        public boolean hasChangedSince(Map<File, Long> map) {
            return !CollectionUtils.equals((Map)this.lastModified(), map);
        }

        public Map<File, Long> lastModified() {
            List list = ProcessConfImpl.this.collectEndpointConfigFiles();
            HashMap<File, Long> hashMap = new HashMap<File, Long>(list.size() * 15 / 10);
            for (File file : list) {
                hashMap.put(file, file.lastModified());
            }
            return hashMap;
        }

        public String toString() {
            return "Endpoint files for " + ProcessConfImpl.this._du.toString();
        }
    }
}

