/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dd.TCleanup;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.ProcessConf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessCleanupConfImpl {
    protected static Log __log = LogFactory.getLog(ProcessCleanupConfImpl.class);
    private final Set<ProcessConf.CLEANUP_CATEGORY> successCategories = EnumSet.noneOf(ProcessConf.CLEANUP_CATEGORY.class);
    private final Set<ProcessConf.CLEANUP_CATEGORY> failureCategories = EnumSet.noneOf(ProcessConf.CLEANUP_CATEGORY.class);

    ProcessCleanupConfImpl(TDeployment.Process process) {
        for (TCleanup tCleanup : process.getCleanupList()) {
            if (tCleanup.getOn() == TCleanup.On.SUCCESS || tCleanup.getOn() == TCleanup.On.ALWAYS) {
                this.processACleanup(this.successCategories, tCleanup.getCategoryList());
            }
            if (tCleanup.getOn() != TCleanup.On.FAILURE && tCleanup.getOn() != TCleanup.On.ALWAYS) continue;
            this.processACleanup(this.failureCategories, tCleanup.getCategoryList());
        }
        Set<ProcessConf.CLEANUP_CATEGORY> set = this.getCleanupCategories(true);
        if (set.contains(ProcessConf.CLEANUP_CATEGORY.INSTANCE) && !set.containsAll(EnumSet.of(ProcessConf.CLEANUP_CATEGORY.CORRELATIONS, ProcessConf.CLEANUP_CATEGORY.VARIABLES))) {
            throw new ContextException("Cleanup configuration error: the instance category requires both the correlations and variables categories specified together!!!");
        }
        set = this.getCleanupCategories(false);
        if (set.contains(ProcessConf.CLEANUP_CATEGORY.INSTANCE) && !set.containsAll(EnumSet.of(ProcessConf.CLEANUP_CATEGORY.CORRELATIONS, ProcessConf.CLEANUP_CATEGORY.VARIABLES))) {
            throw new ContextException("Cleanup configuration error: the instance category requires both the correlations and variables categories specified together!!!");
        }
    }

    private void processACleanup(Set<ProcessConf.CLEANUP_CATEGORY> set, List<TCleanup.Category.Enum> list) {
        if (list.isEmpty()) {
            set.addAll(EnumSet.allOf(ProcessConf.CLEANUP_CATEGORY.class));
        } else {
            for (TCleanup.Category.Enum enum_ : list) {
                if (enum_ == TCleanup.Category.ALL) {
                    set.addAll(EnumSet.allOf(ProcessConf.CLEANUP_CATEGORY.class));
                    continue;
                }
                set.add(ProcessConf.CLEANUP_CATEGORY.fromString((String)enum_.toString()));
            }
        }
    }

    boolean isCleanupCategoryEnabled(boolean bl, ProcessConf.CLEANUP_CATEGORY cLEANUP_CATEGORY) {
        if (bl) {
            return this.successCategories.contains(cLEANUP_CATEGORY);
        }
        return this.failureCategories.contains(cLEANUP_CATEGORY);
    }

    Set<ProcessConf.CLEANUP_CATEGORY> getCleanupCategories(boolean bl) {
        return bl ? this.successCategories : this.failureCategories;
    }
}

