/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OWait;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.bpel.runtime.channels.TimerResponseChannel;
import org.apache.ode.bpel.runtime.channels.TimerResponseChannelListener;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.utils.xsd.Duration;

class WAIT
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(WAIT.class);

    WAIT(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(activityInfo, scopeFrame, linkFrame);
    }

    public final void run() {
        Date date = null;
        try {
            date = this.getDueDate();
        }
        catch (FaultException faultException) {
            __log.error((Object)("Fault while calculating due date: " + faultException.getQName() + "; Reason: " + faultException.getMessage()));
            this._self.parent.completed(this.createFault(faultException.getQName(), (OBase)this._self.o), CompensationHandler.emptySet());
            return;
        }
        catch (EvaluationException evaluationException) {
            String string = "Unexpected error evaluating wait condition.";
            __log.error((Object)string, (Throwable)evaluationException);
            throw new InvalidProcessException(string, evaluationException);
        }
        if (date.getTime() > System.currentTimeMillis()) {
            final TimerResponseChannel timerResponseChannel = (TimerResponseChannel)this.newChannel(TimerResponseChannel.class);
            this.getBpelRuntimeContext().registerTimer(timerResponseChannel, date);
            WAIT.object((boolean)false, (Set)new TimerResponseChannelListener(timerResponseChannel){
                private static final long serialVersionUID = 3120518305645437327L;

                public void onTimeout() {
                    WAIT.this._self.parent.completed(null, CompensationHandler.emptySet());
                }

                public void onCancel() {
                    WAIT.this._self.parent.completed(null, CompensationHandler.emptySet());
                }
            }.or(new TerminationChannelListener(this._self.self){
                private static final long serialVersionUID = -2791243270691333946L;

                public void terminate() {
                    WAIT.this._self.parent.completed(null, CompensationHandler.emptySet());
                    1.object((ChannelListener)new TimerResponseChannelListener(timerResponseChannel){
                        private static final long serialVersionUID = 677746737897792929L;

                        public void onTimeout() {
                        }

                        public void onCancel() {
                        }
                    });
                }
            }));
        } else {
            this._self.parent.completed(null, CompensationHandler.emptySet());
        }
    }

    protected Date getDueDate() throws FaultException, EvaluationException {
        OWait oWait = (OWait)this._self.o;
        assert (oWait.hasFor() || oWait.hasUntil());
        EvaluationContext evaluationContext = this.getEvaluationContext();
        Date date = null;
        if (oWait.hasFor()) {
            Calendar calendar = Calendar.getInstance();
            Duration duration = this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsDuration(oWait.forExpression, evaluationContext);
            duration.addTo(calendar);
            date = calendar.getTime();
        } else if (oWait.hasUntil()) {
            Calendar calendar = this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsDate(oWait.untilExpression, evaluationContext);
            date = calendar.getTime();
        } else {
            throw new AssertionError((Object)"Static checks failed to find bad WaitActivity!");
        }
        if (date == null) {
            date = new Date();
        }
        return date;
    }
}

