/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evar.IncompleteKeyException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.CorrelationSetInstance;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScopeFrame
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(ScopeFrame.class);
    final OScope oscope;
    final ScopeFrame parent;
    final Long scopeInstanceId;
    Set<CompensationHandler> availableCompensations;
    private FaultData _faultData;

    ScopeFrame(OScope oScope, Long l, ScopeFrame scopeFrame, Set<CompensationHandler> set, FaultData faultData) {
        this(oScope, l, scopeFrame, set);
        this._faultData = faultData;
    }

    public ScopeFrame(OScope oScope, Long l, ScopeFrame scopeFrame, Set<CompensationHandler> set) {
        this.oscope = oScope;
        this.scopeInstanceId = l;
        this.parent = scopeFrame;
        this.availableCompensations = set;
    }

    public ScopeFrame find(OScope oScope) {
        if (this.oscope.name.equals(oScope.name)) {
            return this;
        }
        return this.parent != null ? this.parent.find(oScope) : null;
    }

    public VariableInstance resolve(OScope.Variable variable) {
        ScopeFrame scopeFrame = this.find(variable.declaringScope);
        if (scopeFrame == null) {
            return null;
        }
        return new VariableInstance(scopeFrame.scopeInstanceId, variable);
    }

    public CorrelationSetInstance resolve(OScope.CorrelationSet correlationSet) {
        return new CorrelationSetInstance(this.find((OScope)correlationSet.declaringScope).scopeInstanceId, correlationSet);
    }

    public PartnerLinkInstance resolve(OPartnerLink oPartnerLink) {
        return new PartnerLinkInstance(this.find((OScope)oPartnerLink.declaringScope).scopeInstanceId, oPartnerLink);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{ScopeFrame: o=");
        stringBuffer.append(this.oscope);
        stringBuffer.append(", id=");
        stringBuffer.append(this.scopeInstanceId);
        if (this.availableCompensations != null) {
            stringBuffer.append(", avComps=");
            stringBuffer.append(this.availableCompensations);
        }
        if (this._faultData != null) {
            stringBuffer.append(", fault=");
            stringBuffer.append(this._faultData);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public FaultData getFault() {
        if (this._faultData != null) {
            return this._faultData;
        }
        if (this.parent != null) {
            return this.parent.getFault();
        }
        return null;
    }

    public void fillEventInfo(ScopeEvent scopeEvent) {
        ScopeFrame scopeFrame = this;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (scopeFrame != null) {
            arrayList.add(scopeFrame.oscope.name);
            scopeFrame = scopeFrame.parent;
        }
        scopeEvent.setParentScopesNames(arrayList);
        if (this.parent != null) {
            scopeEvent.setParentScopeId(this.parent.scopeInstanceId);
        }
        scopeEvent.setScopeId(this.scopeInstanceId);
        scopeEvent.setScopeName(this.oscope.name);
        scopeEvent.setScopeDeclerationId(this.oscope.getId());
        if (scopeEvent.getLineNo() == -1 && this.oscope.debugInfo != null) {
            scopeEvent.setLineNo(this.oscope.debugInfo.startLine);
        }
    }

    Node fetchVariableData(BpelRuntimeContext bpelRuntimeContext, VariableInstance variableInstance, boolean bl) throws FaultException {
        if (variableInstance.declaration.extVar != null) {
            Element element = (Element)this.fetchVariableData(bpelRuntimeContext, this.resolve(variableInstance.declaration.extVar.related), false);
            try {
                Node node = bpelRuntimeContext.readExtVar(variableInstance.declaration, element);
                if (node == null) {
                    throw new FaultException(this.oscope.getOwner().constants.qnUninitializedVariable, "The external variable \"" + variableInstance.declaration.name + "\" has not been initialized.");
                }
                return node;
            }
            catch (IncompleteKeyException incompleteKeyException) {
                __log.error((Object)("External variable could not be read due to incomplete key; the following key components were missing: " + incompleteKeyException.getMissing()));
                throw new FaultException(this.oscope.getOwner().constants.qnUninitializedVariable, "The extenral variable \"" + variableInstance.declaration.name + "\" has not been properly initialized;" + "the following key compoenents were missing:" + incompleteKeyException.getMissing());
            }
            catch (ExternalVariableModuleException externalVariableModuleException) {
                throw new BpelEngineException((Throwable)externalVariableModuleException);
            }
        }
        Node node = bpelRuntimeContext.readVariable(variableInstance.scopeInstance, variableInstance.declaration.name, bl);
        if (node == null) {
            if (variableInstance.declaration.type instanceof OMessageVarType) {
                OMessageVarType oMessageVarType = (OMessageVarType)variableInstance.declaration.type;
                if (oMessageVarType.parts.size() == 0) {
                    Document document = DOMUtils.newDocument();
                    Element element = document.createElement("message");
                    document.appendChild(element);
                    return element;
                }
            }
            throw new FaultException(this.oscope.getOwner().constants.qnUninitializedVariable, "The variable " + variableInstance.declaration.name + " isn't properly initialized.");
        }
        return node;
    }

    Node fetchVariableData(BpelRuntimeContext bpelRuntimeContext, VariableInstance variableInstance, OMessageVarType.Part part, boolean bl) throws FaultException {
        Node node = this.fetchVariableData(bpelRuntimeContext, variableInstance, bl);
        if (variableInstance.declaration.type instanceof OMessageVarType && part != null) {
            node = this.getPartData((Element)node, part);
        }
        return node;
    }

    Node initializeVariable(BpelRuntimeContext bpelRuntimeContext, VariableInstance variableInstance, Node node) throws ExternalVariableModuleException {
        if (variableInstance.declaration.extVar != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Initialize external variable: name=" + variableInstance.declaration + " value=" + DOMUtils.domToString((Node)node)));
            }
            VariableInstance variableInstance2 = this.resolve(variableInstance.declaration.extVar.related);
            Node node2 = null;
            try {
                node2 = this.fetchVariableData(bpelRuntimeContext, variableInstance2, true);
            }
            catch (FaultException faultException) {
                // empty catch block
            }
            if (node2 != null) {
                node = bpelRuntimeContext.readExtVar(variableInstance.declaration, node2);
            }
            return node;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Initialize variable: name=" + variableInstance.declaration + " value=" + DOMUtils.domToString((Node)node)));
        }
        return bpelRuntimeContext.writeVariable(variableInstance, node);
    }

    Node commitChanges(BpelRuntimeContext bpelRuntimeContext, VariableInstance variableInstance, Node node) throws ExternalVariableModuleException {
        return this.writeVariable(bpelRuntimeContext, variableInstance, node);
    }

    Node writeVariable(BpelRuntimeContext bpelRuntimeContext, VariableInstance variableInstance, Node node) throws ExternalVariableModuleException {
        if (variableInstance.declaration.extVar != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Write external variable: name=" + variableInstance.declaration + " value=" + DOMUtils.domToString((Node)node)));
            }
            VariableInstance variableInstance2 = this.resolve(variableInstance.declaration.extVar.related);
            Node node2 = null;
            try {
                node2 = this.fetchVariableData(bpelRuntimeContext, variableInstance2, true);
            }
            catch (FaultException faultException) {
                // empty catch block
            }
            BpelRuntimeContext.ValueReferencePair valueReferencePair = bpelRuntimeContext.writeExtVar(variableInstance.declaration, node2, node);
            this.writeVariable(bpelRuntimeContext, variableInstance2, valueReferencePair.reference);
            return valueReferencePair.value;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Write variable: name=" + variableInstance.declaration + " value=" + DOMUtils.domToString((Node)node)));
        }
        return bpelRuntimeContext.writeVariable(variableInstance, node);
    }

    Node getPartData(Element element, OMessageVarType.Part part) {
        QName qName = new QName(null, part.name);
        Element element2 = DOMUtils.findChildByName((Element)element, (QName)qName);
        if (part.type instanceof OElementVarType) {
            QName qName2 = ((OElementVarType)part.type).elementType;
            element2 = DOMUtils.findChildByName((Element)element2, (QName)qName2);
        }
        return element2;
    }
}

