/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPickReceive;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.InvalidContextException;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.Selector;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.PickResponseChannel;
import org.apache.ode.bpel.runtime.channels.PickResponseChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.xsd.Duration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PICK
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(PICK.class);
    private OPickReceive _opick;
    private OPickReceive.OnAlarm _alarm = null;

    public PICK(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(activityInfo, scopeFrame, linkFrame);
        this._opick = (OPickReceive)activityInfo.o;
    }

    public void run() {
        PickResponseChannel pickResponseChannel = (PickResponseChannel)this.newChannel(PickResponseChannel.class);
        try {
            HashSet<OScope.CorrelationSet> hashSet;
            Selector[] selectorArray = new Selector[this._opick.onMessages.size()];
            int n = 0;
            for (OPickReceive.OnMessage onMessage : this._opick.onMessages) {
                OScope.CorrelationSet correlationSet2;
                hashSet = new HashSet();
                hashSet.addAll(onMessage.matchCorrelations);
                for (OScope.CorrelationSet correlationSet2 : onMessage.joinCorrelations) {
                    if (!this.getBpelRuntimeContext().isCorrelationInitialized(this._scopeFrame.resolve(correlationSet2))) continue;
                    hashSet.add(correlationSet2);
                }
                PartnerLinkInstance partnerLinkInstance = this._scopeFrame.resolve(onMessage.partnerLink);
                correlationSet2 = this.resolveCorrelationKey(partnerLinkInstance, hashSet);
                selectorArray[n] = new Selector(n, partnerLinkInstance, onMessage.operation.getName(), onMessage.operation.getOutput() == null, onMessage.messageExchangeId, (CorrelationKeySet)correlationSet2, onMessage.route);
                ++n;
            }
            HashSet<OScope.CorrelationSet> hashSet2 = null;
            for (OPickReceive.OnMessage onMessage : this._opick.onAlarms) {
                Cloneable cloneable = hashSet = onMessage.forExpr != null ? PICK.offsetFromNow(this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsDuration(onMessage.forExpr, this.getEvaluationContext())) : this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsDate(onMessage.untilExpr, this.getEvaluationContext()).getTime();
                if (hashSet2 != null && ((Date)((Object)hashSet2)).compareTo((Date)((Object)hashSet)) <= 0) continue;
                hashSet2 = hashSet;
                this._alarm = onMessage;
            }
            this.getBpelRuntimeContext().select(pickResponseChannel, (Date)((Object)hashSet2), this._opick.createInstanceFlag, selectorArray);
        }
        catch (FaultException faultException) {
            __log.error((Object)faultException);
            FaultData faultData = this.createFault(faultException.getQName(), (OBase)this._opick, faultException.getMessage());
            this.dpe(this._opick.outgoingLinks);
            this._self.parent.completed(faultData, CompensationHandler.emptySet());
            return;
        }
        catch (EvaluationException evaluationException) {
            String string = "Unexpected evaluation error evaluating alarm.";
            __log.error((Object)string, (Throwable)evaluationException);
            throw new InvalidProcessException(string, evaluationException);
        }
        for (OPickReceive.OnAlarm onAlarm : this._opick.onAlarms) {
            if (onAlarm.equals((Object)this._alarm)) continue;
            this.dpe(onAlarm.activity);
        }
        PICK.instance((JacobRunnable)new WAITING(pickResponseChannel));
    }

    private CorrelationKeySet resolveCorrelationKey(PartnerLinkInstance partnerLinkInstance, Set<OScope.CorrelationSet> set) throws FaultException {
        CorrelationKeySet correlationKeySet = new CorrelationKeySet();
        if (set.isEmpty() && !this._opick.createInstanceFlag) {
            String string = this.getBpelRuntimeContext().fetchMySessionId(partnerLinkInstance);
            correlationKeySet.add(new CorrelationKey("-1", new String[]{string}));
        } else if (!set.isEmpty()) {
            for (OScope.CorrelationSet correlationSet : set) {
                CorrelationKey correlationKey = null;
                if (!this.getBpelRuntimeContext().isCorrelationInitialized(this._scopeFrame.resolve(correlationSet))) {
                    if (!this._opick.createInstanceFlag) {
                        throw new FaultException(this._opick.getOwner().constants.qnCorrelationViolation, "Correlation not initialized.");
                    }
                } else {
                    correlationKey = this.getBpelRuntimeContext().readCorrelation(this._scopeFrame.resolve(correlationSet));
                    assert (correlationKey != null);
                }
                if (correlationKey == null) continue;
                correlationKeySet.add(correlationKey);
            }
        }
        return correlationKeySet;
    }

    private static Date offsetFromNow(Duration duration) {
        Calendar calendar = Calendar.getInstance();
        duration.addTo(calendar);
        return calendar.getTime();
    }

    private void initVariable(String string, OPickReceive.OnMessage onMessage) {
        String string22;
        Element element;
        if (onMessage.variable == null) {
            return;
        }
        try {
            element = this.getBpelRuntimeContext().getMyRequest(string);
        }
        catch (BpelEngineException bpelEngineException) {
            __log.error((Object)"The message exchange seems to be in an unconsistent state, you're probably missing a reply on a request/response interaction.");
            this._self.parent.failure(bpelEngineException.toString(), null);
            return;
        }
        Set set = onMessage.operation.getInput().getMessage().getParts().keySet();
        if (!(onMessage.variable.type instanceof OMessageVarType)) {
            String string3 = "Non-message variable for receive: should have been picked up by static analysis.";
            __log.fatal((Object)string3);
            throw new InvalidProcessException(string3);
        }
        OMessageVarType oMessageVarType = (OMessageVarType)onMessage.variable.type;
        for (String string22 : set) {
            Object object;
            Object object2;
            QName qName = new QName(null, string22);
            Element element2 = DOMUtils.findChildByName((Element)element, (QName)qName);
            OMessageVarType.Part part = (OMessageVarType.Part)oMessageVarType.parts.get(string22);
            if (part == null) {
                object2 = "Inconsistent WSDL, part " + string22 + " not found in message type " + oMessageVarType.messageType;
                __log.fatal(object2);
                throw new InvalidProcessException((String)object2);
            }
            if (element2 == null) {
                object2 = "Message missing part: " + string22;
                __log.fatal(object2);
                throw new InvalidContextException((String)object2);
            }
            if (!(part.type instanceof OElementVarType)) continue;
            object2 = (OElementVarType)part.type;
            Element element3 = DOMUtils.getFirstChildElement((Element)element2);
            if (element3 == null) {
                object = "Message (element) part " + string22 + " did not contain child element.";
                __log.fatal(object);
                throw new InvalidContextException((String)object);
            }
            object = new QName(element3.getNamespaceURI(), element3.getLocalName());
            if (((QName)object).equals(object2.elementType)) continue;
            String string4 = "Message (element) part " + string22 + " did not contain correct child element: expected " + object2.elementType + " but got " + object;
            __log.fatal((Object)string4);
            throw new InvalidContextException(string4);
        }
        VariableInstance variableInstance = this._scopeFrame.resolve(onMessage.variable);
        try {
            this.initializeVariable(variableInstance, element);
        }
        catch (ExternalVariableModuleException externalVariableModuleException) {
            __log.error((Object)"Exception while initializing external variable", (Throwable)externalVariableModuleException);
            this._self.parent.failure(externalVariableModuleException.toString(), null);
            return;
        }
        string22 = new VariableModificationEvent(variableInstance.declaration.name);
        string22.setNewValue((Node)element);
        if (this._opick.debugInfo != null) {
            string22.setLineNo(this._opick.debugInfo.startLine);
        }
        this.sendEvent((ScopeEvent)string22);
    }

    private class WAITING
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;
        private PickResponseChannel _pickResponseChannel;

        private WAITING(PickResponseChannel pickResponseChannel) {
            this._pickResponseChannel = pickResponseChannel;
        }

        public void run() {
            WAITING.object((boolean)false, (Set)new PickResponseChannelListener(this._pickResponseChannel){
                private static final long serialVersionUID = -8237296827418738011L;

                public void onRequestRcvd(int n, String string) {
                    Object object2;
                    OPickReceive.OnMessage onMessage = (OPickReceive.OnMessage)((PICK)PICK.this)._opick.onMessages.get(n);
                    for (Object object2 : ((PICK)PICK.this)._opick.onMessages) {
                        if (object2.equals((Object)onMessage)) continue;
                        PICK.this.dpe(object2.activity);
                    }
                    if (PICK.this._alarm != null) {
                        PICK.this.dpe(((PICK)PICK.this)._alarm.activity);
                    }
                    if (((PICK)PICK.this)._opick.onMessages.size() > 1 && onMessage.operation.getOutput() == null) {
                        WAITING.this.getBpelRuntimeContext().cancelOutstandingRequests(WAITING.this._pickResponseChannel.export());
                    }
                    PICK.this.initVariable(string, onMessage);
                    try {
                        object2 = PICK.this._scopeFrame.resolve(onMessage.variable);
                        for (OScope.CorrelationSet correlationSet : onMessage.initCorrelations) {
                            WAITING.this.initializeCorrelation(PICK.this._scopeFrame.resolve(correlationSet), (VariableInstance)object2);
                        }
                        Object object3 = onMessage.joinCorrelations.iterator();
                        while (object3.hasNext()) {
                            OScope.CorrelationSet correlationSet;
                            correlationSet = (OScope.CorrelationSet)object3.next();
                            WAITING.this.initializeCorrelation(PICK.this._scopeFrame.resolve(correlationSet), (VariableInstance)object2);
                        }
                        if (onMessage.partnerLink.hasPartnerRole()) {
                            if (!(WAITING.this.getBpelRuntimeContext().isPartnerRoleEndpointInitialized(PICK.this._scopeFrame.resolve(onMessage.partnerLink)) && onMessage.partnerLink.initializePartnerRole || (object3 = WAITING.this.getBpelRuntimeContext().getSourceEPR(string)) == null)) {
                                if (__log.isDebugEnabled()) {
                                    __log.debug((Object)("Received callback EPR " + DOMUtils.domToString((Node)object3) + " saving it on partner link " + onMessage.partnerLink.getName()));
                                }
                                WAITING.this.getBpelRuntimeContext().writeEndpointReference(PICK.this._scopeFrame.resolve(onMessage.partnerLink), (Element)object3);
                            }
                            if ((object3 = WAITING.this.getBpelRuntimeContext().getSourceSessionId(string)) != null) {
                                WAITING.this.getBpelRuntimeContext().initializePartnersSessionId(PICK.this._scopeFrame.resolve(onMessage.partnerLink), (String)object3);
                            }
                        }
                    }
                    catch (FaultException faultException) {
                        __log.error((Object)faultException);
                        FaultData faultData = WAITING.this.createFault(faultException.getQName(), (OBase)onMessage);
                        PICK.this._self.parent.completed(faultData, CompensationHandler.emptySet());
                        PICK.this.dpe(onMessage.activity);
                        return;
                    }
                    object2 = new ActivityInfo(WAITING.this.genMonotonic(), onMessage.activity, PICK.this._self.self, PICK.this._self.parent);
                    2.instance((JacobRunnable)WAITING.this.createChild((ActivityInfo)object2, PICK.this._scopeFrame, PICK.this._linkFrame));
                }

                public void onTimeout() {
                    for (OPickReceive.OnMessage onMessage : ((PICK)PICK.this)._opick.onMessages) {
                        PICK.this.dpe(onMessage.activity);
                    }
                    ActivityInfo activityInfo = new ActivityInfo(WAITING.this.genMonotonic(), ((PICK)PICK.this)._alarm.activity, PICK.this._self.self, PICK.this._self.parent);
                    2.instance((JacobRunnable)WAITING.this.createChild(activityInfo, PICK.this._scopeFrame, PICK.this._linkFrame));
                }

                public void onCancel() {
                    PICK.this._self.parent.completed(null, CompensationHandler.emptySet());
                }
            }.or(new TerminationChannelListener(PICK.this._self.self){
                private static final long serialVersionUID = 4399496341785922396L;

                public void terminate() {
                    WAITING.this.getBpelRuntimeContext().cancel(WAITING.this._pickResponseChannel);
                    1.instance((JacobRunnable)WAITING.this);
                }
            }));
        }
    }
}

