/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.ActivityFailureEvent;
import org.apache.ode.bpel.evt.ActivityRecoveryEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OFailureHandling;
import org.apache.ode.bpel.o.OInvoke;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.ActivityRecoveryChannel;
import org.apache.ode.bpel.runtime.channels.ActivityRecoveryChannelListener;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.InvokeResponseChannel;
import org.apache.ode.bpel.runtime.channels.InvokeResponseChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INVOKE
extends ACTIVITY {
    private static final long serialVersionUID = 992248281026821783L;
    private static final Log __log = LogFactory.getLog(INVOKE.class);
    private OInvoke _oinvoke;
    private int _invoked;
    private Date _lastFailure;
    private String _failureReason;
    private Element _failureData;

    public INVOKE(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(activityInfo, scopeFrame, linkFrame);
        this._oinvoke = (OInvoke)this._self.o;
        this._invoked = 0;
    }

    public final void run() {
        Element element;
        try {
            element = this.setupOutbound(this._oinvoke, this._oinvoke.initCorrelationsInput, this._oinvoke.joinCorrelationsInput);
        }
        catch (FaultException faultException) {
            __log.error((Object)faultException);
            FaultData faultData = this.createFault(faultException.getQName(), (OBase)this._oinvoke);
            this._self.parent.completed(faultData, CompensationHandler.emptySet());
            return;
        }
        catch (ExternalVariableModuleException externalVariableModuleException) {
            __log.error((Object)externalVariableModuleException);
            this._self.parent.failure(externalVariableModuleException.toString(), null);
            return;
        }
        ++this._invoked;
        boolean bl = this._oinvoke.outputVar != null;
        try {
            if (!bl) {
                FaultData faultData = null;
                this.getBpelRuntimeContext().invoke(this._oinvoke.getId(), this._scopeFrame.resolve(this._oinvoke.partnerLink), this._oinvoke.operation, element, null);
                this._self.parent.completed(faultData, CompensationHandler.emptySet());
            } else {
                final VariableInstance variableInstance = this._scopeFrame.resolve(this._oinvoke.outputVar);
                InvokeResponseChannel invokeResponseChannel = (InvokeResponseChannel)this.newChannel(InvokeResponseChannel.class);
                final String string = this.getBpelRuntimeContext().invoke(this._oinvoke.getId(), this._scopeFrame.resolve(this._oinvoke.partnerLink), this._oinvoke.operation, element, invokeResponseChannel);
                INVOKE.object((boolean)false, (Set)new InvokeResponseChannelListener(invokeResponseChannel){
                    private static final long serialVersionUID = 4496880438819196765L;

                    public void onResponse() {
                        Element element;
                        FaultData faultData = null;
                        try {
                            element = INVOKE.this.getBpelRuntimeContext().getPartnerResponse(string);
                        }
                        catch (Exception exception) {
                            __log.error((Object)"Exception while processing invoke response", (Throwable)exception);
                            throw new RuntimeException(exception);
                        }
                        try {
                            INVOKE.this.initializeVariable(variableInstance, element);
                        }
                        catch (ExternalVariableModuleException externalVariableModuleException) {
                            __log.error((Object)"Exception while initializing external variable", (Throwable)externalVariableModuleException);
                            INVOKE.this._self.parent.failure(externalVariableModuleException.toString(), null);
                            return;
                        }
                        VariableModificationEvent variableModificationEvent = new VariableModificationEvent(variableInstance.declaration.name);
                        variableModificationEvent.setNewValue((Node)element);
                        if (((INVOKE)INVOKE.this)._oinvoke.debugInfo != null) {
                            variableModificationEvent.setLineNo(((INVOKE)INVOKE.this)._oinvoke.debugInfo.startLine);
                        }
                        INVOKE.this.sendEvent((ScopeEvent)variableModificationEvent);
                        try {
                            for (OScope.CorrelationSet correlationSet : ((INVOKE)INVOKE.this)._oinvoke.initCorrelationsOutput) {
                                INVOKE.this.initializeCorrelation(INVOKE.this._scopeFrame.resolve(correlationSet), variableInstance);
                            }
                            Object object = ((INVOKE)INVOKE.this)._oinvoke.joinCorrelationsOutput.iterator();
                            while (object.hasNext()) {
                                OScope.CorrelationSet correlationSet;
                                correlationSet = (OScope.CorrelationSet)object.next();
                                INVOKE.this.initializeCorrelation(INVOKE.this._scopeFrame.resolve(correlationSet), variableInstance);
                            }
                            if (((INVOKE)INVOKE.this)._oinvoke.partnerLink.hasPartnerRole()) {
                                if (!(INVOKE.this.getBpelRuntimeContext().isPartnerRoleEndpointInitialized(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink)) && ((INVOKE)INVOKE.this)._oinvoke.partnerLink.initializePartnerRole || (object = INVOKE.this.getBpelRuntimeContext().getSourceEPR(string)) == null)) {
                                    INVOKE.this.getBpelRuntimeContext().writeEndpointReference(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink), (Element)object);
                                }
                                if ((object = INVOKE.this.getBpelRuntimeContext().getSourceSessionId(string)) != null) {
                                    INVOKE.this.getBpelRuntimeContext().initializePartnersSessionId(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink), (String)object);
                                }
                            }
                        }
                        catch (FaultException faultException) {
                            faultData = INVOKE.this.createFault(faultException.getQName(), (OBase)INVOKE.this._oinvoke);
                        }
                        INVOKE.this._self.parent.completed(faultData, CompensationHandler.emptySet());
                        INVOKE.this.getBpelRuntimeContext().releasePartnerMex(string, faultData == null);
                    }

                    public void onFault() {
                        QName qName = INVOKE.this.getBpelRuntimeContext().getPartnerFault(string);
                        Element element = INVOKE.this.getBpelRuntimeContext().getPartnerResponse(string);
                        QName qName2 = INVOKE.this.getBpelRuntimeContext().getPartnerResponseType(string);
                        FaultData faultData = INVOKE.this.createFault(qName, element, (OVarType)((INVOKE)INVOKE.this)._oinvoke.getOwner().messageTypes.get(qName2), (OBase)INVOKE.this._self.o);
                        INVOKE.this._self.parent.completed(faultData, CompensationHandler.emptySet());
                        INVOKE.this.getBpelRuntimeContext().releasePartnerMex(string, false);
                    }

                    public void onFailure() {
                        String string2 = INVOKE.this.getBpelRuntimeContext().getPartnerFaultExplanation(string);
                        Element element = INVOKE.this.getBpelRuntimeContext().getPartnerResponse(string);
                        __log.error((Object)("Failure during invoke: " + string2));
                        try {
                            INVOKE.this._self.parent.failure(string2, element);
                        }
                        catch (Exception exception) {
                            INVOKE.this._self.parent.failure(string2, null);
                        }
                        INVOKE.this.getBpelRuntimeContext().releasePartnerMex(string, false);
                    }
                }.or(new TerminationChannelListener(this._self.self){
                    private static final long serialVersionUID = 4219496341785922396L;

                    public void terminate() {
                        INVOKE.this._self.parent.completed(null, CompensationHandler.emptySet());
                    }
                }));
            }
        }
        catch (FaultException faultException) {
            __log.error((Object)faultException);
            FaultData faultData = this.createFault(faultException.getQName(), (OBase)this._oinvoke, faultException.getMessage());
            this._self.parent.completed(faultData, CompensationHandler.emptySet());
        }
    }

    private Element setupOutbound(OInvoke oInvoke, Collection<OScope.CorrelationSet> collection, Collection<OScope.CorrelationSet> collection2) throws FaultException, ExternalVariableModuleException {
        for (OScope.CorrelationSet correlationSet : collection) {
            this.initializeCorrelation(this._scopeFrame.resolve(correlationSet), this._scopeFrame.resolve(oInvoke.inputVar));
        }
        for (OScope.CorrelationSet correlationSet : collection2) {
            this.initializeCorrelation(this._scopeFrame.resolve(correlationSet), this._scopeFrame.resolve(oInvoke.inputVar));
        }
        if (oInvoke.operation.getInput().getMessage().getParts().size() > 0) {
            this.sendVariableReadEvent(this._scopeFrame.resolve(oInvoke.inputVar));
            Node node = this.fetchVariableData(this._scopeFrame.resolve(oInvoke.inputVar), false);
            assert (node instanceof Element);
            return (Element)node;
        }
        return null;
    }

    private void requireRecovery() {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("ActivityRecovery: Invoke activity " + this._self.aId + " requires recovery"));
        }
        this.sendEvent((ActivityEvent)new ActivityFailureEvent(this._failureReason));
        final ActivityRecoveryChannel activityRecoveryChannel = (ActivityRecoveryChannel)this.newChannel(ActivityRecoveryChannel.class);
        this.getBpelRuntimeContext().registerActivityForRecovery(activityRecoveryChannel, this._self.aId, this._failureReason, this._lastFailure, this._failureData, new String[]{"retry", "cancel", "fault"}, this._invoked - 1);
        INVOKE.object((boolean)false, (Set)new ActivityRecoveryChannelListener(activityRecoveryChannel){
            private static final long serialVersionUID = 8397883882810521685L;

            public void retry() {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Retrying invoke activity " + INVOKE.this._self.aId + " (user initiated)"));
                }
                INVOKE.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("retry"));
                INVOKE.this.getBpelRuntimeContext().unregisterActivityForRecovery(activityRecoveryChannel);
                4.instance((JacobRunnable)INVOKE.this);
            }

            public void cancel() {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Cancelling invoke activity " + INVOKE.this._self.aId + " (user initiated)"));
                }
                INVOKE.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("cancel"));
                INVOKE.this.getBpelRuntimeContext().unregisterActivityForRecovery(activityRecoveryChannel);
                INVOKE.this._self.parent.cancelled();
            }

            public void fault(FaultData faultData) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Faulting invoke activity " + INVOKE.this._self.aId + " (user initiated)"));
                }
                INVOKE.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("fault"));
                INVOKE.this.getBpelRuntimeContext().unregisterActivityForRecovery(activityRecoveryChannel);
                if (faultData == null) {
                    faultData = INVOKE.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, (OBase)INVOKE.this._self.o, INVOKE.this._failureReason);
                }
                INVOKE.this._self.parent.completed(faultData, CompensationHandler.emptySet());
            }
        }.or(new TerminationChannelListener(this._self.self){
            private static final long serialVersionUID = 2148587381204858397L;

            public void terminate() {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ActivityRecovery: Cancelling invoke activity " + INVOKE.this._self.aId + " (terminated by scope)"));
                }
                INVOKE.this.getBpelRuntimeContext().unregisterActivityForRecovery(activityRecoveryChannel);
                INVOKE.this._self.parent.completed(null, CompensationHandler.emptySet());
            }
        }));
    }
}

