/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableReadEvent;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.o.OConstantVarType;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprEvaluationContextImpl
implements EvaluationContext {
    private static final Log __log = LogFactory.getLog(ExprEvaluationContextImpl.class);
    private BpelRuntimeContext _native;
    private ScopeFrame _scopeInstance;
    private Map<OLink, Boolean> _linkVals;
    private Node _root;

    public ExprEvaluationContextImpl(ScopeFrame scopeFrame, BpelRuntimeContext bpelRuntimeContext) {
        this._native = bpelRuntimeContext;
        this._scopeInstance = scopeFrame;
    }

    public ExprEvaluationContextImpl(ScopeFrame scopeFrame, BpelRuntimeContext bpelRuntimeContext, Node node) {
        this(scopeFrame, bpelRuntimeContext);
        this._root = node;
    }

    public ExprEvaluationContextImpl(ScopeFrame scopeFrame, BpelRuntimeContext bpelRuntimeContext, Map<OLink, Boolean> map) {
        this(scopeFrame, bpelRuntimeContext);
        this._linkVals = map;
    }

    public Node readVariable(OScope.Variable variable, OMessageVarType.Part part) throws FaultException {
        Node node;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("readVariable(" + variable + "," + part + ")"));
        }
        if (variable.type instanceof OConstantVarType) {
            node = ((OConstantVarType)variable.type).getValue();
        } else {
            VariableInstance variableInstance = this._scopeInstance.resolve(variable);
            if (variableInstance == null) {
                return null;
            }
            VariableReadEvent variableReadEvent = new VariableReadEvent();
            variableReadEvent.setVarName(variableInstance.declaration.name);
            this.sendEvent((ScopeEvent)variableReadEvent);
            node = this._scopeInstance.fetchVariableData(this._native, variableInstance, part, false);
        }
        return node;
    }

    public Node evaluateQuery(Node node, OExpression oExpression) throws FaultException, EvaluationException {
        return this._native.getExpLangRuntime().evaluateNode(oExpression, new ExprEvaluationContextImpl(this._scopeInstance, this._native, node));
    }

    public String readMessageProperty(OScope.Variable variable, OProcess.OProperty oProperty) throws FaultException {
        VariableInstance variableInstance = this._scopeInstance.resolve(variable);
        return this._native.readProperty(variableInstance, oProperty);
    }

    public boolean isLinkActive(OLink oLink) throws FaultException {
        return this._linkVals.get(oLink);
    }

    public String toString() {
        return "{ExprEvaluationContextImpl scopeInstance=" + this._scopeInstance + ", activeLinks=" + this._linkVals + "}";
    }

    public Node getRootNode() {
        return this._root;
    }

    public Node getPartData(Element element, OMessageVarType.Part part) throws FaultException {
        return this._scopeInstance.getPartData(element, part);
    }

    public Long getProcessId() {
        return this._native.getPid();
    }

    public boolean narrowTypes() {
        return true;
    }

    private void sendEvent(ScopeEvent scopeEvent) {
        this._scopeInstance.fillEventInfo(scopeEvent);
        this._native.sendEvent((ProcessInstanceEvent)scopeEvent);
    }

    public URI getBaseResourceURI() {
        return this._native.getBaseResourceURI();
    }

    public Node getPropertyValue(QName qName) {
        return this._native.getProcessProperty(qName);
    }

    public QName getProcessQName() {
        return this._native.getProcessQName();
    }
}

