/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OEventHandler;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.SCOPE;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.Selector;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.EventHandlerControlChannel;
import org.apache.ode.bpel.runtime.channels.EventHandlerControlChannelListener;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannel;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.runtime.channels.PickResponseChannel;
import org.apache.ode.bpel.runtime.channels.PickResponseChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannel;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class EH_EVENT
extends BpelJacobRunnable {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(EH_EVENT.class);
    private EventHandlerControlChannel _ehc;
    private TerminationChannel _tc;
    private ParentScopeChannel _psc;
    private ScopeFrame _scopeFrame;
    private OEventHandler.OEvent _oevent;
    private Set<CompensationHandler> _comps = new HashSet<CompensationHandler>();
    private FaultData _fault;
    private Set<ActivityInfo> _active = new HashSet<ActivityInfo>();
    private boolean _stopped;
    private boolean _terminated;
    private boolean _childrenTerminated;

    EH_EVENT(ParentScopeChannel parentScopeChannel, TerminationChannel terminationChannel, EventHandlerControlChannel eventHandlerControlChannel, OEventHandler.OEvent oEvent, ScopeFrame scopeFrame) {
        this._scopeFrame = scopeFrame;
        this._oevent = oEvent;
        this._tc = terminationChannel;
        this._psc = parentScopeChannel;
        this._ehc = eventHandlerControlChannel;
    }

    public void run() {
        EH_EVENT.instance((JacobRunnable)new SELECT());
    }

    private void terminateActive() {
        if (!this._childrenTerminated) {
            for (ActivityInfo activityInfo : this._active) {
                ((TerminationChannel)EH_EVENT.replication((Channel)activityInfo.self)).terminate();
            }
            this._childrenTerminated = true;
        }
    }

    private class WAITING
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;
        private PickResponseChannel _pickResponseChannel;

        private WAITING(PickResponseChannel pickResponseChannel) {
            this._pickResponseChannel = pickResponseChannel;
        }

        public void run() {
            if (!EH_EVENT.this._active.isEmpty() || this._pickResponseChannel != null) {
                HashSet<ChannelListener> hashSet = new HashSet<ChannelListener>();
                if (!EH_EVENT.this._terminated) {
                    hashSet.add(new TerminationChannelListener(EH_EVENT.this._tc){
                        private static final long serialVersionUID = 7666910462948788042L;

                        public void terminate() {
                            EH_EVENT.this.terminateActive();
                            EH_EVENT.this._terminated = true;
                            if (WAITING.this._pickResponseChannel != null) {
                                WAITING.this.getBpelRuntimeContext().cancel(WAITING.this._pickResponseChannel);
                            }
                            1.instance((JacobRunnable)WAITING.this);
                        }
                    });
                }
                if (!EH_EVENT.this._stopped) {
                    hashSet.add(new EventHandlerControlChannelListener(EH_EVENT.this._ehc){
                        private static final long serialVersionUID = -1050788954724647970L;

                        public void stop() {
                            EH_EVENT.this._stopped = true;
                            if (WAITING.this._pickResponseChannel != null) {
                                WAITING.this.getBpelRuntimeContext().cancel(WAITING.this._pickResponseChannel);
                            }
                            2.instance((JacobRunnable)WAITING.this);
                        }
                    });
                }
                for (final ActivityInfo activityInfo : EH_EVENT.this._active) {
                    hashSet.add(new ParentScopeChannelListener(activityInfo.parent){
                        private static final long serialVersionUID = 5341207762415360982L;

                        @Override
                        public void compensate(OScope oScope, SynchChannel synchChannel) {
                            EH_EVENT.this._psc.compensate(oScope, synchChannel);
                            3.instance((JacobRunnable)WAITING.this);
                        }

                        @Override
                        public void completed(FaultData faultData, Set<CompensationHandler> set) {
                            EH_EVENT.this._active.remove(activityInfo);
                            EH_EVENT.this._comps.addAll(set);
                            if (faultData != null && EH_EVENT.this._fault == null) {
                                EH_EVENT.this._fault = faultData;
                                EH_EVENT.this.terminateActive();
                                EH_EVENT.this._psc.completed(EH_EVENT.this._fault, EH_EVENT.this._comps);
                            } else {
                                3.instance((JacobRunnable)WAITING.this);
                            }
                        }

                        @Override
                        public void cancelled() {
                            this.completed(null, CompensationHandler.emptySet());
                        }

                        @Override
                        public void failure(String string, Element element) {
                            this.completed(null, CompensationHandler.emptySet());
                        }
                    });
                }
                if (this._pickResponseChannel != null) {
                    hashSet.add(new PickResponseChannelListener(this._pickResponseChannel){
                        private static final long serialVersionUID = -4929999153478677288L;

                        public void onRequestRcvd(int n, String string) {
                            Object object3;
                            Object object2;
                            ScopeFrame scopeFrame = new ScopeFrame((OScope)EH_EVENT.this._oevent, WAITING.this.getBpelRuntimeContext().createScopeInstance(((EH_EVENT)EH_EVENT.this)._scopeFrame.scopeInstanceId, (OScope)EH_EVENT.this._oevent), EH_EVENT.this._scopeFrame, EH_EVENT.this._comps, EH_EVENT.this._fault);
                            if (((EH_EVENT)EH_EVENT.this)._oevent.variable != null && (object2 = WAITING.this.getBpelRuntimeContext().getMyRequest(string)) != null) {
                                try {
                                    object3 = scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.variable);
                                    WAITING.this.getBpelRuntimeContext().writeVariable((VariableInstance)object3, (Node)object2);
                                    VariableModificationEvent variableModificationEvent = new VariableModificationEvent(object3.declaration.name);
                                    variableModificationEvent.setNewValue(object2);
                                    EH_EVENT.this._scopeFrame.fillEventInfo((ScopeEvent)variableModificationEvent);
                                    if (((EH_EVENT)EH_EVENT.this)._oevent.debugInfo != null) {
                                        variableModificationEvent.setLineNo(((EH_EVENT)EH_EVENT.this)._oevent.debugInfo.startLine);
                                    }
                                    WAITING.this.getBpelRuntimeContext().sendEvent((ProcessInstanceEvent)variableModificationEvent);
                                }
                                catch (Exception exception) {
                                    __log.fatal((Object)exception);
                                    throw new InvalidProcessException(exception);
                                }
                            }
                            try {
                                for (Object object3 : ((EH_EVENT)EH_EVENT.this)._oevent.initCorrelations) {
                                    WAITING.this.initializeCorrelation(scopeFrame.resolve((OScope.CorrelationSet)object3), scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.variable));
                                }
                                object2 = ((EH_EVENT)EH_EVENT.this)._oevent.joinCorrelations.iterator();
                                while (object2.hasNext()) {
                                    object3 = (OScope.CorrelationSet)object2.next();
                                    WAITING.this.initializeCorrelation(scopeFrame.resolve((OScope.CorrelationSet)object3), scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.variable));
                                }
                                if (((EH_EVENT)EH_EVENT.this)._oevent.partnerLink.hasPartnerRole()) {
                                    if (!(WAITING.this.getBpelRuntimeContext().isPartnerRoleEndpointInitialized(scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink)) && ((EH_EVENT)EH_EVENT.this)._oevent.partnerLink.initializePartnerRole || (object2 = WAITING.this.getBpelRuntimeContext().getSourceEPR(string)) == null)) {
                                        WAITING.this.getBpelRuntimeContext().writeEndpointReference(scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink), (Element)object2);
                                    }
                                    if ((object2 = WAITING.this.getBpelRuntimeContext().getSourceSessionId(string)) != null) {
                                        WAITING.this.getBpelRuntimeContext().initializePartnersSessionId(scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink), (String)object2);
                                    }
                                }
                            }
                            catch (FaultException faultException) {
                                __log.error((Object)faultException);
                                if (EH_EVENT.this._fault == null) {
                                    EH_EVENT.this._fault = WAITING.this.createFault(faultException.getQName(), (OBase)EH_EVENT.this._oevent);
                                    EH_EVENT.this.terminateActive();
                                }
                                4.instance((JacobRunnable)new WAITING(null));
                                return;
                            }
                            object2 = new ActivityInfo(WAITING.this.genMonotonic(), ((EH_EVENT)EH_EVENT.this)._oevent.activity, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
                            EH_EVENT.this._active.add(object2);
                            object3 = new LinkFrame(null);
                            4.instance((JacobRunnable)new SCOPE((ActivityInfo)object2, scopeFrame, (LinkFrame)object3));
                            if (EH_EVENT.this._childrenTerminated) {
                                ((TerminationChannel)4.replication((Channel)((ActivityInfo)object2).self)).terminate();
                            }
                            if (EH_EVENT.this._terminated || EH_EVENT.this._stopped || EH_EVENT.this._fault != null) {
                                4.instance((JacobRunnable)new WAITING(null));
                            } else {
                                4.instance((JacobRunnable)new SELECT());
                            }
                        }

                        public void onTimeout() {
                            4.instance((JacobRunnable)new WAITING(null));
                        }

                        public void onCancel() {
                            4.instance((JacobRunnable)new WAITING(null));
                        }
                    });
                }
                WAITING.object((boolean)false, hashSet);
            } else {
                EH_EVENT.this._psc.completed(EH_EVENT.this._fault, EH_EVENT.this._comps);
            }
        }
    }

    class SELECT
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;

        SELECT() {
        }

        public void run() {
            try {
                PickResponseChannel pickResponseChannel = (PickResponseChannel)this.newChannel(PickResponseChannel.class);
                CorrelationKeySet correlationKeySet = new CorrelationKeySet();
                PartnerLinkInstance partnerLinkInstance = EH_EVENT.this._scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink);
                for (OScope.CorrelationSet correlationSet : ((EH_EVENT)EH_EVENT.this)._oevent.joinCorrelations) {
                    if (!this.getBpelRuntimeContext().isCorrelationInitialized(EH_EVENT.this._scopeFrame.resolve(correlationSet))) continue;
                    correlationKeySet.add(this.getBpelRuntimeContext().readCorrelation(EH_EVENT.this._scopeFrame.resolve(correlationSet)));
                }
                for (OScope.CorrelationSet correlationSet : ((EH_EVENT)EH_EVENT.this)._oevent.matchCorrelations) {
                    if (!this.getBpelRuntimeContext().isCorrelationInitialized(EH_EVENT.this._scopeFrame.resolve(correlationSet))) {
                        throw new FaultException(((EH_EVENT)EH_EVENT.this)._oevent.getOwner().constants.qnCorrelationViolation, "Correlation not initialized.");
                    }
                    correlationKeySet.add(this.getBpelRuntimeContext().readCorrelation(EH_EVENT.this._scopeFrame.resolve(correlationSet)));
                }
                if (correlationKeySet.isEmpty()) {
                    String string = this.getBpelRuntimeContext().fetchMySessionId(partnerLinkInstance);
                    correlationKeySet.add(new CorrelationKey("-1", new String[]{string}));
                }
                Selector selector = new Selector(0, partnerLinkInstance, ((EH_EVENT)EH_EVENT.this)._oevent.operation.getName(), ((EH_EVENT)EH_EVENT.this)._oevent.operation.getOutput() == null, ((EH_EVENT)EH_EVENT.this)._oevent.messageExchangeId, correlationKeySet, ((EH_EVENT)EH_EVENT.this)._oevent.route);
                this.getBpelRuntimeContext().select(pickResponseChannel, null, false, new Selector[]{selector});
                SELECT.instance((JacobRunnable)new WAITING(pickResponseChannel));
            }
            catch (FaultException faultException) {
                __log.error((Object)faultException);
                if (EH_EVENT.this._fault == null) {
                    EH_EVENT.this._fault = this.createFault(faultException.getQName(), (OBase)EH_EVENT.this._oevent);
                }
                EH_EVENT.this.terminateActive();
                SELECT.instance((JacobRunnable)new WAITING(null));
            }
        }
    }
}

