/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.runtime.ACTIVITYGUARD;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.CorrelationSetInstance;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.vpu.JacobVPU;
import org.w3c.dom.Element;

public abstract class BpelJacobRunnable
extends JacobRunnable {
    private static final Log __log = LogFactory.getLog(BpelJacobRunnable.class);

    protected BpelRuntimeContext getBpelRuntimeContext() {
        BpelRuntimeContext bpelRuntimeContext = (BpelRuntimeContext)JacobVPU.activeJacobThread().getExtension(BpelRuntimeContext.class);
        assert (bpelRuntimeContext != null);
        return bpelRuntimeContext;
    }

    protected Log log() {
        return __log;
    }

    protected final FaultData createFault(QName qName, Element element, OVarType oVarType, OBase oBase) {
        return new FaultData(qName, element, oVarType, oBase);
    }

    protected final FaultData createFault(QName qName, OBase oBase, String string) {
        return new FaultData(qName, oBase, string);
    }

    protected final FaultData createFault(QName qName, OBase oBase) {
        return this.createFault(qName, oBase, null);
    }

    protected JacobRunnable createChild(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        return new ACTIVITYGUARD(activityInfo, scopeFrame, linkFrame);
    }

    protected void initializeCorrelation(CorrelationSetInstance correlationSetInstance, VariableInstance variableInstance) throws FaultException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Initializing correlation set " + correlationSetInstance.declaration.name));
        }
        if (this.getBpelRuntimeContext().isCorrelationInitialized(correlationSetInstance)) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("OCorrelation set " + correlationSetInstance + " is already set: ignoring"));
            }
            return;
        }
        String[] stringArray = new String[correlationSetInstance.declaration.properties.size()];
        String[] stringArray2 = new String[correlationSetInstance.declaration.properties.size()];
        for (int i = 0; i < correlationSetInstance.declaration.properties.size(); ++i) {
            OProcess.OProperty oProperty = (OProcess.OProperty)correlationSetInstance.declaration.properties.get(i);
            stringArray2[i] = this.getBpelRuntimeContext().readProperty(variableInstance, oProperty);
            stringArray[i] = oProperty.name.toString();
            if (!__log.isDebugEnabled()) continue;
            __log.debug((Object)("Setting correlation property " + stringArray[i] + "=" + stringArray2[i]));
        }
        CorrelationKey correlationKey = new CorrelationKey(correlationSetInstance.declaration.name, stringArray2);
        this.getBpelRuntimeContext().writeCorrelation(correlationSetInstance, correlationKey);
    }

    protected long genMonotonic() {
        return this.getBpelRuntimeContext().genId();
    }
}

