/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.PartnerLinkModificationEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.o.OAssign;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ASSIGNMessages;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class ASSIGN
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(ASSIGN.class);
    private static final ASSIGNMessages __msgs = (ASSIGNMessages)MessageBundle.getMessages(ASSIGNMessages.class);

    public ASSIGN(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(activityInfo, scopeFrame, linkFrame);
    }

    public void run() {
        OAssign oAssign = this.getOAsssign();
        FaultData faultData = null;
        for (OAssign.Copy copy : oAssign.copy) {
            try {
                this.copy(copy);
            }
            catch (FaultException faultException) {
                if (copy.ignoreMissingFromData && faultException.getQName().equals(this.getOAsssign().getOwner().constants.qnSelectionFailure) && faultException.getCause() != null && "ignoreMissingFromData".equals(faultException.getCause().getMessage()) || copy.ignoreUninitializedFromVariable && faultException.getQName().equals(this.getOAsssign().getOwner().constants.qnUninitializedVariable) && (faultException.getCause() == null || !"throwUninitializedToVariable".equals(faultException.getCause().getMessage()))) continue;
                faultData = this.createFault(faultException.getQName(), (OBase)copy, faultException.getMessage());
                break;
            }
            catch (ExternalVariableModuleException externalVariableModuleException) {
                __log.error((Object)"Exception while initializing external variable", (Throwable)externalVariableModuleException);
                this._self.parent.failure(externalVariableModuleException.toString(), null);
                return;
            }
        }
        if (faultData != null) {
            __log.info((Object)("Assignment Fault: " + faultData.getFaultName() + ",lineNo=" + faultData.getFaultLineNo() + ",faultExplanation=" + faultData.getExplanation()));
            this._self.parent.completed(faultData, CompensationHandler.emptySet());
        } else {
            this._self.parent.completed(null, CompensationHandler.emptySet());
        }
    }

    protected Log log() {
        return __log;
    }

    private OAssign getOAsssign() {
        return (OAssign)this._self.o;
    }

    private Node evalLValue(OAssign.LValue lValue) throws FaultException, ExternalVariableModuleException {
        BpelRuntimeContext bpelRuntimeContext = this.getBpelRuntimeContext();
        Node node = null;
        if (!(lValue instanceof OAssign.PartnerLinkRef)) {
            VariableInstance variableInstance = this._scopeFrame.resolve(lValue.getVariable());
            if (!bpelRuntimeContext.isVariableInitialized(variableInstance)) {
                Document document = DOMUtils.newDocument();
                Node node2 = lValue.getVariable().type.newInstance(document);
                if (node2.getNodeType() == 3) {
                    Element element = document.createElementNS(null, "temporary-simple-type-wrapper");
                    document.appendChild(element);
                    element.appendChild(node2);
                    node2 = element;
                } else {
                    document.appendChild(node2);
                }
                node = variableInstance.declaration.extVar != null ? this.initializeVariable(variableInstance, node2) : node2;
            } else {
                node = this.fetchVariableData(variableInstance, true);
            }
        }
        return node;
    }

    private Node evalRValue(OAssign.RValue rValue) throws FaultException, ExternalVariableModuleException {
        Node node;
        Object object;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Evaluating FROM expression \"" + rValue + "\"."));
        }
        if (rValue instanceof OAssign.DirectRef) {
            object = (OAssign.DirectRef)rValue;
            this.sendVariableReadEvent(this._scopeFrame.resolve(((OAssign.DirectRef)object).variable));
            Node node2 = this.fetchVariableData(this._scopeFrame.resolve(((OAssign.DirectRef)object).variable), false);
            node = DOMUtils.findChildByName((Element)((Element)node2), (QName)((OAssign.DirectRef)object).elName);
        } else if (rValue instanceof OAssign.VariableRef) {
            object = (OAssign.VariableRef)rValue;
            this.sendVariableReadEvent(this._scopeFrame.resolve(((OAssign.VariableRef)object).variable));
            Node node3 = this.fetchVariableData(this._scopeFrame.resolve(((OAssign.VariableRef)object).variable), false);
            node = this.evalQuery(node3, ((OAssign.VariableRef)object).part != null ? ((OAssign.VariableRef)object).part : ((OAssign.VariableRef)object).headerPart, ((OAssign.VariableRef)object).location, this.getEvaluationContext());
        } else if (rValue instanceof OAssign.PropertyRef) {
            object = (OAssign.PropertyRef)rValue;
            this.sendVariableReadEvent(this._scopeFrame.resolve(((OAssign.PropertyRef)object).variable));
            Node node4 = this.fetchVariableData(this._scopeFrame.resolve(((OAssign.PropertyRef)object).variable), false);
            node = this.evalQuery(node4, ((OAssign.PropertyRef)object).propertyAlias.part, ((OAssign.PropertyRef)object).propertyAlias.location, this.getEvaluationContext());
        } else if (rValue instanceof OAssign.PartnerLinkRef) {
            Element element;
            object = (OAssign.PartnerLinkRef)rValue;
            PartnerLinkInstance partnerLinkInstance = this._scopeFrame.resolve(((OAssign.PartnerLinkRef)object).partnerLink);
            Element element2 = element = ((OAssign.PartnerLinkRef)object).isMyEndpointReference ? this.getBpelRuntimeContext().fetchMyRoleEndpointReferenceData(partnerLinkInstance) : this.getBpelRuntimeContext().fetchPartnerRoleEndpointReferenceData(partnerLinkInstance);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("RValue is a partner link, corresponding endpoint " + element.getClass().getName() + " has value " + DOMUtils.domToString((Node)element)));
            }
            node = element;
        } else if (rValue instanceof OAssign.Expression) {
            OExpression oExpression = ((OAssign.Expression)rValue).expression;
            try {
                object = this.getBpelRuntimeContext().getExpLangRuntime().evaluate(oExpression, this.getEvaluationContext());
            }
            catch (EvaluationException evaluationException) {
                String string = __msgs.msgEvalException(rValue.toString(), evaluationException.getMessage());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(rValue + ": " + string));
                }
                if (evaluationException.getCause() instanceof FaultException) {
                    throw (FaultException)evaluationException.getCause();
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string);
            }
            if (object.size() == 0) {
                String string = __msgs.msgRValueNoNodesSelected(oExpression.toString());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(rValue + ": " + string));
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string, new Throwable("ignoreMissingFromData"));
            }
            if (object.size() > 1) {
                String string = __msgs.msgRValueMultipleNodesSelected(oExpression.toString());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(rValue + ": " + string));
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string);
            }
            node = (Node)object.get(0);
        } else if (rValue instanceof OAssign.Literal) {
            Object object2;
            try {
                object = ((OAssign.Literal)rValue).getXmlLiteral().getDocumentElement();
            }
            catch (Exception exception) {
                String string = __msgs.msgEvalException(rValue.toString(), exception.getMessage());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(rValue + ": " + string));
                }
                if (exception.getCause() instanceof FaultException) {
                    throw (FaultException)exception.getCause();
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string);
            }
            assert (object.getLocalName().equals("literal"));
            object.normalize();
            node = object.getFirstChild();
            if (node != null && node.getNodeType() == 3 && node.getTextContent().trim().length() == 0 && node.getNextSibling() != null) {
                node = node.getNextSibling();
            }
            if (node == null) {
                node = object.getOwnerDocument().createTextNode("");
            } else if (node.getNodeType() == 1) {
                for (object2 = node.getNextSibling(); object2 != null; object2 = object2.getNextSibling()) {
                    if (object2.getNodeType() != 1) continue;
                    String string = __msgs.msgLiteralContainsMultipleEIIs();
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)(rValue + ": " + string));
                    }
                    throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string);
                }
            } else if (node.getNodeType() == 3) {
                for (object2 = node.getNextSibling(); object2 != null; object2 = object2.getNextSibling()) {
                    if (object2.getNodeType() != 1) continue;
                    String string = __msgs.msgLiteralContainsMixedContent();
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)(rValue + ": " + string));
                    }
                    throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string);
                }
            }
            if (node == null) {
                object2 = __msgs.msgLiteralMustContainTIIorEII();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(rValue + ": " + (String)object2));
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, (String)object2);
            }
        } else {
            String string = __msgs.msgInternalError("Unknown RVALUE type: " + rValue);
            if (__log.isErrorEnabled()) {
                __log.error((Object)(rValue + ": " + string));
            }
            throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string);
        }
        if (node == null) {
            object = __msgs.msgEmptyRValue();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)(rValue + ": " + (String)object));
            }
            throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, (String)object);
        }
        switch (node.getNodeType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                object = __msgs.msgInvalidRValue();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(rValue + ": " + (String)object));
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, (String)object);
            }
        }
        return node;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copy(OAssign.Copy copy) throws FaultException, ExternalVariableModuleException {
        VariableModificationEvent variableModificationEvent;
        block21: {
            Object object;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Assign.copy(" + copy + ")"));
            }
            if (copy.to instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.to).isMessageRef() || copy.from instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.from).isMessageRef()) {
                if (copy.to instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.to).isMessageRef() && copy.from instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.from).isMessageRef()) {
                    VariableInstance variableInstance = this._scopeFrame.resolve(copy.to.getVariable());
                    VariableInstance variableInstance2 = this._scopeFrame.resolve(((OAssign.VariableRef)copy.from).getVariable());
                    Element element = (Element)this.fetchVariableData(variableInstance2, false);
                    this.initializeVariable(variableInstance, element);
                    variableModificationEvent = new VariableModificationEvent(variableInstance.declaration.name);
                    variableModificationEvent.setNewValue((Node)element);
                    break block21;
                } else {
                    __log.fatal((Object)("Message/Non-Message Assignment, should be caught by compiler:" + copy));
                    throw new FaultException(copy.getOwner().constants.qnSelectionFailure, "Message/Non-Message Assignment:  " + copy);
                }
            }
            Node node = this.evalRValue(copy.from);
            Node node2 = this.evalLValue(copy.to);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("lvalue after eval " + node2));
                if (node2 != null) {
                    __log.debug((Object)("content " + DOMUtils.domToString((Node)node2)));
                }
            }
            Node node3 = node2;
            boolean bl = false;
            if (copy.to instanceof OAssign.DirectRef) {
                OAssign.DirectRef directRef = (OAssign.DirectRef)copy.to;
                object = DOMUtils.findChildByName((Element)((Element)node2), (QName)directRef.elName);
                if (object == null) {
                    object = (Element)((Element)node2).appendChild(node2.getOwnerDocument().createElementNS(directRef.elName.getNamespaceURI(), directRef.elName.getLocalPart()));
                }
                node3 = object;
            } else if (copy.to instanceof OAssign.VariableRef) {
                OAssign.VariableRef variableRef = (OAssign.VariableRef)copy.to;
                if (variableRef.headerPart != null) {
                    bl = true;
                }
                node3 = this.evalQuery(node2, variableRef.part != null ? variableRef.part : variableRef.headerPart, variableRef.location, new EvaluationContextProxy(variableRef.getVariable(), node2));
            } else if (copy.to instanceof OAssign.PropertyRef) {
                OAssign.PropertyRef propertyRef = (OAssign.PropertyRef)copy.to;
                node3 = this.evalQuery(node2, propertyRef.propertyAlias.part, propertyRef.propertyAlias.location, new EvaluationContextProxy(propertyRef.getVariable(), node2));
            } else if (copy.to instanceof OAssign.LValueExpression) {
                OAssign.LValueExpression lValueExpression = (OAssign.LValueExpression)copy.to;
                lValueExpression.setInsertMissingToData(copy.insertMissingToData);
                node3 = this.evalQuery(node2, null, (OExpression)lValueExpression.expression, new EvaluationContextProxy(lValueExpression.getVariable(), node2));
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("lvaluePtr expr res " + node3));
                }
            }
            if (copy.to instanceof OAssign.PartnerLinkRef) {
                OAssign.PartnerLinkRef partnerLinkRef = (OAssign.PartnerLinkRef)copy.to;
                object = this._scopeFrame.resolve(partnerLinkRef.partnerLink);
                this.replaceEndpointRefence((PartnerLinkInstance)object, node);
                variableModificationEvent = new PartnerLinkModificationEvent(((OAssign.PartnerLinkRef)copy.to).partnerLink.getName());
            } else {
                if (copy.from instanceof OAssign.PartnerLinkRef && (node = this.getBpelRuntimeContext().convertEndpointReference((Element)node, node3)).getNodeType() == 9) {
                    node = ((Document)node).getDocumentElement();
                }
                node2 = bl && node3.getParentNode().getNodeName().equals("message") && node.getNodeType() == 1 ? this.copyInto((Element)node2, (Element)node3, (Element)node) : (node.getNodeType() == 1 && node3.getNodeType() == 1 ? this.replaceElement((Element)node2, (Element)node3, (Element)node, copy.keepSrcElementName) : this.replaceContent(node2, node3, node.getTextContent()));
                VariableInstance variableInstance = this._scopeFrame.resolve(copy.to.getVariable());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ASSIGN Writing variable '" + variableInstance.declaration.name + "' value '" + DOMUtils.domToString((Node)node2) + "'"));
                }
                this.commitChanges(variableInstance, node2);
                variableModificationEvent = new VariableModificationEvent(variableInstance.declaration.name);
                variableModificationEvent.setNewValue(node2);
            }
        }
        if (copy.debugInfo != null) {
            variableModificationEvent.setLineNo(copy.debugInfo.startLine);
        }
        this.sendEvent((ScopeEvent)variableModificationEvent);
    }

    Node fetchVariableData(VariableInstance variableInstance, boolean bl) throws FaultException {
        try {
            return super.fetchVariableData(variableInstance, bl);
        }
        catch (FaultException faultException) {
            FaultException faultException2;
            if (bl) {
                faultException2 = new FaultException(faultException.getQName(), faultException.getMessage(), new Throwable("throwUninitializedToVariable"));
            }
            throw faultException2;
        }
    }

    private void replaceEndpointRefence(PartnerLinkInstance partnerLinkInstance, Node node) throws FaultException {
        if (node.getNodeType() == 2) {
            throw new FaultException(this.getOAsssign().getOwner().constants.qnMismatchedAssignmentFailure, "Can't assign an attribute to an endpoint, you probably want to select the attribute text.");
        }
        if (node.getNodeType() == 3 || node.getNodeType() == 1 && !node.getLocalName().equals("service-ref")) {
            Document document = DOMUtils.newDocument();
            Element element = document.createElementNS(Namespaces.WSBPEL2_0_FINAL_SERVREF, "service-ref");
            document.appendChild(element);
            if (node.getNodeType() == 3) {
                element.appendChild(document.importNode(node, true));
            } else {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    element.appendChild(document.importNode(node2, true));
                }
            }
            node = element;
        }
        this.getBpelRuntimeContext().writeEndpointReference(partnerLinkInstance, (Element)node);
    }

    private Element replaceElement(Element element, Element element2, Element element3, boolean bl) {
        Document document = element2.getOwnerDocument();
        Node node = element2.getParentNode();
        if (bl) {
            Element element4 = (Element)document.importNode(element3, true);
            node.replaceChild(element4, element2);
            return element == element2 ? element4 : element;
        }
        Element element5 = document.createElementNS(element2.getNamespaceURI(), element2.getLocalName());
        NodeList nodeList = element3.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element5.appendChild(document.importNode(nodeList.item(i), true));
        }
        NamedNodeMap namedNodeMap = element3.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string;
            String string2;
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr.getName().startsWith("xmlns")) continue;
            element5.setAttributeNodeNS((Attr)document.importNode(namedNodeMap.item(i), true));
            int n = attr.getValue().indexOf(":");
            if (n <= 0 || (string2 = element3.lookupPrefix(string = attr.getValue().substring(0, n))) == null) continue;
            element5.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
        }
        node.replaceChild(element5, element2);
        DOMUtils.copyNSContext((Element)element2, (Element)element5);
        return element == element2 ? element5 : element;
    }

    private Element copyInto(Element element, Element element2, Element element3) {
        element2.appendChild(element2.getOwnerDocument().importNode(element3, true));
        return element;
    }

    private Node replaceContent(Node node, Node node2, String string) throws FaultException {
        Document document = node2.getOwnerDocument();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("lvaluePtr type " + node2.getNodeType()));
            __log.debug((Object)("lvaluePtr " + DOMUtils.domToString((Node)node2)));
            __log.debug((Object)("lvalue " + node));
            __log.debug((Object)("rvalue " + string));
        }
        switch (node2.getNodeType()) {
            case 1: {
                while (node2.hasChildNodes()) {
                    node2.removeChild(node2.getFirstChild());
                }
                node2.appendChild(document.createTextNode(string));
                if (!(node instanceof Text)) break;
                node = node2.getFirstChild();
                break;
            }
            case 3: {
                Text text = document.createTextNode(string);
                node2.getParentNode().replaceChild(text, node2);
                if (node.getNodeType() == 1) {
                    if (node.getFirstChild() == null) {
                        Text text2 = node.getOwnerDocument().createTextNode("");
                        node.appendChild(text2);
                    }
                    if (node.getFirstChild().getNodeType() == 3) {
                        node = node.getFirstChild();
                    }
                }
                if (node.getNodeType() != 3 || !((Text)node).getWholeText().equals(((Text)node2).getWholeText())) break;
                node = node2 = text;
                break;
            }
            case 2: {
                ((Attr)node2).setValue(string);
                break;
            }
            default: {
                String string2 = __msgs.msgInvalidLValue();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(node2 + ": " + string2));
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string2);
            }
        }
        return node;
    }

    private Node evalQuery(Node object, OMessageVarType.Part part, OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        Object object2;
        assert (object != null);
        if (part != null) {
            QName qName = new QName(null, part.name);
            object2 = DOMUtils.findChildByName((Element)((Element)object), (QName)qName);
            if (part.type instanceof OElementVarType) {
                QName qName2 = ((OElementVarType)part.type).elementType;
                object2 = DOMUtils.findChildByName((Element)((Element)object2), (QName)qName2);
            } else if (part.type == null) {
                if (object2 != null && object2.getNodeType() == 1 && ((Element)object2).getAttribute("headerPart") != null && DOMUtils.getTextContent((Node)object2) == null) {
                    object2 = DOMUtils.getFirstChildElement((Element)((Element)object2));
                }
                if (object2 == null) {
                    object2 = object.getOwnerDocument().createElementNS(null, part.name);
                    ((Element)object2).setAttribute("headerPart", "true");
                    object.appendChild((Node)object2);
                }
            }
            object = object2;
        }
        if (oExpression != null) {
            try {
                object = evaluationContext.evaluateQuery((Node)object, oExpression);
            }
            catch (EvaluationException evaluationException) {
                object2 = __msgs.msgEvalException(oExpression.toString(), evaluationException.getMessage());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(oExpression + ": " + (String)object2));
                }
                if (evaluationException.getCause() instanceof FaultException) {
                    throw (FaultException)evaluationException.getCause();
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSubLanguageExecutionFault, (String)object2);
            }
        }
        return object;
    }

    private class EvaluationContextProxy
    implements EvaluationContext {
        private OScope.Variable _var;
        private Node _varNode;
        private Node _rootNode;
        private EvaluationContext _ctx;

        private EvaluationContextProxy(OScope.Variable variable, Node node) {
            this._var = variable;
            this._varNode = node;
            this._ctx = ASSIGN.this.getEvaluationContext();
        }

        public Node readVariable(OScope.Variable variable, OMessageVarType.Part part) throws FaultException {
            if (variable.name.equals(this._var.name)) {
                if (part == null) {
                    return this._varNode;
                }
                return this._ctx.getPartData((Element)this._varNode, part);
            }
            return this._ctx.readVariable(variable, part);
        }

        public String readMessageProperty(OScope.Variable variable, OProcess.OProperty oProperty) throws FaultException {
            return this._ctx.readMessageProperty(variable, oProperty);
        }

        public boolean isLinkActive(OLink oLink) throws FaultException {
            return this._ctx.isLinkActive(oLink);
        }

        public Node getRootNode() {
            return this._rootNode;
        }

        public Node evaluateQuery(Node node, OExpression oExpression) throws FaultException {
            this._rootNode = node;
            try {
                return ASSIGN.this.getBpelRuntimeContext().getExpLangRuntime().evaluateNode(oExpression, this);
            }
            catch (EvaluationException evaluationException) {
                throw new InvalidProcessException("Expression Failed: " + oExpression, evaluationException);
            }
        }

        public Node getPartData(Element element, OMessageVarType.Part part) throws FaultException {
            return this._ctx.getPartData(element, part);
        }

        public Long getProcessId() {
            return this._ctx.getProcessId();
        }

        public boolean narrowTypes() {
            return false;
        }

        public URI getBaseResourceURI() {
            return this._ctx.getBaseResourceURI();
        }

        public Node getPropertyValue(QName qName) {
            return this._ctx.getPropertyValue(qName);
        }

        public QName getProcessQName() {
            return this._ctx.getProcessQName();
        }
    }
}

