/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evt.ActivityEnabledEvent;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.ActivityExecEndEvent;
import org.apache.ode.bpel.evt.ActivityExecStartEvent;
import org.apache.ode.bpel.evt.ActivityFailureEvent;
import org.apache.ode.bpel.evt.ActivityRecoveryEvent;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OFailureHandling;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.ActivityTemplateFactory;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.ExprEvaluationContextImpl;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.LinkInfo;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.channels.ActivityRecoveryChannel;
import org.apache.ode.bpel.runtime.channels.ActivityRecoveryChannelListener;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.LinkStatusChannelListener;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannel;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.bpel.runtime.channels.TimerResponseChannel;
import org.apache.ode.bpel.runtime.channels.TimerResponseChannelListener;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;

class ACTIVITYGUARD
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(ACTIVITYGUARD.class);
    private static final ActivityTemplateFactory __activityTemplateFactory = new ActivityTemplateFactory();
    private OActivity _oactivity;
    private Map<OLink, Boolean> _linkVals = new HashMap<OLink, Boolean>();
    private boolean _firstTime = true;
    private ActivityFailure _failure;

    public ACTIVITYGUARD(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(activityInfo, scopeFrame, linkFrame);
        this._oactivity = activityInfo.o;
    }

    public void run() {
        if (this._firstTime) {
            this.sendEvent((ActivityEvent)new ActivityEnabledEvent());
            this._firstTime = false;
        }
        if (this._linkVals.keySet().containsAll(this._oactivity.targetLinks)) {
            if (this.evaluateJoinCondition()) {
                ActivityExecStartEvent activityExecStartEvent = new ActivityExecStartEvent();
                this.sendEvent((ActivityEvent)activityExecStartEvent);
                ActivityInfo activityInfo = new ActivityInfo(this.genMonotonic(), this._self.o, this._self.self, (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
                ACTIVITYGUARD.instance((JacobRunnable)this.createActivity(activityInfo));
                ACTIVITYGUARD.instance((JacobRunnable)new TCONDINTERCEPT(activityInfo.parent));
            } else {
                if (this._oactivity.suppressJoinFailure) {
                    this._self.parent.completed(null, CompensationHandler.emptySet());
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("Join condition false, suppress join failure on activity " + this._self.aId));
                    }
                } else {
                    FaultData faultData = null;
                    faultData = this.createFault(this._oactivity.getOwner().constants.qnJoinFailure, (OBase)this._oactivity);
                    this._self.parent.completed(faultData, CompensationHandler.emptySet());
                }
                this.dpe(this._oactivity);
            }
        } else {
            HashSet<ChannelListener> hashSet = new HashSet<ChannelListener>();
            hashSet.add(new TerminationChannelListener(this._self.self){
                private static final long serialVersionUID = 5094153128476008961L;

                public void terminate() {
                    ACTIVITYGUARD.this._self.parent.completed(null, CompensationHandler.emptySet());
                    ACTIVITYGUARD.this.dpe(ACTIVITYGUARD.this._oactivity);
                }
            });
            for (final OLink oLink : this._oactivity.targetLinks) {
                hashSet.add(new LinkStatusChannelListener(this._linkFrame.resolve((OLink)oLink).sub){
                    private static final long serialVersionUID = 1024137371118887935L;

                    public void linkStatus(boolean bl) {
                        ACTIVITYGUARD.this._linkVals.put(oLink, bl);
                        2.instance((JacobRunnable)ACTIVITYGUARD.this);
                    }
                });
            }
            ACTIVITYGUARD.object((boolean)false, hashSet);
        }
    }

    private boolean evaluateTransitionCondition(OExpression oExpression) throws FaultException {
        if (oExpression == null) {
            return true;
        }
        try {
            return this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsBoolean(oExpression, new ExprEvaluationContextImpl(this._scopeFrame, this.getBpelRuntimeContext()));
        }
        catch (EvaluationException evaluationException) {
            String string = "Error in transition condition detected at runtime; condition=" + oExpression;
            __log.error((Object)string, (Throwable)evaluationException);
            throw new InvalidProcessException(string, evaluationException);
        }
    }

    private boolean evaluateJoinCondition() {
        if (this._oactivity.targetLinks.size() == 0) {
            return true;
        }
        if (this._oactivity.joinCondition == null) {
            return this._linkVals.values().contains(Boolean.TRUE);
        }
        try {
            return this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsBoolean(this._oactivity.joinCondition, new ExprEvaluationContextImpl(null, null, this._linkVals));
        }
        catch (Exception exception) {
            String string = "Unexpected error evaluating a join condition: " + this._oactivity.joinCondition;
            __log.error((Object)string, (Throwable)exception);
            throw new InvalidProcessException(string, exception);
        }
    }

    private static ACTIVITY createActivity(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        return __activityTemplateFactory.createInstance(activityInfo.o, activityInfo, scopeFrame, linkFrame);
    }

    private ACTIVITY createActivity(ActivityInfo activityInfo) {
        return ACTIVITYGUARD.createActivity(activityInfo, this._scopeFrame, this._linkFrame);
    }

    private void startGuardedActivity() {
        ActivityInfo activityInfo = new ActivityInfo(this.genMonotonic(), this._self.o, this._self.self, (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
        ACTIVITYGUARD.instance((JacobRunnable)this.createActivity(activityInfo));
        ACTIVITYGUARD.instance((JacobRunnable)new TCONDINTERCEPT(activityInfo.parent));
    }

    static class ActivityFailure
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Date dateTime;
        String reason;
        Element data;
        int retryCount;

        ActivityFailure() {
        }
    }

    private class TCONDINTERCEPT
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 4014873396828400441L;
        ParentScopeChannel _in;

        public TCONDINTERCEPT(ParentScopeChannel parentScopeChannel) {
            this._in = parentScopeChannel;
        }

        public void run() {
            TCONDINTERCEPT.object((ChannelListener)new ParentScopeChannelListener(this._in){
                private static final long serialVersionUID = 2667359535900385952L;

                @Override
                public void compensate(OScope oScope, SynchChannel synchChannel) {
                    ACTIVITYGUARD.this._self.parent.compensate(oScope, synchChannel);
                    1.instance((JacobRunnable)TCONDINTERCEPT.this);
                }

                @Override
                public void completed(FaultData faultData, Set<CompensationHandler> set) {
                    ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityExecEndEvent());
                    if (faultData != null) {
                        ACTIVITYGUARD.this.dpe(((ACTIVITYGUARD)ACTIVITYGUARD.this)._oactivity.sourceLinks);
                        ACTIVITYGUARD.this._self.parent.completed(faultData, set);
                    } else {
                        FaultData faultData2 = null;
                        for (OLink oLink : ((ACTIVITYGUARD)ACTIVITYGUARD.this)._oactivity.sourceLinks) {
                            LinkInfo linkInfo = ACTIVITYGUARD.this._linkFrame.resolve(oLink);
                            try {
                                boolean bl = ACTIVITYGUARD.this.evaluateTransitionCondition(oLink.transitionCondition);
                                linkInfo.pub.linkStatus(bl);
                            }
                            catch (FaultException faultException) {
                                linkInfo.pub.linkStatus(false);
                                __log.error((Object)faultException);
                                if (faultData2 != null) continue;
                                faultData2 = TCONDINTERCEPT.this.createFault(faultException.getQName(), (OBase)oLink.transitionCondition);
                            }
                        }
                        ACTIVITYGUARD.this._self.parent.completed(faultData2, set);
                    }
                }

                @Override
                public void cancelled() {
                    ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityExecEndEvent());
                    ACTIVITYGUARD.this.dpe(((ACTIVITYGUARD)ACTIVITYGUARD.this)._oactivity.outgoingLinks);
                    ACTIVITYGUARD.this.dpe(((ACTIVITYGUARD)ACTIVITYGUARD.this)._oactivity.sourceLinks);
                    ACTIVITYGUARD.this._self.parent.cancelled();
                }

                @Override
                public void failure(String string, Element element) {
                    if (ACTIVITYGUARD.this._failure == null) {
                        ACTIVITYGUARD.this._failure = new ActivityFailure();
                    }
                    ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.dateTime = new Date();
                    ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.reason = string;
                    ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.data = element;
                    OFailureHandling oFailureHandling = ACTIVITYGUARD.this._oactivity.getFailureHandling();
                    if (oFailureHandling != null && oFailureHandling.faultOnFailure) {
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)("ActivityRecovery: Activity " + ACTIVITYGUARD.this._self.aId + " faulting on failure"));
                        }
                        FaultData faultData = TCONDINTERCEPT.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, (OBase)ACTIVITYGUARD.this._oactivity, string);
                        this.completed(faultData, CompensationHandler.emptySet());
                        return;
                    }
                    if (oFailureHandling == null || ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.retryCount >= oFailureHandling.retryFor) {
                        this.requireRecovery();
                        return;
                    }
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("ActivityRecovery: Retrying activity " + ACTIVITYGUARD.this._self.aId));
                    }
                    Date date = new Date(new Date().getTime() + (oFailureHandling == null ? 0L : (long)(oFailureHandling.retryDelay * 1000)));
                    TimerResponseChannel timerResponseChannel = (TimerResponseChannel)this.newChannel(TimerResponseChannel.class);
                    TCONDINTERCEPT.this.getBpelRuntimeContext().registerTimer(timerResponseChannel, date);
                    1.object((boolean)false, (ChannelListener)new TimerResponseChannelListener(timerResponseChannel){
                        private static final long serialVersionUID = -261911108068231376L;

                        public void onTimeout() {
                            ++((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.retryCount;
                            ACTIVITYGUARD.this.startGuardedActivity();
                        }

                        public void onCancel() {
                            this.requireRecovery();
                        }
                    });
                }

                private void requireRecovery() {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("ActivityRecovery: Activity " + ACTIVITYGUARD.this._self.aId + " requires recovery"));
                    }
                    ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityFailureEvent(((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.reason));
                    final ActivityRecoveryChannel activityRecoveryChannel = (ActivityRecoveryChannel)this.newChannel(ActivityRecoveryChannel.class);
                    TCONDINTERCEPT.this.getBpelRuntimeContext().registerActivityForRecovery(activityRecoveryChannel, ACTIVITYGUARD.this._self.aId, ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.reason, ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.dateTime, ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.data, new String[]{"retry", "cancel", "fault"}, ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.retryCount);
                    1.object((boolean)false, (Set)new ActivityRecoveryChannelListener(activityRecoveryChannel){
                        private static final long serialVersionUID = 8397883882810521685L;

                        public void retry() {
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("ActivityRecovery: Retrying activity " + ACTIVITYGUARD.this._self.aId + " (user initiated)"));
                            }
                            ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("retry"));
                            TCONDINTERCEPT.this.getBpelRuntimeContext().unregisterActivityForRecovery(activityRecoveryChannel);
                            ++((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.retryCount;
                            ACTIVITYGUARD.this.startGuardedActivity();
                        }

                        public void cancel() {
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("ActivityRecovery: Cancelling activity " + ACTIVITYGUARD.this._self.aId + " (user initiated)"));
                            }
                            ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("cancel"));
                            TCONDINTERCEPT.this.getBpelRuntimeContext().unregisterActivityForRecovery(activityRecoveryChannel);
                            this.cancelled();
                        }

                        public void fault(FaultData faultData) {
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("ActivityRecovery: Faulting activity " + ACTIVITYGUARD.this._self.aId + " (user initiated)"));
                            }
                            ACTIVITYGUARD.this.sendEvent((ActivityEvent)new ActivityRecoveryEvent("fault"));
                            TCONDINTERCEPT.this.getBpelRuntimeContext().unregisterActivityForRecovery(activityRecoveryChannel);
                            if (faultData == null) {
                                faultData = TCONDINTERCEPT.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, (OBase)ACTIVITYGUARD.this._self.o, ((ACTIVITYGUARD)ACTIVITYGUARD.this)._failure.reason);
                            }
                            this.completed(faultData, CompensationHandler.emptySet());
                        }
                    }.or(new TerminationChannelListener(ACTIVITYGUARD.this._self.self){
                        private static final long serialVersionUID = 2148587381204858397L;

                        public void terminate() {
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("ActivityRecovery: Cancelling activity " + ACTIVITYGUARD.this._self.aId + " (terminated by scope)"));
                            }
                            TCONDINTERCEPT.this.getBpelRuntimeContext().unregisterActivityForRecovery(activityRecoveryChannel);
                            this.cancelled();
                        }
                    }));
                }
            });
        }
    }
}

