/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableReadEvent;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OConstants;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.EventContextImpl;
import org.apache.ode.bpel.runtime.ExprEvaluationContextImpl;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.jacob.IndexedObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ACTIVITY
extends BpelJacobRunnable
implements IndexedObject {
    private static final Log __log = LogFactory.getLog(ACTIVITY.class);
    protected ActivityInfo _self;
    protected boolean _permeable = true;
    protected ScopeFrame _scopeFrame;
    protected LinkFrame _linkFrame;

    public ACTIVITY(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        assert (activityInfo != null);
        assert (scopeFrame != null);
        assert (linkFrame != null);
        this._self = activityInfo;
        this._scopeFrame = scopeFrame;
        this._linkFrame = linkFrame;
    }

    public Object getKey() {
        return new Key(this._self.o, this._self.aId);
    }

    protected void sendVariableReadEvent(VariableInstance variableInstance) {
        VariableReadEvent variableReadEvent = new VariableReadEvent();
        variableReadEvent.setVarName(variableInstance.declaration.name);
        this.sendEvent((ScopeEvent)variableReadEvent);
    }

    protected void sendEvent(ActivityEvent activityEvent) {
        activityEvent.setActivityName(this._self.o.name);
        activityEvent.setActivityType(this._self.o.getType());
        activityEvent.setActivityDeclarationId(this._self.o.getId());
        activityEvent.setActivityId(this._self.aId);
        if (activityEvent.getLineNo() == -1) {
            activityEvent.setLineNo(this.getLineNo());
        }
        this.sendEvent((ScopeEvent)activityEvent);
    }

    protected void sendEvent(ScopeEvent scopeEvent) {
        if (scopeEvent.getLineNo() == -1 && this._self.o.debugInfo != null) {
            scopeEvent.setLineNo(this._self.o.debugInfo.startLine);
        }
        this._scopeFrame.fillEventInfo(scopeEvent);
        this.fillEventContext(scopeEvent);
        this.getBpelRuntimeContext().sendEvent((ProcessInstanceEvent)scopeEvent);
    }

    protected void fillEventContext(ScopeEvent scopeEvent) {
        EventContextImpl eventContextImpl = new EventContextImpl(this._scopeFrame.oscope, this._scopeFrame.scopeInstanceId, this.getBpelRuntimeContext());
        scopeEvent.eventContext = eventContextImpl;
    }

    protected void dpe(Collection<OLink> collection) {
        for (OLink oLink : collection) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("DPE on link " + oLink.name));
            }
            this._linkFrame.resolve((OLink)oLink).pub.linkStatus(false);
        }
    }

    protected OConstants getConstants() {
        return this._self.o.getOwner().constants;
    }

    protected void dpe(OActivity oActivity) {
        this.dpe(oActivity.sourceLinks);
        this.dpe(oActivity.outgoingLinks);
    }

    protected EvaluationContext getEvaluationContext() {
        return new ExprEvaluationContextImpl(this._scopeFrame, this.getBpelRuntimeContext());
    }

    private int getLineNo() {
        if (this._self.o.debugInfo != null && this._self.o.debugInfo.startLine != -1) {
            return this._self.o.debugInfo.startLine;
        }
        return -1;
    }

    Node fetchVariableData(VariableInstance variableInstance, boolean bl) throws FaultException {
        return this._scopeFrame.fetchVariableData(this.getBpelRuntimeContext(), variableInstance, bl);
    }

    Node fetchVariableData(VariableInstance variableInstance, OMessageVarType.Part part, boolean bl) throws FaultException {
        return this._scopeFrame.fetchVariableData(this.getBpelRuntimeContext(), variableInstance, part, bl);
    }

    Node initializeVariable(VariableInstance variableInstance, Node node) throws ExternalVariableModuleException {
        return this._scopeFrame.initializeVariable(this.getBpelRuntimeContext(), variableInstance, node);
    }

    void commitChanges(VariableInstance variableInstance, Node node) throws ExternalVariableModuleException {
        this._scopeFrame.commitChanges(this.getBpelRuntimeContext(), variableInstance, node);
    }

    Node getPartData(Element element, OMessageVarType.Part part) {
        return this._scopeFrame.getPartData(element, part);
    }

    public static final class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final OActivity type;
        final long aid;

        public Key(OActivity oActivity, long l) {
            this.type = oActivity;
            this.aid = l;
        }

        public String toString() {
            return this.type + "::" + this.aid;
        }
    }
}

