/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.ScopeStateEnum;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.memdao.CorrelationSetDaoImpl;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.bpel.memdao.IdGen;
import org.apache.ode.bpel.memdao.PartnerLinkDAOImpl;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;
import org.apache.ode.bpel.memdao.XmlDataDaoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScopeDaoImpl
extends DaoBaseImpl
implements ScopeDAO {
    private String _type;
    private ScopeStateEnum _state;
    private Map<String, XmlDataDAO> _variables = new HashMap<String, XmlDataDAO>();
    private Map<String, CorrelationSetDAO> _correlations = new HashMap<String, CorrelationSetDAO>();
    private Map<Integer, PartnerLinkDAO> _eprs = new HashMap<Integer, PartnerLinkDAO>();
    private ProcessInstanceDaoImpl _processInstance;
    private ScopeDAO _parent;
    private Long _instanceId;
    private int _scopeModelId;

    public ScopeDaoImpl(ProcessInstanceDaoImpl processInstanceDaoImpl, ScopeDAO scopeDAO, String string, int n) {
        this._processInstance = processInstanceDaoImpl;
        this._parent = scopeDAO;
        this._type = string;
        this._instanceId = IdGen.newScopeId();
        this._scopeModelId = n;
    }

    public CorrelationSetDAO getCorrelationSet(String string) {
        CorrelationSetDAO correlationSetDAO = this._correlations.get(string);
        if (correlationSetDAO == null) {
            correlationSetDAO = new CorrelationSetDaoImpl(string, this);
            this._correlations.put(string, correlationSetDAO);
        }
        return correlationSetDAO;
    }

    public ScopeDAO getParentScope() {
        return this._parent;
    }

    public ProcessInstanceDAO getProcessInstance() {
        return this._processInstance;
    }

    public void setState(ScopeStateEnum scopeStateEnum) {
        this._state = scopeStateEnum;
    }

    public ScopeStateEnum getState() {
        return this._state;
    }

    public String getName() {
        return this._type;
    }

    public XmlDataDAO getVariable(String string) {
        XmlDataDAO xmlDataDAO = this._variables.get(string);
        if (xmlDataDAO == null) {
            xmlDataDAO = new XmlDataDaoImpl(this, string);
            this._variables.put(string, xmlDataDAO);
        }
        return xmlDataDAO;
    }

    public Collection<CorrelationSetDAO> getCorrelationSets() {
        return this._correlations.values();
    }

    public Long getScopeInstanceId() {
        return this._instanceId;
    }

    public int getModelId() {
        return this._scopeModelId;
    }

    public Collection<ScopeDAO> getChildScopes() {
        throw new UnsupportedOperationException();
    }

    public Collection<XmlDataDAO> getVariables() {
        return this._variables.values();
    }

    public List<BpelEvent> listEvents() {
        return new ArrayList<BpelEvent>();
    }

    public PartnerLinkDAO createPartnerLink(int n, String string, String string2, String string3) {
        PartnerLinkDAOImpl partnerLinkDAOImpl = new PartnerLinkDAOImpl();
        partnerLinkDAOImpl.setPartnerLinkModelId(n);
        partnerLinkDAOImpl.setPartnerLinkName(string);
        partnerLinkDAOImpl.setMyRoleName(string2);
        partnerLinkDAOImpl.setPartnerRoleName(string3);
        this._eprs.put(n, partnerLinkDAOImpl);
        return partnerLinkDAOImpl;
    }

    public PartnerLinkDAO getPartnerLink(int n) {
        return this._eprs.get(n);
    }

    public Collection<PartnerLinkDAO> getPartnerLinks() {
        return this._eprs.values();
    }
}

