/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.ActivityRecoveryDAO;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.FaultDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.memdao.CorrelatorDaoImpl;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.bpel.memdao.FaultDaoImpl;
import org.apache.ode.bpel.memdao.IdGen;
import org.apache.ode.bpel.memdao.ProcessDaoImpl;
import org.apache.ode.bpel.memdao.ScopeDaoImpl;
import org.apache.ode.utils.QNameUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceDaoImpl
extends DaoBaseImpl
implements ProcessInstanceDAO {
    private static final Collection<ScopeDAO> EMPTY_SCOPE_DAOS = Collections.emptyList();
    private short _previousState;
    private short _state = 0;
    private Long _instanceId;
    private ProcessDaoImpl _processDao;
    private Object _soup;
    private Map<Long, ScopeDAO> _scopes = new HashMap<Long, ScopeDAO>();
    private Map<String, List<ScopeDAO>> _scopesByName = new HashMap<String, List<ScopeDAO>>();
    private Map<String, byte[]> _messageExchanges = new HashMap<String, byte[]>();
    private ScopeDAO _rootScope;
    private FaultDAO _fault;
    private CorrelatorDAO _instantiatingCorrelator;
    private BpelDAOConnection _conn;
    private int _failureCount;
    private Date _failureDateTime;
    private Map<String, ActivityRecoveryDAO> _activityRecoveries = new HashMap<String, ActivityRecoveryDAO>();
    private List<ProcessInstanceEvent> _events = new ArrayList<ProcessInstanceEvent>();
    private Date _lastActive;
    private int _seq;

    ProcessInstanceDaoImpl(BpelDAOConnection bpelDAOConnection, ProcessDaoImpl processDaoImpl, CorrelatorDAO correlatorDAO) {
        this._processDao = processDaoImpl;
        this._instantiatingCorrelator = correlatorDAO;
        this._soup = null;
        this._instanceId = IdGen.newProcessId();
        this._conn = bpelDAOConnection;
    }

    public XmlDataDAO[] getVariables(String string, int n) {
        ArrayList<XmlDataDAO> arrayList = new ArrayList<XmlDataDAO>();
        for (ScopeDAO scopeDAO : this._scopes.values()) {
            XmlDataDAO xmlDataDAO;
            if (scopeDAO.getModelId() != n || (xmlDataDAO = scopeDAO.getVariable(string)) == null) continue;
            arrayList.add(xmlDataDAO);
        }
        return arrayList.toArray(new XmlDataDAO[arrayList.size()]);
    }

    public Set<CorrelationSetDAO> getCorrelationSets() {
        HashSet<CorrelationSetDAO> hashSet = new HashSet<CorrelationSetDAO>();
        for (ScopeDAO scopeDAO : this._scopes.values()) {
            hashSet.addAll(scopeDAO.getCorrelationSets());
        }
        return hashSet;
    }

    public CorrelationSetDAO getCorrelationSet(String string) {
        for (ScopeDAO scopeDAO : this._scopes.values()) {
            if (scopeDAO.getCorrelationSet(string) == null) continue;
            return scopeDAO.getCorrelationSet(string);
        }
        return null;
    }

    public void setFault(QName qName, String string, int n, int n2, Element element) {
        this._fault = new FaultDaoImpl(QNameUtils.fromQName((QName)qName), string, element, n, n2);
    }

    public void setFault(FaultDAO faultDAO) {
        this._fault = faultDAO;
    }

    public FaultDAO getFault() {
        return this._fault;
    }

    public byte[] getExecutionState() {
        throw new IllegalStateException("In-memory instances are never serialized");
    }

    public void setExecutionState(byte[] byArray) {
        throw new IllegalStateException("In-memory instances are never serialized");
    }

    public Object getSoup() {
        return this._soup;
    }

    public void setSoup(Object object) {
        this._soup = object;
    }

    public byte[] getMessageExchange(String string) {
        byte[] byArray = this._messageExchanges.get(string);
        assert (byArray != null);
        return byArray;
    }

    public ProcessDAO getProcess() {
        return this._processDao;
    }

    public ScopeDAO getRootScope() {
        return this._rootScope;
    }

    public void setState(short s) {
        this._previousState = this._state;
        this._state = s;
        if (s == 60) {
            for (CorrelatorDAO correlatorDAO : this._processDao.getCorrelators()) {
                correlatorDAO.removeRoutes(null, (ProcessInstanceDAO)this);
            }
        }
    }

    public short getState() {
        return this._state;
    }

    public void addMessageExchange(String string, byte[] byArray) {
        assert (!this._messageExchanges.containsKey(string));
        this._messageExchanges.put(string, byArray);
    }

    public ScopeDAO createScope(ScopeDAO scopeDAO, String string, int n) {
        ScopeDaoImpl scopeDaoImpl = new ScopeDaoImpl(this, scopeDAO, string, n);
        this._scopes.put(scopeDaoImpl.getScopeInstanceId(), scopeDaoImpl);
        List<ScopeDAO> list = this._scopesByName.get(string);
        if (list == null) {
            list = new LinkedList<ScopeDAO>();
            this._scopesByName.put(string, list);
        }
        list.add(scopeDaoImpl);
        if (scopeDAO == null) {
            assert (this._rootScope == null);
            this._rootScope = scopeDaoImpl;
        }
        return scopeDaoImpl;
    }

    public Long getInstanceId() {
        return this._instanceId;
    }

    public ScopeDAO getScope(Long l) {
        return this._scopes.get(l);
    }

    public List<ProcessInstanceEvent> getEvents(int n, int n2) {
        int n3 = Math.max(n, 0);
        n3 = Math.min(n3, this._events.size() - 1);
        int n4 = Math.min(n3 + n2, this._events.size());
        return this._events.subList(n3, n4);
    }

    public void insertBpelEvent(ProcessInstanceEvent processInstanceEvent) {
        this._events.add(processInstanceEvent);
    }

    public int getEventCount() {
        return this._events.size();
    }

    public CorrelatorDAO getInstantiatingCorrelator() {
        return this._instantiatingCorrelator;
    }

    public Collection<ScopeDAO> getScopes(String string) {
        List<ScopeDAO> list = this._scopesByName.get(string);
        return list == null ? EMPTY_SCOPE_DAOS : list;
    }

    public short getPreviousState() {
        return this._previousState;
    }

    public Date getLastActiveTime() {
        return this._lastActive;
    }

    public void setLastActiveTime(Date date) {
        this._lastActive = date;
    }

    public void finishCompletion() {
        assert (ProcessState.isFinished((short)this.getState()));
        this.getProcess().instanceCompleted((ProcessInstanceDAO)this);
    }

    public void delete(Set<ProcessConf.CLEANUP_CATEGORY> set) {
        this._processDao._instances.remove(this._instanceId);
    }

    public Collection<ScopeDAO> getScopes() {
        return this._scopes.values();
    }

    public ProcessInstanceDAO.EventsFirstLastCountTuple getEventsFirstLastCount() {
        ProcessInstanceDAO.EventsFirstLastCountTuple eventsFirstLastCountTuple = new ProcessInstanceDAO.EventsFirstLastCountTuple();
        eventsFirstLastCountTuple.count = this._events.size();
        Date date = new Date();
        Date date2 = new Date(0L);
        for (ProcessInstanceEvent processInstanceEvent : this._events) {
            if (processInstanceEvent.getTimestamp().before(date)) {
                date = processInstanceEvent.getTimestamp();
            }
            if (!processInstanceEvent.getTimestamp().after(date2)) continue;
            date2 = processInstanceEvent.getTimestamp();
        }
        eventsFirstLastCountTuple.first = date;
        eventsFirstLastCountTuple.last = date2;
        return eventsFirstLastCountTuple;
    }

    public int getActivityFailureCount() {
        return this._failureCount;
    }

    public Date getActivityFailureDateTime() {
        return this._failureDateTime;
    }

    public Collection<ActivityRecoveryDAO> getActivityRecoveries() {
        return this._activityRecoveries.values();
    }

    public void createActivityRecovery(String string, long l, String string2, Date date, Element element, String[] stringArray, int n) {
        this._activityRecoveries.put(string, new ActivityRecoveryDAOImpl(string, l, string2, date, element, stringArray, n));
        this._failureCount = this._activityRecoveries.size();
        this._failureDateTime = date;
    }

    public void deleteActivityRecovery(String string) {
        this._activityRecoveries.remove(string);
        this._failureCount = this._activityRecoveries.size();
    }

    public synchronized long genMonotonic() {
        return ++this._seq;
    }

    void removeRoutes(String string) {
        for (CorrelatorDaoImpl correlatorDaoImpl : this._processDao._correlators.values()) {
            correlatorDaoImpl._removeRoutes(string, this);
        }
    }

    public BpelDAOConnection getConnection() {
        return this._conn;
    }

    public String toString() {
        return "mem.instance(type=" + this._processDao.getType() + " iid=" + this._instanceId + ")";
    }

    static class ActivityRecoveryDAOImpl
    implements ActivityRecoveryDAO {
        private long _activityId;
        private String _channel;
        private String _reason;
        private Element _details;
        private Date _dateTime;
        private String _actions;
        private int _retries;

        ActivityRecoveryDAOImpl(String string, long l, String string2, Date date, Element element, String[] stringArray, int n) {
            this._activityId = l;
            this._channel = string;
            this._reason = string2;
            this._details = element;
            this._dateTime = date;
            this._actions = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                this._actions = this._actions + " " + stringArray[i];
            }
            this._retries = n;
        }

        public long getActivityId() {
            return this._activityId;
        }

        public String getChannel() {
            return this._channel;
        }

        public String getReason() {
            return this._reason;
        }

        public Element getDetails() {
            return this._details;
        }

        public Date getDateTime() {
            return this._dateTime;
        }

        public String getActions() {
            return this._actions;
        }

        public String[] getActionsList() {
            return this._actions.split(" ");
        }

        public int getRetries() {
            return this._retries;
        }
    }
}

