/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.CorrelatorMessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.memdao.BpelDAOConnectionImpl;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.bpel.memdao.MessageRouteDaoImpl;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CorrelatorDaoImpl
extends DaoBaseImpl
implements CorrelatorDAO {
    private static final Log __log = LogFactory.getLog(CorrelatorDaoImpl.class);
    private String _correlatorId;
    private List<MsgQueueEntry> _messages = new ArrayList<MsgQueueEntry>();
    private List<MessageRouteDaoImpl> _routes = new ArrayList<MessageRouteDaoImpl>();
    private BpelDAOConnectionImpl _conn;

    CorrelatorDaoImpl(String string, BpelDAOConnectionImpl bpelDAOConnectionImpl) {
        this._correlatorId = string;
        this._conn = bpelDAOConnectionImpl;
    }

    public MessageExchangeDAO dequeueMessage(CorrelationKeySet correlationKeySet) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("dequeueEarliest: MATCHING correlationKey=" + correlationKeySet));
        }
        Iterator<MsgQueueEntry> iterator = this._messages.iterator();
        while (iterator.hasNext()) {
            MsgQueueEntry msgQueueEntry = iterator.next();
            CorrelationKeySet correlationKeySet2 = msgQueueEntry.keySet;
            if (!correlationKeySet2.isRoutableTo(correlationKeySet, false)) continue;
            iterator.remove();
            return msgQueueEntry.message;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"dequeueEarliest: MATCH NOT FOUND!");
        }
        return null;
    }

    public List<MessageRouteDAO> findRoute(CorrelationKeySet correlationKeySet) {
        ArrayList<MessageRouteDAO> arrayList = new ArrayList<MessageRouteDAO>();
        assert (correlationKeySet != null);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("findRoute: keySet=" + correlationKeySet));
        }
        boolean bl = false;
        for (MessageRouteDaoImpl messageRouteDaoImpl : this._routes) {
            assert (messageRouteDaoImpl._ckeySet != null);
            if (!correlationKeySet.isRoutableTo(messageRouteDaoImpl._ckeySet, "all".equals(messageRouteDaoImpl.getRoute()))) continue;
            if ("all".equals(messageRouteDaoImpl.getRoute())) {
                arrayList.add(messageRouteDaoImpl);
                continue;
            }
            if (!bl) {
                arrayList.add(messageRouteDaoImpl);
            }
            bl = true;
        }
        return arrayList;
    }

    public String getCorrelatorId() {
        return this._correlatorId;
    }

    public void setCorrelatorId(String string) {
        this._correlatorId = string;
    }

    public void removeRoutes(String string, ProcessInstanceDAO processInstanceDAO) {
        ((ProcessInstanceDaoImpl)processInstanceDAO).removeRoutes(string);
    }

    public Collection<MessageRouteDAO> getAllRoutes() {
        return new ArrayList<MessageRouteDAO>(this._routes);
    }

    public Collection<CorrelatorMessageDAO> getAllMessages() {
        return new ArrayList<CorrelatorMessageDAO>(this._messages);
    }

    public void enqueueMessage(MessageExchangeDAO messageExchangeDAO, CorrelationKeySet correlationKeySet) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("enqueueProcessInvocation: data=" + messageExchangeDAO + " keys=" + correlationKeySet));
        }
        MsgQueueEntry msgQueueEntry = new MsgQueueEntry(messageExchangeDAO, correlationKeySet);
        this._messages.add(msgQueueEntry);
    }

    public void addRoute(String string, ProcessInstanceDAO processInstanceDAO, int n, CorrelationKeySet correlationKeySet, String string2) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("addRoute: target=" + processInstanceDAO + " correlationKeySet=" + correlationKeySet));
        }
        final MessageRouteDaoImpl messageRouteDaoImpl = new MessageRouteDaoImpl((ProcessInstanceDaoImpl)processInstanceDAO, string, correlationKeySet, n, string2);
        this._conn.defer(new Runnable(){

            public void run() {
                CorrelatorDaoImpl.this._routes.add(messageRouteDaoImpl);
            }
        });
    }

    public boolean checkRoute(CorrelationKey correlationKey) {
        return true;
    }

    void _removeRoutes(String string, ProcessInstanceDaoImpl processInstanceDaoImpl) {
        Iterator<MessageRouteDaoImpl> iterator = this._routes.iterator();
        while (iterator.hasNext()) {
            MessageRouteDaoImpl messageRouteDaoImpl = iterator.next();
            if (!messageRouteDaoImpl._groupId.equals(string) && string != null || messageRouteDaoImpl._instance != processInstanceDaoImpl) continue;
            iterator.remove();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{CorrelatorDaoImpl corrId=");
        stringBuffer.append(this._correlatorId);
        stringBuffer.append(" waiters=");
        stringBuffer.append(this._routes);
        stringBuffer.append(" messages=");
        stringBuffer.append(this._messages);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private class MsgQueueEntry
    implements CorrelatorMessageDAO {
        public MessageExchangeDAO message;
        public CorrelationKeySet keySet;

        private MsgQueueEntry(MessageExchangeDAO messageExchangeDAO, CorrelationKeySet correlationKeySet) {
            this.message = messageExchangeDAO;
            this.keySet = correlationKeySet;
        }

        public CorrelationKey getCorrelationKey() {
            return (CorrelationKey)this.keySet.iterator().next();
        }

        public void setCorrelationKey(CorrelationKey correlationKey) {
            this.keySet = new CorrelationKeySet();
            this.keySet.add(correlationKey);
        }
    }
}

