/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.extvar.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.extvar.jdbc.DbExternalVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RowSubset
extends ArrayList<Object> {
    private static final Log LOG = LogFactory.getLog(RowSubset.class);
    private static final long serialVersionUID = 1L;
    protected List<DbExternalVariable.Column> _columns;
    protected HashMap<String, DbExternalVariable.Column> _colmap = new HashMap();

    RowSubset(List<DbExternalVariable.Column> list) {
        this._columns = list;
        for (DbExternalVariable.Column column : list) {
            this.add(null);
            this._colmap.put(column.name, column);
        }
    }

    boolean missingValues() {
        for (DbExternalVariable.Column column : this._columns) {
            if (this.get(column.idx) != null) continue;
            return true;
        }
        return false;
    }

    boolean missingDatabaseGeneratedValues() {
        for (DbExternalVariable.Column column : this._columns) {
            Object e = this.get(column.idx);
            if (!column.isDatabaseGenerated() || e != null) continue;
            return true;
        }
        return false;
    }

    DbExternalVariable.Column getColumn(String string) {
        return this._colmap.get(string);
    }

    DbExternalVariable.Column getColumn(int n) {
        return this._columns.get(n);
    }

    Object get(String string) {
        DbExternalVariable.Column column = this._colmap.get(string);
        if (column == null) {
            return null;
        }
        int n = this._columns.indexOf(column);
        return this.get(n);
    }

    void put(String string, Object object) {
        DbExternalVariable.Column column = this._colmap.get(string);
        if (column == null) {
            return;
        }
        int n = this._columns.indexOf(column);
        this.set(n, object);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getSimpleName());
        stringBuffer.append("(");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this._columns.get((int)i).name);
            stringBuffer.append("=");
            stringBuffer.append(this.get(i));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

