/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.extvar.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evar.IncompleteKeyException;
import org.apache.ode.bpel.extvar.jdbc.DbExternalVariable;
import org.apache.ode.bpel.extvar.jdbc.EVarId;
import org.apache.ode.bpel.extvar.jdbc.GenType;
import org.apache.ode.bpel.extvar.jdbc.InitType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ObjectPrinter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JdbcExternalVariableModule
implements ExternalVariableModule {
    private static final Log __log = LogFactory.getLog(JdbcExternalVariableModule.class);
    public static final String JDBC_NS = "http://ode.apache.org/externalVariables/jdbc";
    public static final QName NAME = new QName("http://ode.apache.org/externalVariables/jdbc", "jdbc");
    private final HashMap<String, DataSource> _dataSources = new HashMap();
    private final HashMap<EVarId, DbExternalVariable> _vars = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(QName qName, String string, Element element) throws ExternalVariableModuleException {
        Object object;
        Object object2;
        Object object3;
        EVarId eVarId = new EVarId(qName, string);
        DataSource dataSource = null;
        Element element2 = DOMUtils.findChildByName((Element)element, (QName)new QName(JDBC_NS, "datasource-jndi"));
        Element element3 = DOMUtils.findChildByName((Element)element, (QName)new QName(JDBC_NS, "datasource-ref"));
        Element element4 = DOMUtils.findChildByName((Element)element, (QName)new QName(JDBC_NS, "init-mode"));
        if (element3 != null) {
            object3 = element3.getTextContent().trim();
            dataSource = this._dataSources.get(object3);
            if (dataSource == null) {
                throw new ExternalVariableModuleException("Data source reference \"" + (String)object3 + "\" not found for external variable " + eVarId + "; make sure to register the data source with the engine!");
            }
        } else if (element2 != null) {
            object3 = element2.getTextContent().trim();
            try {
                object2 = new InitialContext();
            }
            catch (Exception exception) {
                throw new ExternalVariableModuleException("Unable to access JNDI context for external variable " + eVarId, (Throwable)exception);
            }
            try {
                object = ((InitialContext)object2).lookup((String)object3);
            }
            catch (Exception exception) {
                throw new ExternalVariableModuleException("Lookup of data source for " + eVarId + "  failed.", (Throwable)exception);
            }
            finally {
                try {
                    ((InitialContext)object2).close();
                }
                catch (NamingException namingException) {}
            }
            if (object == null) {
                throw new ExternalVariableModuleException("Data source \"" + (String)object3 + "\" not found in JNDI!");
            }
            if (!(object instanceof DataSource)) {
                throw new ExternalVariableModuleException("JNDI object \"" + (String)object3 + "\" does not implement javax.sql.DataSource");
            }
            dataSource = (DataSource)object;
        }
        if (dataSource == null) {
            throw new ExternalVariableModuleException("No valid data source configuration for JDBC external varible " + eVarId);
        }
        try {
            object3 = dataSource.getConnection();
            object3.setAutoCommit(false);
            object = object3.getMetaData();
        }
        catch (Exception exception) {
            throw new ExternalVariableModuleException("Unable to open database connection for external variable " + eVarId, (Throwable)exception);
        }
        try {
            Element element5;
            object2 = new DbExternalVariable(eVarId, dataSource);
            if (element4 != null) {
                try {
                    ((DbExternalVariable)object2)._initType = InitType.valueOf(element4.getTextContent().trim());
                }
                catch (Exception exception) {
                    throw new ExternalVariableModuleException("Invalid <init-mode> value: " + element4.getTextContent().trim());
                }
            }
            if ((element5 = DOMUtils.findChildByName((Element)element, (QName)new QName(JDBC_NS, "table"))) == null || element5.getTextContent().trim().equals("")) {
                throw new ExternalVariableModuleException("Must specify <table> for external variable " + eVarId);
            }
            String string2 = element5.getTextContent().trim();
            String string3 = null;
            if (string2.indexOf(46) != -1) {
                string3 = string2.substring(0, string2.indexOf(46));
                string2 = string2.substring(string2.indexOf(46) + 1);
            }
            if (object.storesLowerCaseIdentifiers()) {
                string2 = string2.toLowerCase();
                if (string3 != null) {
                    string3 = string2.toLowerCase();
                }
            } else if (object.storesUpperCaseIdentifiers()) {
                string2 = string2.toUpperCase();
                if (string3 != null) {
                    string3 = string3.toUpperCase();
                }
            }
            ((DbExternalVariable)object2).generatedKeys = object.supportsGetGeneratedKeys();
            ResultSet resultSet = object.getTables(null, string3, string2, null);
            if (!resultSet.next()) {
                throw new ExternalVariableModuleException("Table \"" + string2 + "\" not found in database.");
            }
            ((DbExternalVariable)object2).table = resultSet.getString("TABLE_NAME");
            ((DbExternalVariable)object2).schema = resultSet.getString("TABLE_SCHEM");
            resultSet.close();
            List list = DOMUtils.findChildrenByName((Element)element, (QName)new QName(JDBC_NS, "column"));
            for (Element element6 : list) {
                DbExternalVariable.Column column;
                block59: {
                    GenType genType;
                    String string4 = element6.getAttribute("name");
                    String string5 = element6.getAttribute("column-name");
                    String string6 = element6.getAttribute("key");
                    String string7 = element6.getAttribute("generator");
                    String string8 = element6.getAttribute("expression");
                    if (string6 == null || "".equals(string6)) {
                        string6 = "no";
                    }
                    if (string7 == null || "".equals(string7)) {
                        string7 = GenType.none.toString();
                    }
                    if (string5 == null || "".equals(string5)) {
                        string5 = string4;
                    }
                    if (string4 == null || "".equals(string4)) {
                        throw new ExternalVariableModuleException("External variable " + eVarId + " <column> element must have \"name\" attribute. ");
                    }
                    if (object.storesLowerCaseIdentifiers()) {
                        string5 = string5.toLowerCase();
                    } else if (object.storesUpperCaseIdentifiers()) {
                        string5 = string5.toUpperCase();
                    }
                    try {
                        genType = GenType.valueOf(string7);
                    }
                    catch (Exception exception) {
                        throw new ExternalVariableModuleException("External variable " + eVarId + " column \"" + string4 + "\" generator type \"" + string7 + "\" is unknown.");
                    }
                    if (genType == GenType.expression && (string8 == null || "".equals(string8))) {
                        throw new ExternalVariableModuleException("External variable " + eVarId + " column \"" + string4 + "\" used \"expression\" generator, but did not specify an expression");
                    }
                    Object object4 = object2;
                    object4.getClass();
                    column = (DbExternalVariable)object4.new DbExternalVariable.Column(string4, string5, string6.equalsIgnoreCase("yes"), genType, string8);
                    ResultSet resultSet2 = object.getColumns(null, ((DbExternalVariable)object2).schema, ((DbExternalVariable)object2).table, string5);
                    try {
                        if (resultSet2.next()) {
                            column.dataType = resultSet2.getInt("DATA_TYPE");
                            column.nullok = resultSet2.getInt("NULLABLE") != 0;
                            break block59;
                        }
                        throw new ExternalVariableModuleException("External variable " + eVarId + " referenced " + "non-existant column \"" + string5 + "\"!");
                    }
                    finally {
                        resultSet2.close();
                    }
                }
                ((DbExternalVariable)object2).addColumn(column);
            }
            if (((DbExternalVariable)object2).numColumns() == 0) {
                throw new ExternalVariableModuleException("External variable " + eVarId + " did not have any <column> elements!");
            }
            this._vars.put(eVarId, (DbExternalVariable)object2);
            object3.commit();
        }
        catch (SQLException sQLException) {
            try {
                object3.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new ExternalVariableModuleException("SQL Error", (Throwable)sQLException);
        }
        finally {
            try {
                object3.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public QName getName() {
        return NAME;
    }

    public boolean isTransactional() {
        return true;
    }

    public void shutdown() {
    }

    public void start() {
    }

    public void stop() {
    }

    public ExternalVariableModule.Value writeValue(QName qName, ExternalVariableModule.Value value) throws ExternalVariableModuleException {
        boolean bl;
        EVarId eVarId = new EVarId(value.locator.pid, value.locator.varId);
        DbExternalVariable dbExternalVariable = this._vars.get(eVarId);
        if (dbExternalVariable == null) {
            throw new ExternalVariableModuleException("No such variable. ");
        }
        DbExternalVariable.RowKey rowKey = dbExternalVariable.keyFromLocator(value.locator);
        DbExternalVariable.RowVal rowVal = dbExternalVariable.parseXmlRow(dbExternalVariable.new DbExternalVariable.RowVal(), (Element)value.value);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("JdbcExternalVariable.writeValue() RowKey: " + rowKey + " RowVal: " + rowVal));
        }
        if (!rowKey.missingValues() && dbExternalVariable._initType == InitType.delete_insert) {
            throw new ExternalVariableModuleException("Delete not implemented. ");
        }
        boolean bl2 = (dbExternalVariable._initType == InitType.update || dbExternalVariable._initType == InitType.update_insert) && !dbExternalVariable._keycolumns.isEmpty() && !rowKey.missingDatabaseGeneratedValues();
        boolean bl3 = bl = dbExternalVariable._initType != InitType.update;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("tryUpdateFirst: " + bl2 + " insert: " + bl + " initType: " + (Object)((Object)dbExternalVariable._initType) + " key.isEmpty: " + dbExternalVariable._keycolumns.isEmpty() + " key.missingValues: " + rowKey.missingValues() + " key.missingDBValues: " + rowKey.missingDatabaseGeneratedValues()));
        }
        try {
            if (bl2) {
                boolean bl4 = bl = this.execUpdate(dbExternalVariable, rowKey, rowVal) == 0;
            }
            if (bl) {
                rowKey = this.execInsert(dbExternalVariable, value.locator, rowKey, rowVal);
                rowKey.write(qName, value.locator);
            }
        }
        catch (SQLException sQLException) {
            throw new ExternalVariableModuleException("Error updating row.", (Throwable)sQLException);
        }
        return value;
    }

    public ExternalVariableModule.Value readValue(QName qName, ExternalVariableModule.Locator locator) throws ExternalVariableModuleException {
        Element element;
        EVarId eVarId = new EVarId(locator.pid, locator.varId);
        DbExternalVariable dbExternalVariable = this._vars.get(eVarId);
        if (dbExternalVariable == null) {
            throw new ExternalVariableModuleException("No such variable: " + eVarId);
        }
        try {
            DbExternalVariable.RowVal rowVal = this.execSelect(dbExternalVariable, locator);
            element = dbExternalVariable.renderXmlRow(locator, qName, rowVal);
        }
        catch (SQLException sQLException) {
            throw new ExternalVariableModuleException("SQL Error.", (Throwable)sQLException);
        }
        return new ExternalVariableModule.Value(locator, (Node)element, null);
    }

    public void registerDataSource(String string, DataSource dataSource) {
        this._dataSources.put(string, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int execUpdate(DbExternalVariable dbExternalVariable, DbExternalVariable.RowKey rowKey, DbExternalVariable.RowVal rowVal) throws SQLException {
        Connection connection = dbExternalVariable.dataSource.getConnection();
        Statement statement = null;
        try {
            Object object;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("execUpdate: key=" + rowKey + " values=" + rowVal));
                __log.debug((Object)("Prepare statement: " + dbExternalVariable.update));
            }
            statement = connection.prepareStatement(dbExternalVariable.update);
            int n = 1;
            for (DbExternalVariable.Column column : dbExternalVariable._updcolumns) {
                object = rowVal.get(column.name);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Set value parameter " + n + ": " + object));
                }
                if (object == null) {
                    statement.setNull(n, column.dataType);
                } else {
                    statement.setObject(n, this.downcastValue(object, column.dataType));
                }
                ++n;
            }
            for (DbExternalVariable.Column column : dbExternalVariable._keycolumns) {
                object = rowKey.get(column.name);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Set key parameter " + n + ": " + object));
                }
                if (object == null) {
                    statement.setNull(n, column.dataType);
                } else {
                    statement.setObject(n, this.downcastValue(object, column.dataType));
                }
                ++n;
            }
            int n2 = statement.executeUpdate();
            return n2;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            connection.close();
        }
    }

    private Object downcastValue(Object object, int n) {
        if (object == null) {
            return null;
        }
        try {
            switch (n) {
                case 2003: {
                    break;
                }
                case -5: {
                    if (object instanceof BigInteger) break;
                    object = new BigDecimal(object.toString()).longValue();
                    break;
                }
                case -2: {
                    break;
                }
                case -7: {
                    if (object instanceof Boolean) break;
                    object = new Boolean(object.toString());
                    break;
                }
                case 2004: {
                    break;
                }
                case 16: {
                    if (object instanceof Boolean) break;
                    object = new Boolean(object.toString());
                    break;
                }
                case 1: {
                    break;
                }
                case 2005: {
                    break;
                }
                case 70: {
                    break;
                }
                case 91: {
                    break;
                }
                case 3: {
                    if (object instanceof BigDecimal) break;
                    object = new BigDecimal(object.toString());
                    break;
                }
                case 2001: {
                    break;
                }
                case 8: {
                    if (object instanceof Double) break;
                    object = (double)Double.valueOf(object.toString());
                    break;
                }
                case 6: {
                    if (object instanceof Float) break;
                    object = Float.valueOf(Float.valueOf(object.toString()).floatValue());
                    break;
                }
                case 4: {
                    if (object instanceof Integer) break;
                    object = Double.valueOf(object.toString()).intValue();
                    break;
                }
                case 2000: {
                    break;
                }
                case -4: {
                    break;
                }
                case -1: {
                    break;
                }
                case 2: {
                    if (object instanceof BigDecimal) break;
                    object = new BigDecimal(object.toString());
                    break;
                }
                case 1111: {
                    break;
                }
                case 7: {
                    if (object instanceof Double) break;
                    object = Float.valueOf(Float.valueOf(object.toString()).floatValue());
                    break;
                }
                case 2006: {
                    break;
                }
                case 5: {
                    if (object instanceof Short) break;
                    object = (short)new Short(object.toString());
                    break;
                }
                case 2002: {
                    break;
                }
                case 92: {
                    break;
                }
                case 93: {
                    break;
                }
                case -6: {
                    if (object instanceof Short) break;
                    object = (short)new Short(object.toString());
                    break;
                }
                case -3: {
                    break;
                }
                case 12: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbExternalVariable.RowVal execSelect(DbExternalVariable dbExternalVariable, ExternalVariableModule.Locator locator) throws SQLException, ExternalVariableModuleException {
        DbExternalVariable.RowVal rowVal;
        block17: {
            DbExternalVariable.RowKey rowKey = dbExternalVariable.keyFromLocator(locator);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("execSelect: " + rowKey));
            }
            if (rowKey.missingDatabaseGeneratedValues()) {
                return null;
            }
            if (rowKey.missingValues()) {
                throw new IncompleteKeyException(rowKey.getMissing());
            }
            rowVal = dbExternalVariable.new DbExternalVariable.RowVal();
            Connection connection = dbExternalVariable.dataSource.getConnection();
            Statement statement = null;
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Prepare statement: " + dbExternalVariable.select));
                }
                statement = connection.prepareStatement(dbExternalVariable.select);
                int n = 1;
                for (Object object : rowKey) {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("Set key parameter " + n + ": " + object));
                    }
                    statement.setObject(n++, object);
                }
                ResultSet resultSet = statement.executeQuery();
                try {
                    Object object;
                    if (resultSet.next()) {
                        for (DbExternalVariable.Column column : dbExternalVariable._columns) {
                            int n2 = column.idx + 1;
                            Object object2 = column.isDate() ? resultSet.getDate(n2) : (column.isTimeStamp() ? resultSet.getTimestamp(n2) : (column.isTime() ? resultSet.getTime(n2) : (column.isInteger() ? new Long(resultSet.getLong(n2)) : (column.isReal() ? new Double(resultSet.getDouble(n2)) : (column.isBoolean() ? new Boolean(resultSet.getBoolean(n2)) : resultSet.getObject(n2))))));
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("Result column index " + column.idx + ": " + object2));
                            }
                            rowVal.set(column.idx, object2);
                        }
                        break block17;
                    }
                    object = null;
                    return object;
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                connection.close();
            }
        }
        return rowVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbExternalVariable.RowKey execInsert(DbExternalVariable dbExternalVariable, ExternalVariableModule.Locator locator, DbExternalVariable.RowKey rowKey, DbExternalVariable.RowVal rowVal) throws SQLException {
        Connection connection = dbExternalVariable.dataSource.getConnection();
        Statement statement = null;
        try {
            Object object;
            Object object22;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("execInsert: keys=" + rowKey + " values=" + rowVal));
                __log.debug((Object)("Prepare statement: " + dbExternalVariable.insert));
                __log.debug((Object)("missingDatabaseGeneratedValues: " + rowKey.missingDatabaseGeneratedValues()));
                __log.debug((Object)("_autoColNames: " + ObjectPrinter.stringifyNvList((Object[])dbExternalVariable._autoColNames)));
            }
            statement = rowKey.missingDatabaseGeneratedValues() ? connection.prepareStatement(dbExternalVariable.insert, dbExternalVariable._autoColNames) : connection.prepareStatement(dbExternalVariable.insert);
            int n = 1;
            for (DbExternalVariable.Column object3 : dbExternalVariable._inscolumns) {
                object22 = object3.getValue(object3.name, rowKey, rowVal, locator.iid);
                rowVal.put(object3.name, object22);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Set parameter " + n + ": " + object22));
                }
                if (object22 == null) {
                    statement.setNull(n, object3.dataType);
                } else {
                    statement.setObject(n, object22);
                }
                ++n;
            }
            statement.execute();
            for (DbExternalVariable.Column column : rowKey._columns) {
                object22 = rowVal.get(column.name);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Key " + column.name + ": " + object22));
                }
                rowKey.put(column.name, object22);
            }
            if (rowKey.missingDatabaseGeneratedValues()) {
                object = statement.getGeneratedKeys();
                try {
                    if (object == null) {
                        throw new SQLException("Database did not return generated keys");
                    }
                    object.next();
                    for (Object object22 : rowKey._columns) {
                        Object object3 = object.getObject(((DbExternalVariable.Column)object22).idx + 1);
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)("Generated key " + ((DbExternalVariable.Column)object22).name + ": " + object3));
                        }
                        rowKey.put(((DbExternalVariable.Column)object22).name, object3);
                    }
                }
                finally {
                    object.close();
                }
            }
            object = rowKey;
            return object;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            connection.close();
        }
    }
}

