/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.extvar.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.extvar.jdbc.EVarId;
import org.apache.ode.bpel.extvar.jdbc.GenType;
import org.apache.ode.bpel.extvar.jdbc.InitType;
import org.apache.ode.bpel.extvar.jdbc.RowSubset;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.ISO8601DateParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbExternalVariable {
    private static final Log __log = LogFactory.getLog(DbExternalVariable.class);
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    EVarId evarId;
    DataSource dataSource;
    final ArrayList<Column> _columns = new ArrayList();
    private final HashMap<String, Column> _colmap = new HashMap();
    final ArrayList<Column> _keycolumns = new ArrayList();
    final ArrayList<Column> _inscolumns = new ArrayList();
    final ArrayList<Column> _updcolumns = new ArrayList();
    InitType _initType = InitType.update_insert;
    public String[] _autoColNames;
    String select;
    String insert;
    String update;
    String table;
    String schema;
    boolean generatedKeys;

    DbExternalVariable(EVarId eVarId, DataSource dataSource) {
        this.evarId = eVarId;
        this.dataSource = dataSource;
    }

    Column getColumn(String string) {
        return this._colmap.get(string);
    }

    void addColumn(Column column) {
        column.idx = this._columns.size();
        this._colmap.put(column.name, column);
        this._columns.add(column);
        if (column.key) {
            this._keycolumns.add(column);
            this._autoColNames = new String[this._keycolumns.size()];
            for (int i = 0; i < this._autoColNames.length; ++i) {
                this._autoColNames[i] = this._keycolumns.get((int)i).colname;
            }
        }
        this.createSelect();
        this.createInsert();
        this.createUpdate();
    }

    public int numColumns() {
        return this._columns.size();
    }

    RowKey keyFromLocator(ExternalVariableModule.Locator locator) throws ExternalVariableModuleException {
        RowKey rowKey = new RowKey();
        this.parseXmlRow(rowKey, locator.reference);
        for (Column column : rowKey._columns) {
            switch (column.genType) {
                case iid: 
                case pid: {
                    rowKey.put(column.name, column.getValue(column.name, null, null, locator.iid));
                }
            }
        }
        return rowKey;
    }

    private void createSelect() {
        StringBuilder stringBuilder = new StringBuilder("select ");
        boolean bl = true;
        for (Column column : this._columns) {
            if (!bl) {
                stringBuilder.append(',');
            }
            bl = false;
            stringBuilder.append(column.colname);
        }
        stringBuilder.append(" from " + this.table);
        if (this._keycolumns.size() > 0) {
            stringBuilder.append(" where ");
            bl = true;
            for (Column column : this._keycolumns) {
                if (!bl) {
                    stringBuilder.append(" and ");
                }
                bl = false;
                stringBuilder.append(column.colname);
                stringBuilder.append(" = ?");
            }
            this.select = stringBuilder.toString();
        } else {
            this.select = null;
        }
    }

    private void createUpdate() {
        this._updcolumns.clear();
        StringBuilder stringBuilder = new StringBuilder("update ");
        stringBuilder.append(this.table);
        stringBuilder.append(" set ");
        boolean bl = true;
        for (Column column : this._columns) {
            if (column.genType == GenType.sequence || column.key || column.genType == GenType.ctimestamp) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(column.colname);
            stringBuilder.append(" = ");
            if (column.genType == GenType.expression) {
                stringBuilder.append(column.expression);
                continue;
            }
            stringBuilder.append(" ?");
            this._updcolumns.add(column);
        }
        if (this._keycolumns.size() > 0) {
            stringBuilder.append(" where ");
            bl = true;
            for (Column column : this._keycolumns) {
                if (!bl) {
                    stringBuilder.append(" and ");
                }
                bl = false;
                stringBuilder.append(column.colname);
                stringBuilder.append(" = ?");
            }
        }
        this.update = this._keycolumns.size() == 0 ? null : stringBuilder.toString();
    }

    private void createInsert() {
        this._inscolumns.clear();
        StringBuilder stringBuilder = new StringBuilder("insert into ");
        stringBuilder.append(this.table);
        stringBuilder.append(" ( ");
        boolean bl = true;
        for (Column column : this._columns) {
            if (column.genType == GenType.sequence) continue;
            if (!bl) {
                stringBuilder.append(',');
            }
            bl = false;
            stringBuilder.append(column.colname);
        }
        stringBuilder.append(" ) ");
        stringBuilder.append(" values ( ");
        bl = true;
        for (Column column : this._columns) {
            if (column.genType == GenType.sequence) continue;
            if (!bl) {
                stringBuilder.append(',');
            }
            bl = false;
            if (column.genType == GenType.expression) {
                stringBuilder.append(column.expression);
                continue;
            }
            stringBuilder.append(" ? ");
            this._inscolumns.add(column);
        }
        stringBuilder.append(" ) ");
        this.insert = stringBuilder.toString();
    }

    <T extends RowSubset> Element renderXmlRow(ExternalVariableModule.Locator locator, QName qName, T t) throws ExternalVariableModuleException {
        Document document = DOMUtils.newDocument();
        Element element = document.createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
        document.appendChild(element);
        if (t != null) {
            for (Column column : t._columns) {
                Object e = t.get(column.idx);
                this.addElement(element, qName, column, e);
            }
        } else {
            RowKey rowKey = this.keyFromLocator(locator);
            for (Column column : this._columns) {
                Object object = column.getValue(column.name, rowKey, new RowVal(), locator.iid);
                this.addElement(element, qName, column, object);
            }
        }
        return element;
    }

    private void addElement(Element element, QName qName, Column column, Object object) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(qName.getNamespaceURI(), column.name);
        String string = column.toText(object);
        if (string != null) {
            element2.appendChild(document.createTextNode(string));
        } else if (column.nullok || column.isGenerated()) {
            element2.setAttributeNS(XSI_NS, "xsi:nil", "true");
        }
        element.appendChild(element2);
    }

    <T extends RowSubset> T parseXmlRow(T t, Node node) throws ExternalVariableModuleException {
        if (node == null) {
            return t;
        }
        NodeList nodeList = node.getChildNodes();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("parseXmlRow: element=" + node.getLocalName()));
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Column column;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getLocalName();
            String string2 = node2.getTextContent();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Extvar key: " + string + " value: " + string2));
            }
            if ((column = t.getColumn(string)) == null) {
                if (!__log.isDebugEnabled()) continue;
                __log.debug((Object)("No matching column for key '" + string + "'"));
                continue;
            }
            String string3 = ((Element)node2).getAttributeNS(XSI_NS, "nil");
            if (string3 != null && "true".equalsIgnoreCase(string3) && (string2 == null || string2.trim().length() == 0)) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Extvar key: " + string + " is null (xsi:nil)"));
                }
                t.put(string, null);
                continue;
            }
            t.put(string, column.fromText(string2));
        }
        return t;
    }

    class RowVal
    extends RowSubset {
        private static final long serialVersionUID = 1L;

        RowVal() {
            super((List<Column>)DbExternalVariable.this._columns);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RowKey
    extends RowSubset {
        private static final long serialVersionUID = 1L;

        RowKey() {
            super((List<Column>)DbExternalVariable.this._keycolumns);
        }

        void write(QName qName, ExternalVariableModule.Locator locator) throws ExternalVariableModuleException {
            locator.reference = DbExternalVariable.this.renderXmlRow(locator, qName, this);
        }

        public Set<String> getMissing() {
            HashSet<String> hashSet = new HashSet<String>();
            for (Column column : DbExternalVariable.this._keycolumns) {
                if (this.get(column.idx) != null) continue;
                hashSet.add(column.name);
            }
            return hashSet;
        }
    }

    class Column {
        int idx;
        final String name;
        final String colname;
        final boolean key;
        final GenType genType;
        final String expression;
        int dataType;
        boolean nullok;

        Column(String string, String string2, boolean bl, GenType genType, String string3) {
            this.name = string;
            this.colname = string2 == null ? string : string2;
            this.key = bl;
            this.genType = genType;
            this.expression = string3;
        }

        public Object getValue(String string, RowKey rowKey, RowVal rowVal, Long l) {
            switch (this.genType) {
                case ctimestamp: 
                case utimestamp: {
                    return this.isTimeStamp() ? new Timestamp(new java.util.Date().getTime()) : new java.util.Date();
                }
                case uuid: {
                    return new GUID().toString();
                }
                case pid: {
                    return DbExternalVariable.this.evarId.pid.toString();
                }
                case iid: {
                    return l;
                }
            }
            if (this.key && rowKey.get(string) != null) {
                return rowKey.get(string);
            }
            return rowVal.get(string);
        }

        boolean supportsEmptyValue() {
            return this.dataType == 12 || this.dataType == -1 || this.dataType == 2005;
        }

        boolean isDate() {
            return this.dataType == 91;
        }

        boolean isTimeStamp() {
            return this.dataType == 93;
        }

        boolean isTime() {
            return this.dataType == 92;
        }

        boolean isInteger() {
            switch (this.dataType) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    return true;
                }
            }
            return false;
        }

        boolean isReal() {
            switch (this.dataType) {
                case 2: 
                case 3: 
                case 7: {
                    return true;
                }
            }
            return false;
        }

        boolean isBoolean() {
            switch (this.dataType) {
                case -7: {
                    return true;
                }
            }
            return false;
        }

        String toText(Object object) {
            if (object == null) {
                return null;
            }
            java.util.Date date = null;
            if (object instanceof java.util.Date) {
                date = (java.util.Date)object;
                return ISO8601DateParser.format((java.util.Date)((java.util.Date)object));
            }
            return object.toString();
        }

        Object fromText(String string) throws ExternalVariableModuleException {
            try {
                if (string == null) {
                    return null;
                }
                if (!this.supportsEmptyValue() && string.trim().length() == 0) {
                    return null;
                }
                if (this.isDate()) {
                    return new Date(ISO8601DateParser.parse((String)string).getTime());
                }
                if (this.isTime()) {
                    return new Time(ISO8601DateParser.parse((String)string).getTime());
                }
                if (this.isTimeStamp()) {
                    return new Timestamp(ISO8601DateParser.parse((String)string).getTime());
                }
                if (this.isInteger()) {
                    String string2 = string.trim().toLowerCase();
                    if (string2.equals("true")) {
                        return 1;
                    }
                    if (string2.equals("false")) {
                        return 0;
                    }
                    return new BigDecimal(string).longValue();
                }
                if (this.isReal()) {
                    return Double.valueOf(string);
                }
                if (this.isBoolean()) {
                    String string3 = string.trim();
                    if (string3.equals("1")) {
                        return true;
                    }
                    if (string3.equals("0")) {
                        return false;
                    }
                    return Boolean.valueOf(string);
                }
                return string;
            }
            catch (Exception exception) {
                throw new ExternalVariableModuleException("Unable to convert value \"" + string + "\" for column \"" + this.name + "\" !", (Throwable)exception);
            }
        }

        public boolean isGenerated() {
            return this.genType != null && !this.genType.equals((Object)GenType.none);
        }

        public boolean isDatabaseGenerated() {
            return this.isGenerated() && (this.genType.equals((Object)GenType.sequence) || this.genType.equals((Object)GenType.expression));
        }

        public String toString() {
            return "Column {idx=" + this.idx + ",name=" + this.name + ",colname=" + this.colname + ",key=" + this.key + ",genType=" + (Object)((Object)this.genType) + ")";
        }
    }
}

