/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.migration;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.migration.CorrelationKeyMigration;
import org.apache.ode.bpel.engine.migration.CorrelationKeySetDataMigration;
import org.apache.ode.bpel.engine.migration.CorrelationKeySetMigration;
import org.apache.ode.bpel.engine.migration.CorrelatorsMigration;
import org.apache.ode.bpel.engine.migration.Migration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationHandler {
    private static final Log __log = LogFactory.getLog(MigrationHandler.class);
    public static final int CURRENT_SCHEMA_VERSION = 5;
    private Contexts _contexts;
    private List<MigrationLink> migrationLinks = new ArrayList<MigrationLink>(){
        {
            this.add(new MigrationLink(1, 2, new Migration[]{new CorrelatorsMigration(), new CorrelationKeyMigration()}));
            this.add(new MigrationLink(2, 3, new Migration[]{new CorrelationKeySetMigration()}));
            this.add(new MigrationLink(4, 3, new Migration[]{new CorrelationKeySetMigration()}));
            this.add(new MigrationLink(3, 5, new Migration[]{new CorrelationKeySetDataMigration()}));
        }
    };

    public MigrationHandler(Contexts contexts) {
        this._contexts = contexts;
    }

    public boolean migrate(final Set<BpelProcess> set) {
        int n;
        if (this._contexts.dao.getDataSource() == null) {
            __log.debug((Object)"No datasource available, stopping migration. Probably running fully in-memory.");
            return false;
        }
        try {
            n = this.getDbVersion();
        }
        catch (Throwable throwable) {
            __log.info((Object)"The ODE_SCHEMA_VERSION database table doesn't exist. Unless you need to migrate your datafrom a past version, this message can be safely ignored.");
            return false;
        }
        if (n == -1) {
            __log.info((Object)"No schema version available from the database, migrations will be skipped.");
            return false;
        }
        if (n == 5) {
            return true;
        }
        try {
            boolean bl = (Boolean)this._contexts.scheduler.execTransaction((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ArrayList arrayList = new ArrayList();
                    MigrationHandler.this.findMigrations(n, 5, arrayList);
                    if (arrayList.size() == 0) {
                        __log.error((Object)("Don't know how to migrate from " + n + " to " + 5 + ", aborting"));
                        return false;
                    }
                    boolean bl = true;
                    for (Migration migration : arrayList) {
                        __log.debug((Object)("Running migration " + migration));
                        bl = migration.migrate(set, ((MigrationHandler)MigrationHandler.this)._contexts.dao.getConnection()) && bl;
                    }
                    if (!bl) {
                        ((MigrationHandler)MigrationHandler.this)._contexts.scheduler.setRollbackOnly();
                    } else {
                        MigrationHandler.this.setDbVersion(5);
                    }
                    return bl;
                }
            });
            return bl;
        }
        catch (Exception exception) {
            __log.error((Object)"An error occured while migrating your database to a newer version of ODE, changes have been aborted", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    private boolean findMigrations(int n, int n2, List<Migration> list) {
        List<MigrationLink> list2 = this.findLinksTo(n2);
        for (MigrationLink migrationLink : list2) {
            if (migrationLink.source != n && !this.findMigrations(n, migrationLink.source, list)) continue;
            list.addAll(Arrays.asList(migrationLink.migrations));
            return true;
        }
        return false;
    }

    private List<MigrationLink> findLinksTo(int n) {
        ArrayList<MigrationLink> arrayList = new ArrayList<MigrationLink>();
        for (MigrationLink migrationLink : this.migrationLinks) {
            if (migrationLink.target != n) continue;
            arrayList.add(migrationLink);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDbVersion() {
        int n = -1;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this._contexts.dao.getDataSource().getConnection();
            statement = connection.prepareStatement("SELECT VERSION FROM ODE_SCHEMA_VERSION");
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt("VERSION");
            }
        }
        catch (Exception exception) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDbVersion(int n) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this._contexts.dao.getDataSource().getConnection();
            statement = connection.createStatement();
            int n2 = statement.executeUpdate("UPDATE ODE_SCHEMA_VERSION SET VERSION = " + n);
            if (n2 == 0) {
                throw new RuntimeException("Couldn't update schema version.");
            }
        }
        catch (Exception exception) {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
    }

    private static class MigrationLink {
        int source;
        int target;
        Migration[] migrations;

        public MigrationLink(int n, int n2, Migration[] migrationArray) {
            this.source = n;
            this.target = n2;
            this.migrations = migrationArray;
        }
    }
}

