/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.migration;

import java.util.Set;
import javax.wsdl.Operation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.migration.Migration;
import org.apache.ode.bpel.o.OPartnerLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelatorsMigration
implements Migration {
    private static final Log __log = LogFactory.getLog(CorrelatorsMigration.class);

    @Override
    public boolean migrate(Set<BpelProcess> set, BpelDAOConnection bpelDAOConnection) {
        for (BpelProcess bpelProcess : set) {
            __log.debug((Object)("Migrating correlators for process " + bpelProcess.getConf().getProcessId()));
            ProcessDAO processDAO = bpelDAOConnection.getProcess(bpelProcess.getConf().getProcessId());
            for (OPartnerLink oPartnerLink : bpelProcess.getOProcess().getAllPartnerLinks()) {
                if (!oPartnerLink.hasMyRole()) continue;
                for (Operation operation : oPartnerLink.myRolePortType.getOperations()) {
                    try {
                        CorrelatorDAO correlatorDAO = processDAO.getCorrelator(oPartnerLink.getId() + "." + operation.getName());
                        correlatorDAO.setCorrelatorId(oPartnerLink.getName() + "." + operation.getName());
                        __log.debug((Object)("Migrated correlator " + oPartnerLink.getName() + "." + operation.getName()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        __log.debug((Object)("Correlator with id " + oPartnerLink.getId() + "." + operation.getName() + " couldn't be found, skipping."));
                    }
                }
            }
        }
        return true;
    }
}

