/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.migration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.OutstandingRequestManager;
import org.apache.ode.bpel.engine.ReplacementMapImpl;
import org.apache.ode.bpel.engine.migration.Migration;
import org.apache.ode.bpel.engine.migration.OldCorrelationKey;
import org.apache.ode.bpel.engine.migration.OldSelector;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.runtime.Selector;
import org.apache.ode.jacob.soup.ReplacementMap;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationKeySetMigration
implements Migration {
    private static final Log __log = LogFactory.getLog(CorrelationKeySetMigration.class);

    @Override
    public boolean migrate(Set<BpelProcess> set, BpelDAOConnection bpelDAOConnection) {
        boolean bl = true;
        for (BpelProcess bpelProcess : set) {
            ProcessDAO processDAO = bpelDAOConnection.getProcess(bpelProcess.getConf().getProcessId());
            Collection collection = processDAO.getActiveInstances();
            for (ProcessInstanceDAO processInstanceDAO : collection) {
                __log.debug((Object)("Migrating correlation key in jacob for instance " + processInstanceDAO.getInstanceId()));
                OProcess oProcess = this.findOProcess(set, processInstanceDAO.getProcess().getProcessId());
                if (bl) {
                    if (this.updateV1Key(processInstanceDAO, oProcess)) continue;
                    bl = false;
                    this.updateV2Key(processInstanceDAO, oProcess);
                    continue;
                }
                if (this.updateV2Key(processInstanceDAO, oProcess)) continue;
                bl = true;
                this.updateV1Key(processInstanceDAO, oProcess);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateV1Key(ProcessInstanceDAO processInstanceDAO, OProcess oProcess) {
        ExecutionQueueImpl executionQueueImpl;
        try {
            executionQueueImpl = this.readOldState(processInstanceDAO, oProcess, this.getClass().getClassLoader(), true);
            if (executionQueueImpl == null) {
                return false;
            }
        }
        catch (Exception exception) {
            __log.debug((Object)("  failed to read a v1 state for instance " + processInstanceDAO.getInstanceId()));
            ExecutionQueueImpl._classDescriptors.clear();
            return false;
        }
        try {
            OutstandingRequestManager outstandingRequestManager = (OutstandingRequestManager)executionQueueImpl.getGlobalData();
            for (OutstandingRequestManager.Entry entry : outstandingRequestManager._byChannel.values()) {
                Selector[] selectorArray = new Selector[entry.selectors.length];
                int n = 0;
                for (Object object : entry.selectors) {
                    OldSelector oldSelector = (OldSelector)object;
                    Object object2 = oldSelector.correlationKey;
                    if (object2 == null) continue;
                    OldCorrelationKey oldCorrelationKey = (OldCorrelationKey)object2;
                    __log.debug((Object)("   Changing V1 key " + oldCorrelationKey.toCanonicalString()));
                    CorrelationKeySet correlationKeySet = new CorrelationKeySet();
                    correlationKeySet.add(new CorrelationKey("" + oldCorrelationKey.getCSetId(), oldCorrelationKey.getValues()));
                    Selector selector = new Selector(oldSelector.idx, oldSelector.plinkInstance, oldSelector.opName, oldSelector.oneWay, oldSelector.messageExchangeId, correlationKeySet, "one");
                    selector.correlationKey = new CorrelationKey("" + oldCorrelationKey.getCSetId(), oldCorrelationKey.getValues());
                    selectorArray[n++] = selector;
                }
                entry.selectors = selectorArray;
            }
            this.writeOldState(processInstanceDAO, executionQueueImpl);
        }
        finally {
            ExecutionQueueImpl._classDescriptors.clear();
        }
        return true;
    }

    private boolean updateV2Key(ProcessInstanceDAO processInstanceDAO, OProcess oProcess) {
        ExecutionQueueImpl executionQueueImpl;
        try {
            executionQueueImpl = this.readOldState(processInstanceDAO, oProcess, this.getClass().getClassLoader(), false);
            if (executionQueueImpl == null) {
                return false;
            }
        }
        catch (Exception exception) {
            __log.debug((Object)("  failed to read a v2 state for instance " + processInstanceDAO.getInstanceId()));
            ExecutionQueueImpl._classDescriptors.clear();
            return false;
        }
        OutstandingRequestManager outstandingRequestManager = (OutstandingRequestManager)executionQueueImpl.getGlobalData();
        for (OutstandingRequestManager.Entry entry : outstandingRequestManager._byChannel.values()) {
            Selector[] selectorArray = new Selector[entry.selectors.length];
            int n = 0;
            for (Object object : entry.selectors) {
                OldSelector oldSelector = (OldSelector)object;
                CorrelationKey correlationKey = (CorrelationKey)oldSelector.correlationKey;
                if (correlationKey == null) continue;
                __log.debug((Object)("   Changing V2 key " + correlationKey.toCanonicalString()));
                CorrelationKeySet correlationKeySet = new CorrelationKeySet();
                correlationKeySet.add(new CorrelationKey("" + correlationKey.getCorrelationSetName(), correlationKey.getValues()));
                Selector selector = new Selector(oldSelector.idx, oldSelector.plinkInstance, oldSelector.opName, oldSelector.oneWay, oldSelector.messageExchangeId, correlationKeySet, "one");
                selector.correlationKey = new CorrelationKey("" + correlationKey.getCorrelationSetName(), correlationKey.getValues());
                selectorArray[n++] = selector;
            }
            entry.selectors = selectorArray;
        }
        this.writeOldState(processInstanceDAO, executionQueueImpl);
        return true;
    }

    private ExecutionQueueImpl readOldState(ProcessInstanceDAO processInstanceDAO, OProcess oProcess, ClassLoader classLoader, boolean bl) {
        if (processInstanceDAO.getExecutionState() == null) {
            return null;
        }
        try {
            ObjectStreamClass objectStreamClass;
            ExecutionQueueImpl executionQueueImpl = new ExecutionQueueImpl(classLoader);
            if (bl) {
                objectStreamClass = ObjectStreamClass.lookup(Class.forName("org.apache.ode.bpel.engine.migration.OldCorrelationKey", true, classLoader));
                ExecutionQueueImpl._classDescriptors.put("org.apache.ode.bpel.common.CorrelationKey", objectStreamClass);
            }
            objectStreamClass = ObjectStreamClass.lookup(Class.forName("org.apache.ode.bpel.engine.migration.OldSelector", true, classLoader));
            ExecutionQueueImpl._classDescriptors.put("org.apache.ode.bpel.runtime.Selector", objectStreamClass);
            objectStreamClass = ObjectStreamClass.lookup(Class.forName("[Lorg.apache.ode.bpel.engine.migration.OldSelector;", true, this.getClass().getClassLoader()));
            ExecutionQueueImpl._classDescriptors.put("[Lorg.apache.ode.bpel.runtime.Selector;", objectStreamClass);
            executionQueueImpl.setReplacementMap((ReplacementMap)new ReplacementMapImpl(oProcess));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(processInstanceDAO.getExecutionState());
            executionQueueImpl.read((InputStream)byteArrayInputStream);
            return executionQueueImpl;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void writeOldState(ProcessInstanceDAO processInstanceDAO, ExecutionQueueImpl executionQueueImpl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            executionQueueImpl.write((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            processInstanceDAO.setExecutionState(byteArrayOutputStream.toByteArray());
            ExecutionQueueImpl._classDescriptors.clear();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private OProcess findOProcess(Set<BpelProcess> set, QName qName) {
        for (BpelProcess bpelProcess : set) {
            if (!bpelProcess.getConf().getProcessId().equals(qName)) continue;
            return bpelProcess.getOProcess();
        }
        return null;
    }
}

