/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.migration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.migration.Migration;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationKeyMigration
implements Migration {
    private static final Log __log = LogFactory.getLog(CorrelationKeyMigration.class);

    @Override
    public boolean migrate(Set<BpelProcess> set, BpelDAOConnection bpelDAOConnection) {
        CorrelationKey correlationKey;
        HashMap<Long, ProcessInstanceDAO> hashMap = new HashMap<Long, ProcessInstanceDAO>();
        Collection collection = bpelDAOConnection.getActiveCorrelationSets();
        for (CorrelationSetDAO object : collection) {
            correlationKey = object.getValue();
            hashMap.put(object.getInstance().getInstanceId(), object.getInstance());
            if (correlationKey == null) continue;
            __log.debug((Object)("Correlation set id " + object.getCorrelationSetId() + " key " + correlationKey));
            Integer n = this.asInt(correlationKey.getCorrelationSetName());
            if (n == null) continue;
            OPartnerLink oPartnerLink = this.findCorrelationById(n, set, object.getProcess().getProcessId());
            if (oPartnerLink == null) {
                __log.debug((Object)("Correlation set not found, couldn't upgrade set " + correlationKey.toCanonicalString()));
                continue;
            }
            object.setValue(null, new CorrelationKey(oPartnerLink.name, correlationKey.getValues()));
        }
        for (BpelProcess bpelProcess : set) {
            __log.debug((Object)("Migrating correlators for process " + bpelProcess.getConf().getProcessId()));
            correlationKey = bpelDAOConnection.getProcess(bpelProcess.getConf().getProcessId());
            for (OPartnerLink oPartnerLink : bpelProcess.getOProcess().getAllPartnerLinks()) {
                if (!oPartnerLink.hasMyRole()) continue;
                for (Operation operation : oPartnerLink.myRolePortType.getOperations()) {
                    try {
                        OScope.CorrelationSet correlationSet;
                        Integer n;
                        CorrelationKey correlationKey2;
                        CorrelatorDAO correlatorDAO = correlationKey.getCorrelator(oPartnerLink.getName() + "." + operation.getName());
                        if (correlatorDAO == null) continue;
                        for (MessageRouteDAO messageRouteDAO : correlatorDAO.getAllRoutes()) {
                            correlationKey2 = messageRouteDAO.getCorrelationKey();
                            if (correlationKey2 == null || (n = this.asInt(correlationKey2.getCorrelationSetName())) == null) continue;
                            correlationSet = this.findCorrelationById(n, set, bpelProcess.getConf().getProcessId());
                            if (correlationSet == null) {
                                __log.debug((Object)("Correlation set not found, couldn't upgrade route " + correlationKey2.toCanonicalString()));
                                continue;
                            }
                            messageRouteDAO.setCorrelationKey(new CorrelationKey(correlationSet.name, correlationKey2.getValues()));
                        }
                        for (MessageRouteDAO messageRouteDAO : correlatorDAO.getAllMessages()) {
                            correlationKey2 = messageRouteDAO.getCorrelationKey();
                            if (correlationKey2 == null || (n = this.asInt(correlationKey2.getCorrelationSetName())) == null) continue;
                            correlationSet = this.findCorrelationById(n, set, bpelProcess.getConf().getProcessId());
                            if (correlationSet == null) {
                                __log.debug((Object)("Correlation set not found, couldn't upgrade route " + correlationKey2.toCanonicalString()));
                                continue;
                            }
                            messageRouteDAO.setCorrelationKey(new CorrelationKey(correlationSet.name, correlationKey2.getValues()));
                        }
                        __log.debug((Object)("Migrated routes and message queue for correlator " + oPartnerLink.getName() + "." + operation.getName()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        __log.debug((Object)("Correlator with id " + oPartnerLink.getId() + "." + operation.getName() + " couldn't be found, skipping."));
                    }
                }
            }
        }
        return true;
    }

    private Integer asInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private OScope.CorrelationSet findCorrelationById(int n, Set<BpelProcess> set, QName qName) {
        for (BpelProcess bpelProcess : set) {
            OBase oBase;
            if (!bpelProcess.getConf().getProcessId().equals(qName) || !((oBase = bpelProcess.getOProcess().getChild(n)) instanceof OScope.CorrelationSet)) continue;
            return (OScope.CorrelationSet)oBase;
        }
        return null;
    }
}

