/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.extvar;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.extvar.ExternalVariableConf;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalVariableManager {
    private static final Log __log = LogFactory.getLog(ExternalVariableManager.class);
    private Map<QName, ExternalVariableModule> _engines;
    private final Map<String, EVar> _externalVariables = new HashMap<String, EVar>();
    private final ExternalVariableConf _extVarConf;
    private QName _pid;

    public ExternalVariableManager(QName qName, ExternalVariableConf externalVariableConf, Map<QName, ExternalVariableModule> map, OProcess oProcess) throws BpelEngineException {
        Object object;
        this._pid = qName;
        this._extVarConf = externalVariableConf;
        this._engines = map;
        boolean bl = false;
        for (ExternalVariableConf.Variable variable : this._extVarConf.getVariables()) {
            object = new EVar(variable.extVariableId, this._engines.get(variable.engineQName), variable.configuration);
            if (object._engine == null) {
                __log.error((Object)("External variable engine \"" + variable.engineQName + "\" referenced by external variable \"" + variable.extVariableId + "\" not registered."));
                bl = true;
                continue;
            }
            try {
                object._engine.configure(this._pid, object._extVarId, object._config);
            }
            catch (ExternalVariableModuleException externalVariableModuleException) {
                __log.error((Object)"External variable subsystem configuration error.", (Throwable)externalVariableModuleException);
                throw new BpelEngineException("External variable subsystem configuration error.", (Throwable)externalVariableModuleException);
            }
            if (this._externalVariables.containsKey(variable.extVariableId)) {
                __log.warn((Object)("Duplicate external variable configuration for \"" + variable.extVariableId + "\" will be ignored!"));
            }
            this._externalVariables.put(variable.extVariableId, (EVar)object);
        }
        for (ExternalVariableConf.Variable variable : oProcess.getChildren()) {
            if (!(variable instanceof OScope)) continue;
            object = (OScope)variable;
            for (OScope.Variable variable2 : object.variables.values()) {
                EVar eVar;
                if (variable2.extVar == null || (eVar = this._externalVariables.get(variable2.extVar.externalVariableId)) != null) continue;
                __log.error((Object)("The \"" + object.name + "\" scope declared an unknown external variable \"" + variable2.extVar.externalVariableId + "\"; check the deployment descriptor."));
                bl = true;
            }
        }
        if (bl) {
            String string = "Error initializing external variables. See log for details.";
            __log.error((Object)string);
            throw new BpelEngineException(string);
        }
    }

    public ExternalVariableModule.Value read(OScope.Variable variable, Node node, Long l) throws ExternalVariableModuleException {
        EVar eVar = this._externalVariables.get(variable.extVar.externalVariableId);
        if (eVar == null) {
            throw new BpelEngineException("InternalError: reference to unknown external variable " + variable.extVar.externalVariableId);
        }
        ExternalVariableModule.Locator locator = new ExternalVariableModule.Locator(variable.extVar.externalVariableId, this._pid, l, node);
        ExternalVariableModule.Value value = eVar._engine.readValue(((OElementVarType)variable.type).elementType, locator);
        if (value == null) {
            return null;
        }
        return value;
    }

    public ExternalVariableModule.Value write(OScope.Variable variable, Node node, Node node2, Long l) throws ExternalVariableModuleException {
        EVar eVar = this._externalVariables.get(variable.extVar.externalVariableId);
        if (eVar == null) {
            throw new BpelEngineException("InternalError: reference to unknown external variable " + variable.extVar.externalVariableId);
        }
        ExternalVariableModule.Locator locator = new ExternalVariableModule.Locator(variable.extVar.externalVariableId, this._pid, l, node);
        ExternalVariableModule.Value value = new ExternalVariableModule.Value(locator, node2, null);
        value = eVar._engine.writeValue(((OElementVarType)variable.type).elementType, value);
        return value;
    }

    static final class EVar {
        final ExternalVariableModule _engine;
        final Element _config;
        final String _extVarId;

        EVar(String string, ExternalVariableModule externalVariableModule, Element element) {
            this._extVarId = string;
            this._engine = externalVariableModule;
            this._config = element;
        }
    }
}

