/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.extvar;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalVariableConf {
    public static final QName EXTVARCONF_ELEMENT = new QName("http://ode.apache.org/externalVariables", "externalVariable");
    private final HashMap<String, Variable> _vars = new HashMap();

    public ExternalVariableConf(List<Element> list) {
        for (Element element : list) {
            String string = element.getAttribute("id");
            if (string == null || "".equals(string)) {
                throw new BpelEngineException("Invalid external variable configuration; id not specified.");
            }
            if (this._vars.containsKey(string)) {
                throw new BpelEngineException("Invalid external variable configuration; duplicate id \"" + string + " \".");
            }
            Element element2 = DOMUtils.getFirstChildElement((Element)element);
            if (element2 == null) {
                throw new BpelEngineException("Invalid external variable configuration for id \"" + string + "\"; no engine configuration!");
            }
            QName qName = new QName(element2.getNamespaceURI(), element2.getLocalName());
            Variable variable = new Variable(string, qName, element2);
            this._vars.put(string, variable);
        }
    }

    public Variable getVariable(String string) {
        return this._vars.get(string);
    }

    public Collection<Variable> getVariables() {
        return this._vars.values();
    }

    public class Variable {
        public final String extVariableId;
        public final QName engineQName;
        public final Element configuration;

        Variable(String string, QName qName, Element element) {
            this.extVariableId = string;
            this.engineQName = qName;
            this.configuration = element;
        }
    }
}

