/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;

public class SharedEndpoints {
    private static Map<Endpoint, EndpointReference> _eprs = new HashMap<Endpoint, EndpointReference>();
    private static List<Endpoint> _referenceCounts = new ArrayList<Endpoint>();

    public SharedEndpoints() {
        this.init();
    }

    public void init() {
        _eprs.clear();
        _referenceCounts.clear();
    }

    public void addEndpoint(Endpoint endpoint, EndpointReference endpointReference) {
        _eprs.put(endpoint, endpointReference);
    }

    public void removeEndpoint(Endpoint endpoint) {
        _eprs.remove(endpoint);
    }

    public EndpointReference getEndpointReference(Endpoint endpoint) {
        return _eprs.get(endpoint);
    }

    public void incrementReferenceCount(Endpoint endpoint) {
        _referenceCounts.add(endpoint);
    }

    public boolean decrementReferenceCount(Endpoint endpoint) {
        return _referenceCounts.remove(endpoint);
    }

    public int getReferenceCount(EndpointReference endpointReference) {
        int n = 0;
        for (Endpoint endpoint : _eprs.keySet()) {
            if (!_eprs.get(endpoint).equals(endpointReference)) continue;
            for (Endpoint endpoint2 : _referenceCounts) {
                if (!endpoint2.equals((Object)endpoint)) continue;
                ++n;
            }
        }
        return n;
    }
}

