/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.ScopeStateEnum;
import org.apache.ode.bpel.pmapi.ProcessingException;
import org.apache.ode.bpel.pmapi.TInstanceStatus;
import org.apache.ode.bpel.pmapi.TScopeStatus;

class ProcessStatusConverter {
    private final Map<TInstanceStatus.Enum, BitSet> __interfaceStatusCodeToInternalStatusCodeMap = new HashMap<TInstanceStatus.Enum, BitSet>();
    private final Map<ScopeStateEnum, TScopeStatus.Enum> __scopeStateMap = new HashMap<ScopeStateEnum, TScopeStatus.Enum>();

    ProcessStatusConverter() {
        for (int i = 0; i < ProcessState.ALL_STATES.length; ++i) {
            short s = ProcessState.ALL_STATES[i];
            TInstanceStatus.Enum enum_ = this.cvtInstanceStatus(s);
            BitSet bitSet = this.__interfaceStatusCodeToInternalStatusCodeMap.get(enum_);
            if (bitSet == null) {
                bitSet = new BitSet();
                this.__interfaceStatusCodeToInternalStatusCodeMap.put(enum_, bitSet);
            }
            bitSet.set(s);
        }
        this.__scopeStateMap.put(ScopeStateEnum.ACTIVE, TScopeStatus.ACTIVE);
        this.__scopeStateMap.put(ScopeStateEnum.COMPENSATED, TScopeStatus.COMPENSATED);
        this.__scopeStateMap.put(ScopeStateEnum.COMPENSATING, TScopeStatus.COMPENSATING);
        this.__scopeStateMap.put(ScopeStateEnum.COMPLETED, TScopeStatus.COMPLETED);
        this.__scopeStateMap.put(ScopeStateEnum.FAULTED, TScopeStatus.FAULTED);
        this.__scopeStateMap.put(ScopeStateEnum.FAULTHANDLER, TScopeStatus.FAULTED);
    }

    TInstanceStatus.Enum cvtInstanceStatus(short s) {
        switch (s) {
            case 0: 
            case 10: 
            case 20: {
                return TInstanceStatus.ACTIVE;
            }
            case 30: {
                return TInstanceStatus.COMPLETED;
            }
            case 40: {
                return TInstanceStatus.FAILED;
            }
            case 50: {
                return TInstanceStatus.SUSPENDED;
            }
            case 60: {
                return TInstanceStatus.TERMINATED;
            }
        }
        throw new ProcessingException("Encountered unexpected instance state: " + s);
    }

    short[] cvtInstanceStatus(TInstanceStatus.Enum enum_) {
        BitSet bitSet = this.__interfaceStatusCodeToInternalStatusCodeMap.get(enum_);
        if (bitSet == null) {
            return new short[0];
        }
        short[] sArray = new short[bitSet.cardinality()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)bitSet.nextSetBit(i == 0 ? 0 : sArray[i - 1] + 1);
        }
        return sArray;
    }

    TScopeStatus.Enum cvtScopeStatus(ScopeStateEnum scopeStateEnum) {
        return this.__scopeStateMap.get(scopeStateEnum);
    }
}

