/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.DeferredProcessInstanceCleanable;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.iapi.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessCleanUpRunnable
implements Scheduler.MapSerializableRunnable,
BpelServerImpl.ContextsAware {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(ProcessCleanUpRunnable.class);
    public static final int PROCESS_CLEANUP_TRANSACTION_SIZE = Integer.getInteger("org.apache.ode.processInstanceDeletion.transactionSize", 10);
    private transient Contexts _contexts;
    private transient Serializable _pid;

    public ProcessCleanUpRunnable() {
    }

    public ProcessCleanUpRunnable(Serializable serializable) {
        this._pid = serializable;
    }

    public void storeToDetailsMap(Map<String, Object> map) {
        map.put("pid", this._pid);
    }

    public void restoreFromDetailsMap(Map<String, Object> map) {
        this._pid = (Serializable)map.get("pid");
    }

    @Override
    public void setContexts(Contexts contexts) {
        this._contexts = contexts;
    }

    public void run() {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Deleting runtime data for old process: " + this._pid + "..."));
        }
        try {
            int n = 0;
            do {
                n = (Integer)this._contexts.scheduler.execTransaction((Callable)new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        ProcessDAO processDAO = ((ProcessCleanUpRunnable)ProcessCleanUpRunnable.this)._contexts.dao.getConnection().createTransientProcess(ProcessCleanUpRunnable.this._pid);
                        if (!(processDAO instanceof DeferredProcessInstanceCleanable)) {
                            throw new IllegalArgumentException("ProcessDAO does not implement DeferredProcessInstanceCleanable!!!");
                        }
                        return ((DeferredProcessInstanceCleanable)processDAO).deleteInstances(PROCESS_CLEANUP_TRANSACTION_SIZE);
                    }
                });
                if (!__log.isDebugEnabled()) continue;
                __log.debug((Object)("Deleted " + n + "instances for old process: " + this._pid + "."));
            } while (n == PROCESS_CLEANUP_TRANSACTION_SIZE);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (__log.isInfoEnabled()) {
            __log.info((Object)("Deleted runtime data for old process: " + this._pid + "."));
        }
    }
}

