/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.MessageExchangeImpl;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PartnerRoleMessageExchangeImpl
extends MessageExchangeImpl
implements PartnerRoleMessageExchange {
    private static final Log LOG = LogFactory.getLog(PartnerRoleMessageExchangeImpl.class);
    private PartnerRoleChannel _channel;
    private EndpointReference _myRoleEPR;
    private int responsesReceived;

    protected PartnerRoleMessageExchangeImpl(BpelEngineImpl bpelEngineImpl, MessageExchangeDAO messageExchangeDAO, PortType portType, Operation operation, EndpointReference endpointReference, EndpointReference endpointReference2, PartnerRoleChannel partnerRoleChannel) {
        super(bpelEngineImpl, messageExchangeDAO);
        this._myRoleEPR = endpointReference2;
        this.setPortOp(portType, operation);
        this._channel = partnerRoleChannel;
    }

    public void replyOneWayOk() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("replyOneWayOk mex=" + this.getMessageExchangeId()));
        }
        this.setStatus(MessageExchange.Status.ASYNC);
    }

    public void replyAsync() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("replyAsync mex=" + this.getMessageExchangeId()));
        }
        this.setStatus(MessageExchange.Status.ASYNC);
    }

    public void replyWithFault(QName qName, Message message) throws BpelEngineException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("replyWithFault mex=" + this.getMessageExchangeId()));
        }
        boolean bl = this.isAsync();
        this.setFault(qName, message);
        if (bl) {
            this.continueAsync();
        }
    }

    public void reply(Message message) throws BpelEngineException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reply mex=" + this.getMessageExchangeId()));
        }
        boolean bl = this.isAsync();
        this.setResponse(message);
        if (bl) {
            this.continueAsync();
        }
    }

    void setResponse(Message message) throws BpelEngineException {
        if (++this.responsesReceived > 1 && this.getSubscriberCount() > 1 && this.getStatus() == MessageExchange.Status.RESPONSE) {
            return;
        }
        super.setResponse(message);
    }

    public void replyWithFailure(MessageExchange.FailureType failureType, String string, Element element) throws BpelEngineException {
        if (LOG.isDebugEnabled()) {
            String string2 = "replyWithFailure mex=" + this.getMessageExchangeId() + " failureType=" + failureType + " description=" + string + " details=" + (element == null ? null : DOMUtils.domToString((Node)element));
            LOG.debug((Object)string2);
        }
        boolean bl = this.isAsync();
        this.setFailure(failureType, string, element);
        if (bl) {
            this.continueAsync();
        }
    }

    private void continueAsync() {
        if (this.getDAO().getChannel() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("no channel on mex=" + this.getMessageExchangeId()));
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("create work event for mex=" + this.getMessageExchangeId()));
        }
        WorkEvent workEvent = new WorkEvent();
        workEvent.setIID(this.getDAO().getInstance().getInstanceId());
        workEvent.setType(WorkEvent.Type.INVOKE_RESPONSE);
        if (this._engine._activeProcesses.get(this.getDAO().getProcess().getProcessId()).isInMemory()) {
            workEvent.setInMem(true);
        }
        workEvent.setChannel(this.getDAO().getChannel());
        workEvent.setMexId(this.getDAO().getMessageExchangeId());
        if (workEvent.isInMem()) {
            this._engine._contexts.scheduler.scheduleVolatileJob(true, workEvent.getDetail());
        } else {
            this._engine._contexts.scheduler.schedulePersistedJob(workEvent.getDetail(), null);
        }
    }

    private boolean isAsync() {
        return this.getStatus() == MessageExchange.Status.ASYNC;
    }

    public QName getCaller() {
        return this._dao.getProcess().getProcessId();
    }

    public String toString() {
        try {
            return "{PartnerRoleMex#" + this.getMessageExchangeId() + " [PID " + this.getCaller() + "] calling " + this._epr + "." + this.getOperationName() + "(...)}";
        }
        catch (Throwable throwable) {
            return "{PartnerRoleMex#????}";
        }
    }

    public PartnerRoleChannel getChannel() {
        return this._channel;
    }

    public EndpointReference getMyRoleEndpointReference() {
        return this._myRoleEPR;
    }
}

