/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.common.InvalidMessageException;
import org.apache.ode.bpel.common.OptionalCorrelationKey;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.BpelRuntimeContextImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.PartnerLinkRoleImpl;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.CorrelationMatchEvent;
import org.apache.ode.bpel.evt.CorrelationNoMatchEvent;
import org.apache.ode.bpel.evt.NewProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.intercept.InterceptorInvoker;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.PROCESS;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartnerLinkMyRoleImpl
extends PartnerLinkRoleImpl {
    private static final Log __log = LogFactory.getLog(BpelProcess.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    public Endpoint _endpoint;

    PartnerLinkMyRoleImpl(BpelProcess bpelProcess, OPartnerLink oPartnerLink, Endpoint endpoint) {
        super(bpelProcess, oPartnerLink);
        this._endpoint = endpoint;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{PartnerLinkRole-");
        stringBuffer.append(this._plinkDef.name);
        stringBuffer.append('.');
        stringBuffer.append(this._plinkDef.myRoleName);
        stringBuffer.append(" on ");
        stringBuffer.append(this._endpoint);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public boolean isCreateInstance(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl) {
        Operation operation = this.getMyRoleOperation(myRoleMessageExchangeImpl.getOperationName());
        return this._plinkDef.isCreateInstanceOperation(operation);
    }

    public List<RoutingInfo> findRoute(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl) {
        List list;
        CorrelationKeySet correlationKeySet;
        Operation operation;
        ArrayList<RoutingInfo> arrayList = new ArrayList<RoutingInfo>();
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)(this + ":inputMsgRcvd"), (Object[])new Object[]{"messageExchange", myRoleMessageExchangeImpl}));
        }
        if ((operation = this.getMyRoleOperation(myRoleMessageExchangeImpl.getOperationName())) == null) {
            __log.error((Object)__msgs.msgUnknownOperation(myRoleMessageExchangeImpl.getOperationName(), this._plinkDef.myRolePortType.getQName()));
            myRoleMessageExchangeImpl.setFailure(MessageExchange.FailureType.UNKNOWN_OPERATION, myRoleMessageExchangeImpl.getOperationName(), null);
            return null;
        }
        this.setMexRole(myRoleMessageExchangeImpl);
        String string = BpelProcess.genCorrelatorId(this._plinkDef, operation.getName());
        CorrelatorDAO correlatorDAO = this._process.getProcessDAO().getCorrelator(string);
        try {
            correlationKeySet = this.computeCorrelationKeys(myRoleMessageExchangeImpl);
        }
        catch (InvalidMessageException invalidMessageException) {
            __log.debug((Object)"Unable to evaluate correlation keys, invalid message format. ", (Throwable)invalidMessageException);
            myRoleMessageExchangeImpl.setFailure(MessageExchange.FailureType.FORMAT_ERROR, invalidMessageException.getMessage(), null);
            return null;
        }
        String string2 = myRoleMessageExchangeImpl.getProperty("org.apache.ode.bpel.myRoleSessionId");
        String string3 = myRoleMessageExchangeImpl.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INPUTMSG: " + string + ": MSG RCVD keys=" + correlationKeySet + " mySessionId=" + string2 + " partnerSessionId=" + string3));
        }
        if ((list = correlatorDAO.findRoute(correlationKeySet)) != null && list.size() > 0) {
            for (MessageRouteDAO messageRouteDAO : list) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("INPUTMSG: " + string + ": ckeySet " + messageRouteDAO.getCorrelationKeySet() + " route is to " + messageRouteDAO));
                }
                arrayList.add(new RoutingInfo(messageRouteDAO, messageRouteDAO.getCorrelationKeySet(), correlatorDAO, correlationKeySet));
            }
        }
        if (arrayList.size() == 0) {
            arrayList.add(new RoutingInfo(null, null, correlatorDAO, correlationKeySet));
        }
        return arrayList;
    }

    public void invokeNewInstance(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl, RoutingInfo routingInfo) {
        Operation operation = this.getMyRoleOperation(myRoleMessageExchangeImpl.getOperationName());
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INPUTMSG: " + routingInfo.correlator.getCorrelatorId() + ": routing failed, CREATING NEW INSTANCE"));
        }
        ProcessDAO processDAO = this._process.getProcessDAO();
        if (this._process._pconf.getState() == ProcessState.RETIRED) {
            throw new InvalidProcessException("Process is retired.", 1);
        }
        if (!this._process.processInterceptors(myRoleMessageExchangeImpl, InterceptorInvoker.__onNewInstanceInvoked)) {
            __log.debug((Object)("Not creating a new instance for mex " + myRoleMessageExchangeImpl + "; interceptor prevented!"));
            throw new InvalidProcessException("Cannot instantiate process '" + this._process.getPID() + "' any more.", 2);
        }
        ProcessInstanceDAO processInstanceDAO = processDAO.createInstance(routingInfo.correlator);
        BpelRuntimeContextImpl bpelRuntimeContextImpl = this._process.createRuntimeContext(processInstanceDAO, new PROCESS(this._process.getOProcess()), myRoleMessageExchangeImpl);
        NewProcessInstanceEvent newProcessInstanceEvent = new NewProcessInstanceEvent(new QName(this._process.getOProcess().targetNamespace, this._process.getOProcess().getName()), this._process.getProcessDAO().getProcessId(), processInstanceDAO.getInstanceId());
        newProcessInstanceEvent.setPortType(myRoleMessageExchangeImpl.getPortType().getQName());
        newProcessInstanceEvent.setOperation(operation.getName());
        newProcessInstanceEvent.setMexId(myRoleMessageExchangeImpl.getMessageExchangeId());
        this._process._debugger.onEvent((BpelEvent)newProcessInstanceEvent);
        this._process.saveEvent((ProcessInstanceEvent)newProcessInstanceEvent, processInstanceDAO);
        myRoleMessageExchangeImpl.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.CREATE_INSTANCE);
        myRoleMessageExchangeImpl.getDAO().setInstance(processInstanceDAO);
        bpelRuntimeContextImpl.execute();
    }

    public void invokeInstance(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl, RoutingInfo routingInfo) {
        Operation operation = this.getMyRoleOperation(myRoleMessageExchangeImpl.getOperationName());
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INPUTMSG: " + routingInfo.correlator.getCorrelatorId() + ": ROUTING to instance " + routingInfo.messageRoute.getTargetInstance().getInstanceId()));
        }
        ProcessInstanceDAO processInstanceDAO = routingInfo.messageRoute.getTargetInstance();
        BpelRuntimeContextImpl bpelRuntimeContextImpl = this._process.createRuntimeContext(processInstanceDAO, null, null);
        bpelRuntimeContextImpl.inputMsgMatch(routingInfo.messageRoute.getGroupId(), routingInfo.messageRoute.getIndex(), myRoleMessageExchangeImpl);
        routingInfo.correlator.removeRoutes(routingInfo.messageRoute.getGroupId(), processInstanceDAO);
        CorrelationMatchEvent correlationMatchEvent = new CorrelationMatchEvent(new QName(this._process.getOProcess().targetNamespace, this._process.getOProcess().getName()), this._process.getProcessDAO().getProcessId(), processInstanceDAO.getInstanceId(), routingInfo.matchedKeySet);
        correlationMatchEvent.setPortType(myRoleMessageExchangeImpl.getPortType().getQName());
        correlationMatchEvent.setOperation(operation.getName());
        correlationMatchEvent.setMexId(myRoleMessageExchangeImpl.getMessageExchangeId());
        this._process._debugger.onEvent((BpelEvent)correlationMatchEvent);
        this._process.saveEvent((ProcessInstanceEvent)correlationMatchEvent, processInstanceDAO);
        myRoleMessageExchangeImpl.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.MATCHED);
        myRoleMessageExchangeImpl.getDAO().setInstance(routingInfo.messageRoute.getTargetInstance());
        bpelRuntimeContextImpl.execute();
    }

    public void noRoutingMatch(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl, List<RoutingInfo> list) {
        if (!myRoleMessageExchangeImpl.isAsynchronous()) {
            myRoleMessageExchangeImpl.setFailure(MessageExchange.FailureType.NOMATCH, "No process instance matching correlation keys.", null);
        } else {
            RoutingInfo routingInfo;
            RoutingInfo routingInfo2 = routingInfo = list != null && list.size() > 0 ? list.get(list.size() - 1) : null;
            if (routingInfo != null) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("INPUTMSG: " + routingInfo.correlator.getCorrelatorId() + ": SAVING to DB (no match) "));
                }
                CorrelationNoMatchEvent correlationNoMatchEvent = new CorrelationNoMatchEvent(myRoleMessageExchangeImpl.getPortType().getQName(), myRoleMessageExchangeImpl.getOperation().getName(), myRoleMessageExchangeImpl.getMessageExchangeId(), routingInfo.wholeKeySet);
                correlationNoMatchEvent.setProcessId(this._process.getProcessDAO().getProcessId());
                correlationNoMatchEvent.setProcessName(new QName(this._process.getOProcess().targetNamespace, this._process.getOProcess().getName()));
                this._process._debugger.onEvent((BpelEvent)correlationNoMatchEvent);
                myRoleMessageExchangeImpl.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.QUEUED);
                routingInfo.correlator.enqueueMessage(myRoleMessageExchangeImpl.getDAO(), routingInfo.wholeKeySet);
            }
        }
    }

    private void setMexRole(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl) {
        Operation operation = this.getMyRoleOperation(myRoleMessageExchangeImpl.getOperationName());
        myRoleMessageExchangeImpl.getDAO().setPartnerLinkModelId(this._plinkDef.getId());
        myRoleMessageExchangeImpl.setPortOp(this._plinkDef.myRolePortType, operation);
        myRoleMessageExchangeImpl.setPattern(operation.getOutput() == null ? MessageExchange.MessageExchangePattern.REQUEST_ONLY : MessageExchange.MessageExchangePattern.REQUEST_RESPONSE);
    }

    private Operation getMyRoleOperation(String string) {
        return this._plinkDef.getMyRoleOperation(string);
    }

    private CorrelationKeySet computeCorrelationKeys(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl) {
        CorrelationKey correlationKey;
        CorrelationKeySet correlationKeySet = new CorrelationKeySet();
        Operation operation = myRoleMessageExchangeImpl.getOperation();
        Element element = myRoleMessageExchangeImpl.getRequest().getMessage();
        Message message = operation.getInput().getMessage();
        Set set = this._plinkDef.getNonInitiatingCorrelationSetsForOperation(operation);
        for (OScope.CorrelationSet correlationSet : set) {
            correlationKey = this.computeCorrelationKey(correlationSet, (OMessageVarType)this._process.getOProcess().messageTypes.get(message.getQName()), element);
            correlationKeySet.add(correlationKey);
        }
        set = this._plinkDef.getJoinningCorrelationSetsForOperation(operation);
        for (OScope.CorrelationSet correlationSet : set) {
            correlationKey = this.computeCorrelationKey(correlationSet, (OMessageVarType)this._process.getOProcess().messageTypes.get(message.getQName()), element);
            correlationKeySet.add(correlationKey);
        }
        String string = myRoleMessageExchangeImpl.getProperty("org.apache.ode.bpel.myRoleSessionId");
        if (string != null) {
            correlationKeySet.add(new CorrelationKey("-1", new String[]{string}));
        }
        return correlationKeySet;
    }

    private CorrelationKey computeCorrelationKey(OScope.CorrelationSet correlationSet, OMessageVarType oMessageVarType, Element element) {
        Object object = null;
        String[] stringArray = new String[correlationSet.properties.size()];
        int n = 0;
        for (OProcess.OProperty oProperty : correlationSet.properties) {
            String string;
            OProcess.OPropertyAlias oPropertyAlias = oProperty.getAlias((OVarType)oMessageVarType);
            if (oPropertyAlias == null) {
                throw new IllegalArgumentException("No alias matching property '" + oProperty.name + "' with message type '" + oMessageVarType + "'");
            }
            try {
                string = this._process.extractProperty(element, oPropertyAlias, element.toString());
            }
            catch (FaultException faultException) {
                String string2 = __msgs.msgPropertyAliasDerefFailedOnMessage(oPropertyAlias.getDescription(), faultException.getMessage());
                __log.error((Object)string2, (Throwable)faultException);
                throw new InvalidMessageException(string2, (Throwable)faultException);
            }
            stringArray[n] = string;
            ++n;
        }
        object = correlationSet.hasJoinUseCases ? new OptionalCorrelationKey(correlationSet.name, stringArray) : new CorrelationKey(correlationSet.name, stringArray);
        return object;
    }

    public boolean isOneWayOnly() {
        PortType portType = this._plinkDef.myRolePortType;
        if (portType == null) {
            return false;
        }
        for (Operation operation : portType.getOperations()) {
            if (operation.getOutput() == null) continue;
            return false;
        }
        return true;
    }

    class RoutingInfo {
        MessageRouteDAO messageRoute;
        CorrelationKeySet matchedKeySet;
        CorrelatorDAO correlator;
        CorrelationKeySet wholeKeySet;

        public RoutingInfo(MessageRouteDAO messageRouteDAO, CorrelationKeySet correlationKeySet, CorrelatorDAO correlatorDAO, CorrelationKeySet correlationKeySet2) {
            this.messageRoute = messageRouteDAO;
            this.matchedKeySet = correlationKeySet;
            this.correlator = correlatorDAO;
            this.wholeKeySet = correlationKeySet2;
        }
    }
}

