/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NStateLatch {
    static final Log __log = LogFactory.getLog(NStateLatch.class);
    private int _state = -1;
    private int _depth = 0;
    protected Runnable[] _transitions;
    private Lock _lock;
    private Condition _depth0;
    private boolean _transitioning = false;

    public NStateLatch(Runnable[] runnableArray) {
        this._transitions = runnableArray;
        this._lock = new ReentrantLock();
        this._depth0 = this._lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void latch(int n) {
        block10: {
            if (n >= this._transitions.length || n < 0) {
                throw new IllegalArgumentException("Invalid state.");
            }
            this._lock.lock();
            try {
                if (this._transitioning) {
                    throw new IllegalStateException("Manipulating latch from transition. ");
                }
                if (this._state == n) break block10;
                while (this._depth != 0) {
                    this._depth0.awaitUninterruptibly();
                }
                if (this._state == n) break block10;
                if (this._transitions[n] != null) {
                    try {
                        this._transitioning = true;
                        this._transitions[n].run();
                    }
                    finally {
                        this._transitioning = false;
                    }
                }
                this._state = n;
            }
            finally {
                ++this._depth;
                this._lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(int n) {
        this._lock.lock();
        try {
            if (this._transitioning) {
                throw new IllegalStateException("Manipulating latch from transition. ");
            }
            if (this._state != n) {
                __log.error((Object)("Latch error, was releasing for state " + n + " but actually in " + this._state));
            }
            if (this._depth <= 0) {
                throw new IllegalStateException("Too many release() calls.");
            }
            --this._depth;
            if (this._depth == 0) {
                this._depth0.signal();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public int getDepth(int n) {
        return this._state == n ? this._depth : 0;
    }
}

