/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.InterceptorContextImpl;
import org.apache.ode.bpel.engine.MessageExchangeImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.AbortMessageExchangeException;
import org.apache.ode.bpel.intercept.FaultMessageExchangeException;
import org.apache.ode.bpel.intercept.InterceptorInvoker;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MyRoleMessageExchangeImpl
extends MessageExchangeImpl
implements MyRoleMessageExchange {
    private static final Log __log = LogFactory.getLog(MyRoleMessageExchangeImpl.class);
    protected BpelProcess _process;
    private static Map<String, ResponseCallback> _waitingCallbacks = new ConcurrentHashMap<String, ResponseCallback>();

    public MyRoleMessageExchangeImpl(BpelProcess bpelProcess, BpelEngineImpl bpelEngineImpl, MessageExchangeDAO messageExchangeDAO) {
        super(bpelEngineImpl, messageExchangeDAO);
        this._process = bpelProcess;
    }

    public MyRoleMessageExchange.CorrelationStatus getCorrelationStatus() {
        return MyRoleMessageExchange.CorrelationStatus.valueOf((String)this.getDAO().getCorrelationStatus());
    }

    void setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus correlationStatus) {
        this.getDAO().setCorrelationStatus(correlationStatus.toString());
    }

    private boolean processInterceptors(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl, InterceptorInvoker interceptorInvoker) {
        InterceptorContextImpl interceptorContextImpl = new InterceptorContextImpl(this._engine._contexts.dao.getConnection(), myRoleMessageExchangeImpl._dao.getProcess(), null, this._engine, this._process);
        for (MessageExchangeInterceptor messageExchangeInterceptor : this._engine.getGlobalInterceptors()) {
            if (this.processInterceptor(messageExchangeInterceptor, myRoleMessageExchangeImpl, interceptorContextImpl, interceptorInvoker)) continue;
            return false;
        }
        return true;
    }

    boolean processInterceptor(MessageExchangeInterceptor messageExchangeInterceptor, MyRoleMessageExchangeImpl myRoleMessageExchangeImpl, MessageExchangeInterceptor.InterceptorContext interceptorContext, InterceptorInvoker interceptorInvoker) {
        __log.debug((Object)(interceptorInvoker + "--> interceptor " + messageExchangeInterceptor));
        try {
            interceptorInvoker.invoke(messageExchangeInterceptor, myRoleMessageExchangeImpl, interceptorContext);
        }
        catch (FaultMessageExchangeException faultMessageExchangeException) {
            __log.debug((Object)("interceptor " + messageExchangeInterceptor + " caused invoke on " + this + " to be aborted with FAULT " + faultMessageExchangeException.getFaultName()));
            myRoleMessageExchangeImpl.setFault(faultMessageExchangeException.getFaultName(), faultMessageExchangeException.getFaultData());
            return false;
        }
        catch (AbortMessageExchangeException abortMessageExchangeException) {
            __log.debug((Object)("interceptor " + messageExchangeInterceptor + " cause invoke on " + this + " to be aborted with FAILURE: " + abortMessageExchangeException.getMessage()));
            myRoleMessageExchangeImpl.setFailure(MessageExchange.FailureType.ABORTED, __msgs.msgInterceptorAborted(myRoleMessageExchangeImpl.getMessageExchangeId(), messageExchangeInterceptor.toString(), abortMessageExchangeException.getMessage()), null);
            return false;
        }
        return true;
    }

    public Future invoke(Message message) {
        if (message == null) {
            String string = "Must pass non-null message to invoke()!";
            __log.fatal((Object)string);
            throw new NullPointerException(string);
        }
        this._dao.setRequest(((MessageImpl)message)._dao);
        this._dao.setStatus(MessageExchange.Status.REQUEST.toString());
        if (!this.processInterceptors(this, InterceptorInvoker.__onBpelServerInvoked)) {
            return null;
        }
        BpelProcess bpelProcess = this._process;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("invoke() EPR= " + this._epr + " ==> " + bpelProcess));
        }
        if (bpelProcess == null) {
            if (__log.isWarnEnabled()) {
                __log.warn((Object)__msgs.msgUnknownEPR("" + this._epr));
            }
            this.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.UKNOWN_ENDPOINT);
            this.setFailure(MessageExchange.FailureType.UNKNOWN_ENDPOINT, null, null);
            return null;
        }
        WorkEvent workEvent = new WorkEvent();
        workEvent.setType(WorkEvent.Type.INVOKE_INTERNAL);
        if (bpelProcess.isInMemory()) {
            workEvent.setInMem(true);
        }
        workEvent.setProcessId(bpelProcess.getPID());
        workEvent.setMexId(this.getDAO().getMessageExchangeId());
        if (this.getOperation().getOutput() != null) {
            ResponseCallback responseCallback = new ResponseCallback();
            _waitingCallbacks.put(this.getClientId(), responseCallback);
        }
        this.setStatus(MessageExchange.Status.ASYNC);
        if (bpelProcess.isInMemory()) {
            this._engine._contexts.scheduler.scheduleVolatileJob(true, workEvent.getDetail());
        } else {
            this._engine._contexts.scheduler.schedulePersistedJob(workEvent.getDetail(), null);
        }
        return new ResponseFuture(this.getClientId());
    }

    public void complete() {
    }

    public QName getServiceName() {
        return this.getDAO().getCallee();
    }

    public void setClientId(String string) {
        this.getDAO().setCorrelationId(string);
    }

    public String getClientId() {
        return this.getDAO().getCorrelationId();
    }

    public String toString() {
        try {
            return "{MyRoleMex#" + this.getMessageExchangeId() + " [Client " + this.getClientId() + "] calling " + this.getServiceName() + "." + this.getOperationName() + "(...)}";
        }
        catch (Throwable throwable) {
            return "{MyRoleMex#???}";
        }
    }

    public boolean isAsynchronous() {
        return true;
    }

    public void release(boolean bl) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Releasing mex " + this.getMessageExchangeId()));
        }
        if (this._process != null) {
            this._dao.release(this._process.isCleanupCategoryEnabled(bl, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
        }
        this._dao = null;
    }

    protected Message cloneMessage(Message message) {
        Message message2 = this.createMessage(message.getType());
        message2.setMessage((Element)message.getMessage().cloneNode(true));
        Map map = message.getHeaderParts();
        for (Object object : map.keySet()) {
            message2.setHeaderPart((String)object, (Element)((Node)map.get(object)).cloneNode(true));
        }
        Map map2 = message.getHeaderParts();
        for (String string : map2.keySet()) {
            message2.setHeaderPart(string, (Element)((Node)map2.get(string)).cloneNode(true));
        }
        return message2;
    }

    protected void responseReceived() {
        final String string = this.getClientId();
        this._engine._contexts.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

            public void afterCompletion(boolean bl) {
                __log.debug((Object)"Received myrole mex response callback");
                ResponseCallback responseCallback = (ResponseCallback)_waitingCallbacks.remove(string);
                if (responseCallback != null) {
                    responseCallback.responseReceived();
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    static class ResponseCallback {
        private boolean _timedout;
        private boolean _waiting = true;

        ResponseCallback() {
        }

        synchronized boolean responseReceived() {
            if (this._timedout) {
                return false;
            }
            this._waiting = false;
            this.notify();
            return true;
        }

        synchronized void waitResponse(long l) {
            long l2 = l == 0L ? Long.MAX_VALUE : System.currentTimeMillis() + l;
            try {
                long l3;
                while (this._waiting && (l3 = System.currentTimeMillis()) < l2) {
                    this.wait(l2 - l3);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._timedout = this._waiting;
        }
    }

    static class ResponseFuture
    implements Future {
        private String _clientId;
        private boolean _done = false;

        public ResponseFuture(String string) {
            this._clientId = string;
        }

        public boolean cancel(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public Object get() throws InterruptedException, ExecutionException {
            try {
                return this.get(0L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                throw new ExecutionException(timeoutException);
            }
        }

        public Object get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            ResponseCallback responseCallback = (ResponseCallback)_waitingCallbacks.get(this._clientId);
            if (responseCallback != null) {
                responseCallback.waitResponse(l);
                this._done = true;
                if (responseCallback._timedout) {
                    throw new TimeoutException("Message exchange " + this + " timed out(" + l + " ms) when waiting for a response!");
                }
            }
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return this._done;
        }
    }
}

