/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements Message {
    MessageDAO _dao;

    public MessageImpl(MessageDAO messageDAO) {
        this._dao = messageDAO;
    }

    public Element getPart(String string) {
        Element element = this.getMessage();
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public void setPart(String string, Element element) {
        Element element2 = this.getMessage();
        if (element2 == null) {
            Document document = DOMUtils.newDocument();
            element2 = document.createElement("message");
            document.appendChild(element2);
        }
        element2.appendChild(element2.getOwnerDocument().importNode(element, true));
        this.setMessage(element2);
    }

    public Element getHeaderPart(String string) {
        Element element = this._dao.getHeader();
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public void setHeaderPart(String string, Element element) {
        Node node;
        Element element2 = this._dao.getHeader();
        if (element2 == null) {
            node = DOMUtils.newDocument();
            element2 = node.createElement("header");
            node.appendChild(element2);
        }
        node = element2.getOwnerDocument().createElement(string);
        element2.appendChild(node);
        node.appendChild(element2.getOwnerDocument().importNode(element, true));
        this._dao.setHeader(element2);
    }

    public void setHeaderPart(String string, String string2) {
        Node node;
        Element element = this._dao.getHeader();
        if (element == null) {
            node = DOMUtils.newDocument();
            element = node.createElement("header");
            node.appendChild(element);
        }
        node = element.getOwnerDocument().createElement(string);
        element.appendChild(node);
        node.setTextContent(string2);
        this._dao.setHeader(element);
    }

    public void setMessage(Element element) {
        this._dao.setData(element);
    }

    public Element getMessage() {
        return this._dao.getData();
    }

    public QName getType() {
        return this._dao.getType();
    }

    public List<String> getParts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element = this.getMessage();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            arrayList.add(node.getLocalName());
        }
        return arrayList;
    }

    public Map<String, Node> getHeaderParts() {
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        Element element = this._dao.getHeader();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                Element element2 = (Element)nodeList.item(i);
                Node node = DOMUtils.findChildByType((Element)element2, (int)1);
                if (node == null) {
                    node = DOMUtils.findChildByType((Element)element2, (int)3);
                }
                hashMap.put(element2.getLocalName(), node);
            }
        }
        return hashMap;
    }
}

