/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.Set;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MessageExchangeImpl
implements MessageExchange {
    private static final Log __log = LogFactory.getLog(MessageExchangeImpl.class);
    protected static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    protected Long _iid;
    protected PortType _portType;
    protected Operation _operation;
    protected final BpelEngineImpl _engine;
    protected EndpointReference _epr;
    protected MessageExchangeDAO _dao;

    MessageExchangeImpl(BpelEngineImpl bpelEngineImpl, MessageExchangeDAO messageExchangeDAO, MessageExchange.MessageExchangePattern messageExchangePattern, String string, EndpointReference endpointReference) {
        this._engine = bpelEngineImpl;
        this._dao = messageExchangeDAO;
        this._epr = endpointReference;
        this.getDAO().setPattern(messageExchangePattern.toString());
        this.getDAO().setOperation(string);
        if (endpointReference != null) {
            this.getDAO().setEPR(endpointReference.toXML().getDocumentElement());
        }
    }

    public MessageExchangeImpl(BpelEngineImpl bpelEngineImpl, MessageExchangeDAO messageExchangeDAO) {
        this._engine = bpelEngineImpl;
        this._dao = messageExchangeDAO;
    }

    public String getMessageExchangeId() throws BpelEngineException {
        return this.getDAO().getMessageExchangeId();
    }

    public String getOperationName() throws BpelEngineException {
        return this.getDAO().getOperation();
    }

    public MessageExchange.MessageExchangePattern getMessageExchangePattern() {
        return MessageExchange.MessageExchangePattern.valueOf((String)this.getDAO().getPattern());
    }

    public boolean isTransactionPropagated() throws BpelEngineException {
        return this.getDAO().getPropagateTransactionFlag();
    }

    public Message getResponse() {
        return new MessageImpl(this.getDAO().getResponse());
    }

    public QName getFault() {
        return this.getDAO().getFault();
    }

    public Message getFaultResponse() {
        return this.getResponse();
    }

    public String getFaultExplanation() {
        return this.getDAO().getFaultExplanation();
    }

    public MessageExchange.MessageExchangePattern getPattern() {
        return MessageExchange.MessageExchangePattern.valueOf((String)this.getDAO().getPattern());
    }

    public MessageExchange.Status getStatus() {
        return MessageExchange.Status.valueOf((String)this.getDAO().getStatus());
    }

    public Message getRequest() {
        return new MessageImpl(this.getDAO().getRequest());
    }

    public Operation getOperation() {
        return this._operation;
    }

    public PortType getPortType() {
        return this._portType;
    }

    void setPattern(MessageExchange.MessageExchangePattern messageExchangePattern) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("Mex[" + this.getMessageExchangeId() + "].setPattern(" + messageExchangePattern + ")"));
        }
        this.getDAO().setPattern(messageExchangePattern.toString());
    }

    void setPortOp(PortType portType, Operation operation) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("Mex[" + this.getMessageExchangeId() + "].setPortOp(...)"));
        }
        this._portType = portType;
        this._operation = operation;
    }

    MessageExchangeDAO getDAO() {
        return this._dao;
    }

    void setFault(QName qName, Message message) throws BpelEngineException {
        this.setStatus(MessageExchange.Status.FAULT);
        this.getDAO().setFault(qName);
        this.getDAO().setResponse(((MessageImpl)message)._dao);
        this.responseReceived();
    }

    void setFaultExplanation(String string) {
        this.getDAO().setFaultExplanation(string);
    }

    void setResponse(Message message) throws BpelEngineException {
        if (this.getStatus() != MessageExchange.Status.REQUEST && this.getStatus() != MessageExchange.Status.ASYNC) {
            throw new IllegalStateException("Not in REQUEST state!");
        }
        this.setStatus(MessageExchange.Status.RESPONSE);
        this.getDAO().setFault(null);
        this.getDAO().setResponse(((MessageImpl)message)._dao);
        this.responseReceived();
    }

    void setFailure(MessageExchange.FailureType failureType, String string, Element element) throws BpelEngineException {
        this.setStatus(MessageExchange.Status.FAILURE);
        this.getDAO().setFaultExplanation(string);
        if (element != null) {
            Message message = this.createMessage(new QName(Namespaces.ODE_EXTENSION_NS, "failureMessage"));
            message.setMessage(element);
            this.getDAO().setResponse(((MessageImpl)message)._dao);
        }
        this.responseReceived();
    }

    void setStatus(MessageExchange.Status status) {
        this.getDAO().setStatus(status.toString());
    }

    public Message createMessage(QName qName) {
        MessageDAO messageDAO = this.getDAO().createMessage(qName);
        return new MessageImpl(messageDAO);
    }

    public void setEndpointReference(EndpointReference endpointReference) {
        this._epr = endpointReference;
        if (endpointReference != null) {
            this.getDAO().setEPR(endpointReference.toXML().getDocumentElement());
        }
    }

    public EndpointReference getEndpointReference() throws BpelEngineException {
        if (this._epr != null) {
            return this._epr;
        }
        if (this.getDAO().getEPR() == null) {
            return null;
        }
        this._epr = this._engine._contexts.eprContext.resolveEndpointReference(this.getDAO().getEPR());
        return this._epr;
    }

    QName getServiceName() {
        return this.getDAO().getCallee();
    }

    public String getProperty(String string) {
        String string2 = this.getDAO().getProperty(string);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("GET MEX property " + string + " = " + string2));
        }
        return string2;
    }

    public void setProperty(String string, String string2) {
        this.getDAO().setProperty(string, string2);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("SET MEX property " + string + " = " + string2));
        }
    }

    public Set<String> getPropertyNames() {
        return this.getDAO().getPropertyNames();
    }

    public int getSubscriberCount() {
        return this.getDAO().getSubscriberCount();
    }

    public void setSubscriberCount(int n) {
        this.getDAO().setSubscriberCount(n);
    }

    public void release() {
        __log.debug((Object)("Releasing mex " + this.getMessageExchangeId()));
        this._dao.release(true);
        this._dao = null;
    }

    public String toString() {
        return "MEX[" + this.getDAO().getMessageExchangeId() + "]";
    }

    protected void responseReceived() {
    }
}

