/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceLockManager {
    private static final Log __log = LogFactory.getLog(InstanceLockManager.class);
    private final Lock _mutex = new ReentrantLock();
    private final Map<Long, InstanceInfo> _locks = new HashMap<Long, InstanceInfo>();

    public void lock(Long l, int n, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (l == null) {
            return;
        }
        String string = Thread.currentThread().toString();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(string + ": lock(iid=" + l + ", time=" + n + (Object)((Object)timeUnit) + ")"));
        }
        this._mutex.lock();
        try {
            InstanceInfo instanceInfo;
            do {
                if ((instanceInfo = this._locks.get(l)) == null) {
                    instanceInfo = new InstanceInfo(l, Thread.currentThread());
                    this._locks.put(l, instanceInfo);
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)(string + ": lock(iid=" + l + ", time=" + n + (Object)((Object)timeUnit) + ")-->GRANTED"));
                    }
                    return;
                }
                if (!__log.isDebugEnabled()) continue;
                __log.debug((Object)(string + ": lock(iid=" + l + ", time=" + n + (Object)((Object)timeUnit) + ")-->WAITING(held by " + instanceInfo.acquierer + ")"));
            } while (instanceInfo.available.await(n, timeUnit));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)(string + ": lock(iid=" + l + ", time=" + n + (Object)((Object)timeUnit) + ")-->TIMEOUT (held by " + instanceInfo.acquierer + ")"));
            }
            throw new TimeoutException();
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Long l) {
        if (l == null) {
            return;
        }
        String string = Thread.currentThread().toString();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(string + ": unlock(iid=" + l + ")"));
        }
        this._mutex.lock();
        try {
            InstanceInfo instanceInfo = this._locks.get(l);
            if (instanceInfo == null) {
                throw new IllegalStateException("Instance not locked, cannot unlock!");
            }
            this._locks.remove(l);
            instanceInfo.available.signalAll();
        }
        finally {
            this._mutex.unlock();
        }
    }

    public String toString() {
        return "{InstanceLockManager: " + this._locks + "}";
    }

    public static final class TimeoutException
    extends Exception {
        private static final long serialVersionUID = 7247629086692580285L;
    }

    private class InstanceInfo {
        final long iid;
        final Thread acquierer;
        Condition available;

        InstanceInfo(long l, Thread thread) {
            this.available = InstanceLockManager.this._mutex.newCondition();
            this.iid = l;
            this.acquierer = thread;
        }

        public String toString() {
            return "{Lock for Instance #" + this.iid + ", acquired by " + this.acquierer + "}";
        }
    }
}

