/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

class DocumentInfoGenerator {
    private final File _file;
    private String _type;
    private static final Map<String, String> __extToTypeMap = new HashMap<String, String>();

    DocumentInfoGenerator(File file) {
        this._file = file;
        this.recognize();
    }

    public boolean isRecognized() {
        return this._type != null;
    }

    public boolean isVisible() {
        return !this._file.isHidden();
    }

    public String getName() {
        return this._file.getName();
    }

    public String getURL() {
        try {
            return this._file.toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public String getType() {
        return this._type;
    }

    private void recognize() {
        String string = this._file.getName().toLowerCase();
        for (Map.Entry<String, String> entry : __extToTypeMap.entrySet()) {
            if (!string.endsWith(entry.getKey().toLowerCase())) continue;
            this._type = entry.getValue();
            break;
        }
    }

    static {
        __extToTypeMap.put(".wsdl", "http://schemas.xmlsoap.org/wsdl/");
        __extToTypeMap.put(".xsd", "http://www.w3.org/2001/XMLSchema");
        __extToTypeMap.put(".svg", "http://www.w3.org/2000/svg");
        __extToTypeMap.put(".cbp", "http://www.fivesight.com/schemas/2005/12/19/CompiledBPEL");
        __extToTypeMap.put(".bpel", "http://schemas.xmlsoap.org/ws/2004/03/business-process/");
    }
}

