/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.bdi.breaks.Breakpoint;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.BpelProcessDatabase;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.evt.ActivityExecStartEvent;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ProcessCompletionEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStateChangeEvent;
import org.apache.ode.bpel.evt.ProcessTerminationEvent;
import org.apache.ode.bpel.evt.ScopeCompletionEvent;
import org.apache.ode.bpel.iapi.DebuggerContext;
import org.apache.ode.bpel.pmapi.InstanceNotFoundException;
import org.apache.ode.bpel.pmapi.ManagementException;
import org.apache.ode.bpel.pmapi.ProcessingException;
import org.apache.ode.bpel.runtime.breaks.BreakpointImpl;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.msg.MessageBundle;

public class DebuggerSupport
implements DebuggerContext {
    private static final Log __log = LogFactory.getLog(DebuggerSupport.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    static final Breakpoint[] EMPTY_BP = new Breakpoint[0];
    private boolean _enabled = true;
    private Breakpoint[] _globalBreakPoints = EMPTY_BP;
    private final Set<Long> _step = new HashSet<Long>();
    private final Map<Long, Breakpoint[]> _instanceBreakPoints = new HashMap<Long, Breakpoint[]>();
    private BpelProcessDatabase _db;
    private BpelProcess _process;

    protected DebuggerSupport(BpelProcess bpelProcess) {
        this._process = bpelProcess;
        this._db = new BpelProcessDatabase(this._process._engine._contexts.dao, this._process._engine._contexts.scheduler, this._process._pid);
    }

    public void enable(boolean bl) {
        this._enabled = bl;
    }

    public Breakpoint[] getGlobalBreakpoints() {
        return this._globalBreakPoints;
    }

    public Breakpoint[] getBreakpoints(Long l) {
        Breakpoint[] breakpointArray = this._instanceBreakPoints.get(l);
        return breakpointArray == null ? EMPTY_BP : breakpointArray;
    }

    public void addGlobalBreakpoint(Breakpoint breakpoint) {
        Collection collection = CollectionUtils.makeCollection(ArrayList.class, (Object[])this._globalBreakPoints);
        collection.add(breakpoint);
        this._globalBreakPoints = collection.toArray(new Breakpoint[collection.size()]);
    }

    public void addBreakpoint(Long l, Breakpoint breakpoint) {
        Object[] objectArray = this._instanceBreakPoints.get(l);
        if (objectArray == null) {
            objectArray = new Breakpoint[]{breakpoint};
        } else {
            Collection collection = CollectionUtils.makeCollection(ArrayList.class, (Object[])objectArray);
            collection.add(breakpoint);
            objectArray = collection.toArray(new Breakpoint[collection.size()]);
        }
        this._instanceBreakPoints.put(l, (Breakpoint[])objectArray);
    }

    public void removeGlobalBreakpoint(Breakpoint breakpoint) {
        Collection collection = CollectionUtils.makeCollection(ArrayList.class, (Object[])this._globalBreakPoints);
        collection.remove(breakpoint);
        this._globalBreakPoints = collection.toArray(new Breakpoint[collection.size()]);
    }

    public void removeBreakpoint(Long l, Breakpoint breakpoint) {
        Object[] objectArray = this._instanceBreakPoints.get(l);
        if (objectArray != null) {
            Collection collection = CollectionUtils.makeCollection(ArrayList.class, (Object[])objectArray);
            collection.remove(breakpoint);
            objectArray = collection.toArray(new Breakpoint[collection.size()]);
            if (objectArray.length == 0) {
                this._instanceBreakPoints.remove(l);
            } else {
                this._instanceBreakPoints.put(l, (Breakpoint[])objectArray);
            }
        }
    }

    public boolean step(final Long l) {
        boolean bl = false;
        try {
            bl = this._db.exec(new BpelDatabase.Callable<Boolean>(){

                @Override
                public Boolean run(BpelDAOConnection bpelDAOConnection) throws Exception {
                    ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                    if (processInstanceDAO == null) {
                        throw new InstanceNotFoundException("" + l);
                    }
                    if (50 == processInstanceDAO.getState()) {
                        ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
                        processInstanceStateChangeEvent.setOldState((short)50);
                        short s = processInstanceDAO.getPreviousState();
                        processInstanceDAO.setState(s);
                        processInstanceStateChangeEvent.setNewState(s);
                        processInstanceStateChangeEvent.setProcessInstanceId(l);
                        processInstanceStateChangeEvent.setProcessName(processInstanceDAO.getProcess().getType());
                        processInstanceStateChangeEvent.setProcessId(DebuggerSupport.this._db.getProcessId());
                        DebuggerSupport.this._process.saveEvent((ProcessInstanceEvent)processInstanceStateChangeEvent, processInstanceDAO);
                        DebuggerSupport.this.onEvent((BpelEvent)processInstanceStateChangeEvent);
                        __log.debug((Object)("step(" + l + ") adding step indicator to table."));
                        DebuggerSupport.this._step.add(l);
                        WorkEvent workEvent = new WorkEvent();
                        workEvent.setIID(l);
                        workEvent.setType(WorkEvent.Type.RESUME);
                        ((DebuggerSupport)DebuggerSupport.this)._process._engine._contexts.scheduler.schedulePersistedJob(workEvent.getDetail(), null);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            __log.error((Object)"UnexpectedEx", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        return bl;
    }

    public void onEvent(BpelEvent bpelEvent) {
        if (this._enabled && bpelEvent instanceof ProcessInstanceEvent && !(bpelEvent instanceof ProcessInstanceStateChangeEvent)) {
            ProcessDAO processDAO;
            ProcessInstanceEvent processInstanceEvent = (ProcessInstanceEvent)bpelEvent;
            if (processInstanceEvent instanceof ProcessCompletionEvent || processInstanceEvent instanceof ProcessTerminationEvent) {
                this._step.remove(processInstanceEvent.getProcessInstanceId());
                this._instanceBreakPoints.remove(processInstanceEvent.getProcessInstanceId());
                return;
            }
            boolean bl = this.checkStep(processInstanceEvent);
            if (!bl) {
                bl = this.checkBreakPoints(processInstanceEvent, this._globalBreakPoints);
            }
            if (!bl && (processDAO = this._instanceBreakPoints.get(processInstanceEvent.getProcessInstanceId())) != null) {
                bl = this.checkBreakPoints(processInstanceEvent, (Breakpoint[])processDAO);
            }
            if (bl) {
                this._step.remove(processInstanceEvent.getProcessInstanceId());
                try {
                    processDAO = this._db.getProcessDAO();
                    ProcessInstanceDAO processInstanceDAO = processDAO.getInstance(processInstanceEvent.getProcessInstanceId());
                    if (ProcessState.canExecute((short)processInstanceDAO.getState())) {
                        ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
                        processInstanceStateChangeEvent.setOldState(processInstanceDAO.getState());
                        processInstanceDAO.setState((short)50);
                        processInstanceStateChangeEvent.setNewState((short)50);
                        processInstanceStateChangeEvent.setProcessInstanceId(processInstanceDAO.getInstanceId());
                        processInstanceStateChangeEvent.setProcessName(processDAO.getType());
                        processInstanceStateChangeEvent.setProcessId(this._db.getProcessId());
                        this._process.saveEvent((ProcessInstanceEvent)processInstanceStateChangeEvent, processInstanceDAO);
                        this.onEvent((BpelEvent)processInstanceStateChangeEvent);
                    }
                }
                catch (Exception exception) {
                    __log.error((Object)__msgs.msgDbError(), (Throwable)exception);
                }
            }
        }
    }

    private boolean checkStep(ProcessInstanceEvent processInstanceEvent) {
        Long l = processInstanceEvent.getProcessInstanceId();
        return this._step.contains(l) && (processInstanceEvent instanceof ActivityExecStartEvent || processInstanceEvent instanceof ScopeCompletionEvent);
    }

    private boolean checkBreakPoints(ProcessInstanceEvent processInstanceEvent, Breakpoint[] breakpointArray) {
        boolean bl = false;
        for (int i = 0; i < breakpointArray.length; ++i) {
            if (!((BreakpointImpl)breakpointArray[i]).checkBreak((BpelEvent)processInstanceEvent)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean resume(final Long l) {
        boolean bl = false;
        try {
            bl = this._db.exec(new BpelDatabase.Callable<Boolean>(){

                @Override
                public Boolean run(BpelDAOConnection bpelDAOConnection) throws Exception {
                    ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                    if (processInstanceDAO == null) {
                        throw new InstanceNotFoundException("" + l);
                    }
                    if (50 == processInstanceDAO.getState()) {
                        ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
                        processInstanceStateChangeEvent.setOldState((short)50);
                        short s = processInstanceDAO.getPreviousState();
                        processInstanceDAO.setState(s);
                        processInstanceStateChangeEvent.setNewState(s);
                        processInstanceStateChangeEvent.setProcessInstanceId(l);
                        processInstanceStateChangeEvent.setProcessName(processInstanceDAO.getProcess().getType());
                        processInstanceStateChangeEvent.setProcessId(DebuggerSupport.this._db.getProcessId());
                        DebuggerSupport.this._process.saveEvent((ProcessInstanceEvent)processInstanceStateChangeEvent, processInstanceDAO);
                        DebuggerSupport.this.onEvent((BpelEvent)processInstanceStateChangeEvent);
                        WorkEvent workEvent = new WorkEvent();
                        workEvent.setType(WorkEvent.Type.RESUME);
                        workEvent.setIID(l);
                        ((DebuggerSupport)DebuggerSupport.this)._process._engine._contexts.scheduler.schedulePersistedJob(workEvent.getDetail(), null);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            __log.error((Object)"ProcessingEx", (Throwable)exception);
            throw new ProcessingException(exception.getMessage(), (Throwable)exception);
        }
        return bl;
    }

    public void suspend(final Long l) {
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection bpelDAOConnection) throws Exception {
                    ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                    if (processInstanceDAO == null) {
                        throw new InstanceNotFoundException("" + l);
                    }
                    if (ProcessState.canExecute((short)processInstanceDAO.getState())) {
                        ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
                        processInstanceStateChangeEvent.setOldState(processInstanceDAO.getState());
                        processInstanceDAO.setState((short)50);
                        processInstanceStateChangeEvent.setNewState((short)50);
                        processInstanceStateChangeEvent.setProcessInstanceId(l);
                        ProcessDAO processDAO = processInstanceDAO.getProcess();
                        processInstanceStateChangeEvent.setProcessName(processDAO.getType());
                        processInstanceStateChangeEvent.setProcessId(processDAO.getProcessId());
                        DebuggerSupport.this._process.saveEvent((ProcessInstanceEvent)processInstanceStateChangeEvent, processInstanceDAO);
                        DebuggerSupport.this.onEvent((BpelEvent)processInstanceStateChangeEvent);
                    }
                    return null;
                }
            });
        }
        catch (ManagementException managementException) {
            throw managementException;
        }
        catch (Exception exception) {
            __log.error((Object)"DbError", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public void terminate(final Long l) {
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection bpelDAOConnection) throws Exception {
                    ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                    if (processInstanceDAO == null) {
                        throw new ManagementException("InstanceNotFound:" + l);
                    }
                    ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
                    processInstanceStateChangeEvent.setOldState(processInstanceDAO.getState());
                    processInstanceDAO.setState((short)60);
                    processInstanceStateChangeEvent.setNewState((short)60);
                    processInstanceStateChangeEvent.setProcessInstanceId(l);
                    ProcessDAO processDAO = processInstanceDAO.getProcess();
                    QName qName = processDAO.getType();
                    processInstanceStateChangeEvent.setProcessName(qName);
                    QName qName2 = processDAO.getProcessId();
                    processInstanceStateChangeEvent.setProcessId(qName2);
                    DebuggerSupport.this._process.saveEvent((ProcessInstanceEvent)processInstanceStateChangeEvent, processInstanceDAO);
                    ProcessTerminationEvent processTerminationEvent = new ProcessTerminationEvent();
                    processTerminationEvent.setProcessInstanceId(l);
                    processTerminationEvent.setProcessName(qName);
                    processTerminationEvent.setProcessId(qName2);
                    DebuggerSupport.this._process.saveEvent((ProcessInstanceEvent)processInstanceStateChangeEvent, processInstanceDAO);
                    DebuggerSupport.this.onEvent((BpelEvent)processInstanceStateChangeEvent);
                    DebuggerSupport.this.onEvent((BpelEvent)processTerminationEvent);
                    return null;
                }
            });
        }
        catch (ManagementException managementException) {
            throw managementException;
        }
        catch (Exception exception) {
            __log.error((Object)"DbError", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public Object getProcessModel() {
        return this._process.getOProcess();
    }
}

