/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.DehydrationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountLRUDehydrationPolicy
implements DehydrationPolicy {
    private long _processMaxAge = 1200000L;
    private int _processMaxCount = 1000;

    @Override
    public List<BpelProcess> markForDehydration(List<BpelProcess> list) {
        ArrayList<BpelProcess> arrayList = new ArrayList<BpelProcess>();
        if (this._processMaxAge > 0L) {
            long l = System.currentTimeMillis();
            for (BpelProcess bpelProcess : list) {
                if (l - bpelProcess.getLastUsed() <= this._processMaxAge) continue;
                arrayList.add(bpelProcess);
            }
        }
        if (list.size() - arrayList.size() > this._processMaxCount) {
            list.removeAll(arrayList);
            Collections.sort(list, new Comparator<BpelProcess>(){

                @Override
                public int compare(BpelProcess bpelProcess, BpelProcess bpelProcess2) {
                    if (bpelProcess.getLastUsed() > bpelProcess2.getLastUsed()) {
                        return -1;
                    }
                    if (bpelProcess.getLastUsed() < bpelProcess2.getLastUsed()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (int i = this._processMaxCount; i < list.size(); ++i) {
                arrayList.add(list.get(i));
            }
        }
        return arrayList;
    }

    public void setProcessMaxAge(long l) {
        this._processMaxAge = l;
    }

    public void setProcessMaxCount(int n) {
        this._processMaxCount = n;
    }
}

