/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.List;
import java.util.concurrent.Future;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokeredMyRoleMessageExchangeImpl
extends MyRoleMessageExchangeImpl {
    private List<MyRoleMessageExchange> subscribers;
    private MyRoleMessageExchange template;

    public BrokeredMyRoleMessageExchangeImpl(BpelProcess bpelProcess, BpelEngineImpl bpelEngineImpl, List<MyRoleMessageExchange> list, MessageExchangeDAO messageExchangeDAO, MyRoleMessageExchange myRoleMessageExchange) {
        super(bpelProcess, bpelEngineImpl, messageExchangeDAO);
        this.subscribers = list;
        this.template = myRoleMessageExchange;
    }

    @Override
    public Future invoke(Message message) {
        Future future = null;
        for (MyRoleMessageExchange myRoleMessageExchange : this.subscribers) {
            Future future2 = myRoleMessageExchange.invoke(message);
            if (myRoleMessageExchange != this.template) continue;
            future = future2;
        }
        return future;
    }

    @Override
    public EndpointReference getEndpointReference() throws BpelEngineException {
        return this.template.getEndpointReference();
    }

    @Override
    public Message getResponse() {
        return this.template.getResponse();
    }

    @Override
    public MessageExchange.Status getStatus() {
        return this.template.getStatus();
    }

    @Override
    public MyRoleMessageExchange.CorrelationStatus getCorrelationStatus() {
        return this.template.getCorrelationStatus();
    }

    @Override
    public int getSubscriberCount() {
        return this.subscribers != null ? this.subscribers.size() : 0;
    }

    @Override
    public void setSubscriberCount(int n) {
        for (MyRoleMessageExchange myRoleMessageExchange : this.subscribers) {
            ((MyRoleMessageExchangeImpl)myRoleMessageExchange).setSubscriberCount(n);
        }
    }
}

